/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.utils;

import android.content.SharedPreferences;
import android.net.Uri;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.LinkedList;

public class SharedPreferenceUtils {
    public static boolean putData(SharedPreferences sp, String key, Object value) {
        boolean result;
        SharedPreferences.Editor editor = sp.edit();
        String type = value.getClass().getSimpleName();
        try {
            switch (type) {
                case "Boolean": {
                    editor.putBoolean(key, ((Boolean)value).booleanValue());
                    break;
                }
                case "Long": {
                    editor.putLong(key, ((Long)value).longValue());
                    break;
                }
                case "Float": {
                    editor.putFloat(key, ((Float)value).floatValue());
                    break;
                }
                case "String": {
                    editor.putString(key, (String)value);
                    break;
                }
                case "Integer": {
                    editor.putInt(key, ((Integer)value).intValue());
                    break;
                }
                default: {
                    Gson gson = new Gson();
                    String json = gson.toJson(value);
                    editor.putString(key, json);
                }
            }
            result = true;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        editor.apply();
        return result;
    }

    public static Object getData(SharedPreferences sp, String key, Object defaultValue) {
        Object result;
        String type = defaultValue.getClass().getSimpleName();
        try {
            switch (type) {
                case "Boolean": {
                    result = sp.getBoolean(key, ((Boolean)defaultValue).booleanValue());
                    break;
                }
                case "Long": {
                    result = sp.getLong(key, ((Long)defaultValue).longValue());
                    break;
                }
                case "Float": {
                    result = Float.valueOf(sp.getFloat(key, ((Float)defaultValue).floatValue()));
                    break;
                }
                case "String": {
                    result = sp.getString(key, (String)defaultValue);
                    break;
                }
                case "Integer": {
                    result = sp.getInt(key, ((Integer)defaultValue).intValue());
                    break;
                }
                default: {
                    Gson gson = new Gson();
                    String json = sp.getString(key, "");
                    if (!json.equals("") && json.length() > 0) {
                        result = gson.fromJson(json, defaultValue.getClass());
                        break;
                    }
                    result = defaultValue;
                    break;
                }
            }
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public static <T> boolean putListData(SharedPreferences sp, String key, LinkedList<T> list) {
        boolean result;
        SharedPreferences.Editor editor = sp.edit();
        JsonArray array2 = new JsonArray();
        if (list.size() <= 0) {
            editor.putString(key, array2.toString());
            editor.apply();
            return false;
        }
        String type = list.get(0).getClass().getSimpleName();
        try {
            switch (type) {
                case "Boolean": {
                    for (int i = 0; i < list.size(); ++i) {
                        array2.add((Boolean)list.get(i));
                    }
                    break;
                }
                case "Long": {
                    for (int i = 0; i < list.size(); ++i) {
                        array2.add((Number)((Long)list.get(i)));
                    }
                    break;
                }
                case "Float": {
                    for (int i = 0; i < list.size(); ++i) {
                        array2.add((Number)((Float)list.get(i)));
                    }
                    break;
                }
                case "String": {
                    for (int i = 0; i < list.size(); ++i) {
                        array2.add((String)list.get(i));
                    }
                    break;
                }
                case "Integer": {
                    for (int i = 0; i < list.size(); ++i) {
                        array2.add((Number)((Integer)list.get(i)));
                    }
                    break;
                }
                default: {
                    Gson gson = new GsonBuilder().registerTypeAdapter(Uri.class, (Object)new UriSerializer()).create();
                    for (int i = 0; i < list.size(); ++i) {
                        JsonElement obj = gson.toJsonTree(list.get(i));
                        array2.add(obj);
                    }
                }
            }
            editor.putString(key, array2.toString());
            result = true;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        editor.apply();
        return result;
    }

    public static <T> LinkedList<T> getListData(SharedPreferences sp, String key, Class<T> cls) {
        LinkedList<Object> list = new LinkedList<Object>();
        String json = sp.getString(key, "");
        if (!json.equals("") && json.length() > 0) {
            Gson gson = new GsonBuilder().registerTypeAdapter(Uri.class, (Object)new UriSerializer()).create();
            JsonArray array2 = new JsonParser().parse(json).getAsJsonArray();
            for (JsonElement elem : array2) {
                list.add(gson.fromJson(elem, cls));
            }
        }
        return list;
    }

    public static class UriSerializer
    implements JsonSerializer<Uri>,
    JsonDeserializer<Uri> {
        public JsonElement serialize(Uri src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        public Uri deserialize(JsonElement src, Type srcType, JsonDeserializationContext context) throws JsonParseException {
            return Uri.parse((String)src.getAsString());
        }
    }
}

