/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.utils;

import android.app.Activity;
import android.content.SharedPreferences;
import android.graphics.Rect;
import android.os.IBinder;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;

public class SoftKeyBoardUtil {
    private static int softKeyBoardHeight;
    private static int rootViewVisibleHeight;
    private static View rootView;
    private static SharedPreferences preferences;
    private static InputMethodManager imm;

    public static void calculateHeight(Activity activity) {
        ViewTreeObserver.OnGlobalLayoutListener listener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (softKeyBoardHeight != 0) {
                    return;
                }
                Rect r = new Rect();
                rootView.getWindowVisibleDisplayFrame(r);
                int visibleHeight = r.height();
                if (rootViewVisibleHeight == 0) {
                    rootViewVisibleHeight = visibleHeight;
                    return;
                }
                if (rootViewVisibleHeight == visibleHeight) {
                    return;
                }
                if (rootViewVisibleHeight - visibleHeight > 200) {
                    softKeyBoardHeight = rootViewVisibleHeight - visibleHeight - ScreenUtil.getNavigationBarHeight();
                    preferences.edit().putInt(TUIKitConstants.SOFT_KEY_BOARD_HEIGHT, softKeyBoardHeight).apply();
                    return;
                }
            }
        };
        rootView = activity.getWindow().getDecorView();
        rootView.getViewTreeObserver().addOnGlobalLayoutListener(listener);
    }

    public static int getSoftKeyBoardHeight() {
        if (softKeyBoardHeight != 0) {
            return softKeyBoardHeight;
        }
        softKeyBoardHeight = preferences.getInt(TUIKitConstants.SOFT_KEY_BOARD_HEIGHT, 0);
        if (softKeyBoardHeight == 0) {
            int height = SoftKeyBoardUtil.getScreenSize()[1];
            return height * 2 / 5;
        }
        return softKeyBoardHeight;
    }

    public static int[] getScreenSize() {
        int[] size = new int[2];
        DisplayMetrics dm = TUIKit.getAppContext().getResources().getDisplayMetrics();
        size[0] = dm.widthPixels;
        size[1] = dm.heightPixels;
        return size;
    }

    public static void SoftKeyboardStateHelper(final View activityRootView, final SoftKeyboardStateListener listener) {
        activityRootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                boolean visible;
                Rect r = new Rect();
                activityRootView.getWindowVisibleDisplayFrame(r);
                int screenHeight = activityRootView.getRootView().getHeight();
                int heightDifference = screenHeight - r.bottom;
                boolean bl = visible = heightDifference > screenHeight / 3;
                if (visible) {
                    listener.onSoftKeyboardOpened(heightDifference);
                } else {
                    listener.onSoftKeyboardClosed();
                }
            }
        });
    }

    public static void hideKeyBoard(EditText editor) {
        imm.hideSoftInputFromWindow(editor.getWindowToken(), 0);
    }

    public static void hideKeyBoard(IBinder token) {
        imm.hideSoftInputFromWindow(token, 0);
    }

    static {
        preferences = TUIKit.getAppContext().getSharedPreferences(TUIKitConstants.UI_PARAMS, 0);
        imm = (InputMethodManager)TUIKit.getAppContext().getSystemService("input_method");
    }

    public static interface SoftKeyboardStateListener {
        public void onSoftKeyboardOpened(int var1);

        public void onSoftKeyboardClosed();
    }
}

