/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.java.util.HexFormat;
import com.tencent.kona.jdk.internal.util.ArraysSupport;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

final class AEADBufferedStream
extends ByteArrayOutputStream {
    public AEADBufferedStream(int len) {
        super(len);
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    private void checkCapacity(int len) {
        int blen = this.buf.length;
        if (blen < this.count + len) {
            this.buf = Arrays.copyOf(this.buf, ArraysSupport.newLength(blen, len, blen));
        }
    }

    public void write(ByteBuffer src) {
        int pos = src.position();
        int len = src.remaining();
        if (src.hasArray()) {
            this.write(src.array(), pos + src.arrayOffset(), len);
            src.position(pos + len);
            return;
        }
        this.checkCapacity(len);
        src.get(this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void write(byte[] in, int offset, int len) {
        this.checkCapacity(len);
        System.arraycopy(in, offset, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public String toString() {
        return this.count == 0 ? "null" : HexFormat.of().formatHex(this.buf);
    }
}

