/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.util.Sweeper;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.security.KeyRep;
import java.security.MessageDigest;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

final class PBEKey
implements SecretKey {
    private static final long serialVersionUID = -2234768909660948176L;
    private byte[] key;
    private final String type;
    private final Sweeper sweeper = Sweeper.instance();

    PBEKey(PBEKeySpec keySpec, String keytype, boolean useCleaner) throws InvalidKeySpecException {
        int i;
        char[] passwd = keySpec.getPassword();
        if (passwd == null) {
            passwd = new char[]{};
        }
        if (passwd.length != 1 || passwd[0] != '\u0000') {
            for (i = 0; i < passwd.length; ++i) {
                if (passwd[i] >= ' ' && passwd[i] <= '~') continue;
                throw new InvalidKeySpecException("Password is not ASCII");
            }
        }
        this.key = new byte[passwd.length];
        for (i = 0; i < passwd.length; ++i) {
            this.key[i] = (byte)(passwd[i] & 0x7F);
        }
        Arrays.fill(passwd, '\u0000');
        this.type = keytype;
        if (useCleaner) {
            byte[] k = this.key;
            this.sweeper.register(this, () -> Arrays.fill(k, (byte)0));
        }
    }

    @Override
    public byte[] getEncoded() {
        byte[] result = (byte[])this.key.clone();
        return result;
    }

    @Override
    public String getAlgorithm() {
        return this.type;
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        return Arrays.hashCode(this.key) ^ this.getAlgorithm().toLowerCase(Locale.ENGLISH).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SecretKey)) {
            return false;
        }
        SecretKey that = (SecretKey)obj;
        if (!that.getAlgorithm().equalsIgnoreCase(this.type)) {
            return false;
        }
        byte[] thatEncoded = that.getEncoded();
        boolean ret = MessageDigest.isEqual(this.key, thatEncoded);
        Arrays.fill(thatEncoded, (byte)0);
        return ret;
    }

    @Override
    public void destroy() {
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.key == null) {
            throw new InvalidObjectException("PBEKey couldn't be deserialized");
        }
        byte[] temp = this.key;
        this.key = (byte[])temp.clone();
        Arrays.fill(temp, (byte)0);
        if (this.key.length != 1 || this.key[0] != 0) {
            for (int i = 0; i < this.key.length; ++i) {
                if (this.key[i] >= 32 && this.key[i] <= 126) continue;
                throw new InvalidObjectException("PBEKey had non-ASCII chars");
            }
        }
        byte[] k = this.key;
        this.sweeper.register(this, () -> Arrays.fill(k, (byte)0));
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.key);
    }
}

