/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.sun.security.util.Debug;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;

public final class PBEParameters
extends AlgorithmParametersSpi {
    private byte[] salt = null;
    private int iCount = 0;
    private AlgorithmParameterSpec cipherParam = null;

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.salt = (byte[])((PBEParameterSpec)paramSpec).getSalt().clone();
        this.iCount = ((PBEParameterSpec)paramSpec).getIterationCount();
        this.cipherParam = ((PBEParameterSpec)paramSpec).getParameterSpec();
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        try {
            DerValue val = new DerValue(encoded);
            if (val.tag != 48) {
                throw new IOException("PBE parameter parsing error: not a sequence");
            }
            val.data.reset();
            this.salt = val.data.getOctetString();
            this.iCount = val.data.getInteger();
            if (val.data.available() != 0) {
                throw new IOException("PBE parameter parsing error: extra data");
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("iteration count too big");
        }
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        this.engineInit(encoded);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec.isAssignableFrom(PBEParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(new PBEParameterSpec(this.salt, this.iCount, this.cipherParam)));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        bytes.putOctetString(this.salt);
        bytes.putInteger(this.iCount);
        out.write((byte)48, bytes);
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        String LINE_SEP = System.lineSeparator();
        String saltString = LINE_SEP + "    salt:" + LINE_SEP + "[";
        HexDumpEncoder encoder = new HexDumpEncoder();
        saltString = saltString + encoder.encodeBuffer(this.salt);
        saltString = saltString + "]";
        return saltString + LINE_SEP + "    iterationCount:" + LINE_SEP + Debug.toHexString(BigInteger.valueOf(this.iCount)) + LINE_SEP;
    }
}

