/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.provider.CipherCore;
import com.tencent.kona.crypto.provider.PBKDF2Core;
import com.tencent.kona.crypto.provider.PBKDF2KeyImpl;
import com.tencent.kona.crypto.provider.SM4Crypt;
import com.tencent.kona.jdk.internal.misc.SharedSecretsUtil;
import com.tencent.kona.sun.security.jca.JCAUtil;
import com.tencent.kona.sun.security.util.PBEUtil;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

abstract class PBES2Core
extends CipherSpi {
    private final CipherCore cipher;
    private final int keyLength;
    private final int blkSize;
    private final PBKDF2Core kdf;
    private final String pbeAlgo;
    private final String cipherAlgo;
    private final PBEUtil.PBES2Params pbes2Params = new PBEUtil.PBES2Params();

    PBES2Core(String kdfAlgo, String cipherAlgo, int keySize) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipherAlgo = cipherAlgo;
        this.keyLength = keySize * 8;
        this.pbeAlgo = "SM4".equalsIgnoreCase(cipherAlgo) ? "PBEWith" + kdfAlgo + "And" + cipherAlgo : "PBEWith" + kdfAlgo + "And" + cipherAlgo + "_" + this.keyLength;
        if ("SM4".equalsIgnoreCase(cipherAlgo)) {
            this.blkSize = 16;
            this.cipher = new CipherCore(new SM4Crypt(), this.blkSize);
            switch (kdfAlgo) {
                case "HmacSM3": {
                    this.kdf = new PBKDF2Core.HmacSM3();
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException("No Cipher implementation for " + kdfAlgo);
                }
            }
        } else {
            throw new NoSuchAlgorithmException("No Cipher implementation for " + this.pbeAlgo);
        }
        this.cipher.setMode("CBC");
        this.cipher.setPadding("PKCS5Padding");
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode != null && !mode.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (paddingScheme != null && !paddingScheme.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Invalid padding scheme: " + paddingScheme);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blkSize;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.cipher.getOutputSize(inputLen);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.cipher.getIV();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.pbes2Params.getAlgorithmParameters(this.blkSize, this.pbeAlgo, JCAUtil.getSecureRandom());
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException ie) {
            throw new InvalidKeyException("requires PBE parameters", ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] derivedKey;
        block10: {
            PBEKeySpec pbeSpec = this.pbes2Params.getPBEKeySpec(this.blkSize, this.keyLength, opmode, key, params, random);
            PBKDF2KeyImpl s = null;
            try {
                s = (PBKDF2KeyImpl)this.kdf.engineGenerateSecret(pbeSpec);
                derivedKey = s.getEncoded();
            }
            catch (InvalidKeySpecException ikse) {
                throw new InvalidKeyException("Cannot construct PBE key", ikse);
            }
            finally {
                if (s != null) {
                    s.clear();
                }
                pbeSpec.clearPassword();
            }
            SecretKeySpec cipherKey = null;
            try {
                cipherKey = new SecretKeySpec(derivedKey, this.cipherAlgo);
                this.cipher.init(opmode, (Key)cipherKey, this.pbes2Params.getIvSpec(), random);
                if (cipherKey == null) break block10;
            }
            catch (Throwable throwable) {
                if (cipherKey != null) {
                    SharedSecretsUtil.cryptoSpecClearSecretKeySpec(cipherKey);
                }
                Arrays.fill(derivedKey, (byte)0);
                throw throwable;
            }
            SharedSecretsUtil.cryptoSpecClearSecretKeySpec(cipherKey);
        }
        Arrays.fill(derivedKey, (byte)0);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, PBEUtil.PBES2Params.getParameterSpec(params), random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.update(input, inputOffset, inputLen);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.cipher.update(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inputOffset, inputLen);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return this.keyLength;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.cipher.wrap(key);
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.cipher.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    public static final class HmacSM3AndSM4
    extends PBES2Core {
        public HmacSM3AndSM4() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSM3", "SM4", 16);
        }
    }
}

