/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.util.Arrays;

public final class SM2PrivateKey
implements ECPrivateKey {
    private static final long serialVersionUID = 8891019868158427133L;
    private final BigInteger keyS;
    private final byte[] encoded;

    public SM2PrivateKey(byte[] key) {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("Missing encoded private key");
        }
        if (key.length != 32 && (key.length != 33 || key[0] != 0)) {
            throw new IllegalArgumentException("Private key must be 32-bytes");
        }
        this.keyS = new BigInteger(1, key);
        this.encoded = CryptoUtils.priKey(this.keyS);
    }

    public SM2PrivateKey(BigInteger keyS) {
        if (keyS == null) {
            throw new IllegalArgumentException("Missing private key");
        }
        this.encoded = CryptoUtils.priKey(keyS);
        this.keyS = keyS;
    }

    public SM2PrivateKey(ECPrivateKey ecPrivateKey) {
        this(ecPrivateKey.getS());
    }

    @Override
    public String getAlgorithm() {
        return "SM2";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    @Override
    public BigInteger getS() {
        return this.keyS;
    }

    @Override
    public ECParameterSpec getParams() {
        return SM2ParameterSpec.instance();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SM2PrivateKey that = (SM2PrivateKey)o;
        return Arrays.equals(this.encoded, that.encoded);
    }

    public int hashCode() {
        return Arrays.hashCode(this.encoded);
    }
}

