/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;

public final class SM2PublicKey
implements ECPublicKey {
    private static final long serialVersionUID = 682873544399078680L;
    private final byte[] encoded;
    private final transient ECPoint pubPoint;

    public SM2PublicKey(byte[] encoded) {
        if (encoded == null || encoded.length == 0) {
            throw new IllegalArgumentException("Missing encoded public key");
        }
        this.pubPoint = CryptoUtils.pubKeyPoint(encoded);
        this.encoded = (byte[])encoded.clone();
    }

    public SM2PublicKey(ECPoint pubPoint) {
        if (pubPoint == null) {
            throw new IllegalArgumentException("Missing public key");
        }
        if (pubPoint.equals(ECPoint.POINT_INFINITY)) {
            throw new IllegalArgumentException("Public point cannot be infinite point");
        }
        this.encoded = CryptoUtils.pubKey(pubPoint);
        this.pubPoint = pubPoint;
    }

    public SM2PublicKey(ECPublicKey ecPublicKey) {
        this(ecPublicKey.getW());
    }

    @Override
    public String getAlgorithm() {
        return "SM2";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    @Override
    public ECPoint getW() {
        return this.pubPoint;
    }

    @Override
    public ECParameterSpec getParams() {
        return SM2ParameterSpec.instance();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SM2PublicKey that = (SM2PublicKey)o;
        return Arrays.equals(this.encoded, that.encoded);
    }

    public int hashCode() {
        return Arrays.hashCode(this.encoded);
    }
}

