/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.provider.SM2PrivateKey;
import com.tencent.kona.crypto.provider.SM2PublicKey;
import com.tencent.kona.crypto.provider.SM3MessageDigest;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import com.tencent.kona.crypto.spec.SM2SignatureParameterSpec;
import com.tencent.kona.sun.security.ec.ECOperations;
import com.tencent.kona.sun.security.ec.point.MutablePoint;
import com.tencent.kona.sun.security.jca.JCAUtil;
import com.tencent.kona.sun.security.util.ArrayUtil;
import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.ECUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;

public final class SM2Signature
extends SignatureSpi {
    private static final byte[] DEFAULT_ID = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    private SM2PrivateKey privateKey;
    private SM2PublicKey publicKey;
    private byte[] id;
    private SecureRandom random;
    private byte[] z;
    private final MessageDigest sm3MD = new SM3MessageDigest();
    private static final byte[] A = CryptoUtils.bigIntToBytes32(SM2ParameterSpec.CURVE.getA());
    private static final byte[] B = CryptoUtils.bigIntToBytes32(SM2ParameterSpec.CURVE.getB());
    private static final byte[] GEN_X = CryptoUtils.bigIntToBytes32(SM2ParameterSpec.GENERATOR.getAffineX());
    private static final byte[] GEN_Y = CryptoUtils.bigIntToBytes32(SM2ParameterSpec.GENERATOR.getAffineY());

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.privateKey = null;
        this.z = null;
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Only ECPrivateKey accepted!");
        }
        ECPrivateKey ecPrivateKey = (ECPrivateKey)privateKey;
        BigInteger s = ecPrivateKey.getS();
        if (s.compareTo(BigInteger.ZERO) <= 0 || s.compareTo(SM2ParameterSpec.ORDER.subtract(BigInteger.ONE)) >= 0) {
            throw new InvalidKeyException("The private key must be within the range [1, n - 2]");
        }
        this.privateKey = new SM2PrivateKey(ecPrivateKey);
        SecureRandom secureRandom = this.random = random != null ? random : JCAUtil.getSecureRandom();
        if (this.publicKey == null) {
            this.publicKey = new SM2PublicKey(ECOperations.toECPoint(ECOperations.SM2OPS.multiply(SM2ParameterSpec.GENERATOR, CryptoUtils.toByteArrayLE(ecPrivateKey.getS()))));
        }
        this.resetDigest();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.privateKey = null;
        this.publicKey = null;
        this.z = null;
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("Only ECPublicKey accepted!");
        }
        this.publicKey = new SM2PublicKey((ECPublicKey)publicKey);
        this.resetDigest();
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.privateKey = null;
        this.publicKey = null;
        this.id = null;
        if (!(params instanceof SM2SignatureParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Only accept SM2SignatureParameterSpec");
        }
        SM2SignatureParameterSpec paramSpec = (SM2SignatureParameterSpec)params;
        this.publicKey = new SM2PublicKey(paramSpec.getPublicKey());
        this.id = paramSpec.getId();
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("Use setParameter(AlgorithmParameterSpec params) instead");
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter(String param) not supported");
    }

    private void resetDigest() {
        this.sm3MD.reset();
        if (this.z == null) {
            this.z = this.z();
        }
        this.sm3MD.update(this.z);
    }

    private byte[] getDigestValue() {
        byte[] digest = this.sm3MD.digest();
        this.resetDigest();
        return digest;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.sm3MD.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.sm3MD.update(b, off, len);
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        int len = byteBuffer.remaining();
        if (len <= 0) {
            return;
        }
        this.sm3MD.update(byteBuffer);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        BigInteger s;
        BigInteger k;
        MutablePoint p;
        BigInteger r;
        if (this.privateKey == null) {
            throw new SignatureException("Private key not initialized");
        }
        BigInteger d = this.privateKey.getS();
        byte[] eHash = this.getDigestValue();
        BigInteger e = new BigInteger(1, eHash);
        do {
            byte[] kArr = this.nextK();
            p = ECOperations.SM2OPS.multiply(SM2ParameterSpec.GENERATOR, kArr);
            ArrayUtil.reverse(kArr);
            k = new BigInteger(1, kArr);
        } while ((r = e.add(p.asAffine().toECPoint().getAffineX()).mod(SM2ParameterSpec.ORDER)).equals(BigInteger.ZERO) || r.add(k).equals(SM2ParameterSpec.ORDER) || (s = d.add(BigInteger.ONE).modInverse(SM2ParameterSpec.ORDER).multiply(k.subtract(r.multiply(d)).mod(SM2ParameterSpec.ORDER)).mod(SM2ParameterSpec.ORDER)).equals(BigInteger.ZERO));
        return this.encodeSignature(r, s);
    }

    private byte[] nextK() {
        return ECOperations.SM2OPS.generatePrivateScalar(this.random);
    }

    private byte[] encodeSignature(BigInteger r, BigInteger s) throws SignatureException {
        try {
            DerOutputStream out = new DerOutputStream();
            out.putInteger(r);
            out.putInteger(s);
            DerValue result = new DerValue(48, out.toByteArray());
            return result.toByteArray();
        }
        catch (Exception e) {
            throw new SignatureException("Could not encode signature", e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (this.publicKey == null) {
            throw new SignatureException("Public key not initialized");
        }
        ECPoint publicPoint = this.publicKey.getW();
        try {
            ECUtil.validatePublicKey(publicPoint, SM2ParameterSpec.instance());
        }
        catch (InvalidKeyException e) {
            return false;
        }
        BigInteger[] values = this.decodeSignature(sigBytes);
        BigInteger r = values[0];
        BigInteger s = values[1];
        if (r.compareTo(BigInteger.ONE) < 0 || r.compareTo(SM2ParameterSpec.ORDER) >= 0) {
            return false;
        }
        if (s.compareTo(BigInteger.ONE) < 0 || s.compareTo(SM2ParameterSpec.ORDER) >= 0) {
            return false;
        }
        byte[] eHash = this.getDigestValue();
        BigInteger e = new BigInteger(1, eHash);
        BigInteger t = r.add(s).mod(SM2ParameterSpec.ORDER);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        MutablePoint p = ECOperations.SM2OPS.multiply(SM2ParameterSpec.GENERATOR, CryptoUtils.toByteArrayLE(s));
        MutablePoint p2 = ECOperations.SM2OPS.multiply(publicPoint, CryptoUtils.toByteArrayLE(t));
        ECOperations.SM2OPS.setSum(p, p2);
        if (ECOperations.isInfinitePoint(p)) {
            return false;
        }
        ECPoint point = ECOperations.toECPoint(p);
        BigInteger expectedR = e.add(point.getAffineX()).mod(SM2ParameterSpec.ORDER);
        return expectedR.equals(r);
    }

    private BigInteger[] decodeSignature(byte[] signature) throws SignatureException {
        try {
            DerInputStream in = new DerInputStream(signature, 0, signature.length, false);
            DerValue[] values = in.getSequence(2);
            if (values.length != 2 || in.available() != 0) {
                throw new IOException("Invalid encoding for signature");
            }
            BigInteger r = values[0].getPositiveBigInteger();
            BigInteger s = values[1].getPositiveBigInteger();
            return new BigInteger[]{r, s};
        }
        catch (Exception e) {
            throw new SignatureException("Could not decode signature", e);
        }
    }

    private byte[] z() {
        SM3MessageDigest md = new SM3MessageDigest();
        byte[] userId = this.id == null ? DEFAULT_ID : this.id;
        int userIdLen = userId.length << 3;
        md.update((byte)(userIdLen >>> 8));
        md.update((byte)userIdLen);
        md.update(userId);
        md.update(A);
        md.update(B);
        md.update(GEN_X);
        md.update(GEN_Y);
        ECPoint pubPoint = this.publicKey.getW();
        md.update(CryptoUtils.bigIntToBytes32(pubPoint.getAffineX()));
        md.update(CryptoUtils.bigIntToBytes32(pubPoint.getAffineY()));
        return md.digest();
    }
}

