/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.DerValue;
import com.tencent.kona.sun.security.util.HexDumpEncoder;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class SM4Parameters
extends AlgorithmParametersSpi {
    private byte[] iv = null;
    private int tagLen = -1;
    private byte[] encoded;

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        byte[] tmpIv;
        if (!(paramSpec instanceof IvParameterSpec) && !(paramSpec instanceof GCMParameterSpec)) {
            throw new InvalidParameterSpecException("Only IvParameterSpec and GCMParameterSpec are supported");
        }
        if (paramSpec instanceof IvParameterSpec) {
            tmpIv = ((IvParameterSpec)paramSpec).getIV();
            if (tmpIv.length != 16) {
                throw new InvalidParameterSpecException("IV must be 16-bytes: " + tmpIv.length);
            }
        } else {
            tmpIv = ((GCMParameterSpec)paramSpec).getIV();
            if (tmpIv.length != 12) {
                throw new InvalidParameterSpecException("GCM IV must be 12-bytes: " + tmpIv.length);
            }
            int tmpTagLen = ((GCMParameterSpec)paramSpec).getTLen() >> 3;
            if (tmpTagLen != 16) {
                throw new InvalidParameterSpecException("GCM tag must be 16-bytes: " + tmpTagLen);
            }
            this.tagLen = tmpTagLen;
        }
        this.iv = (byte[])tmpIv.clone();
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        if (encoded == null || encoded.length == 0) {
            throw new IOException("Encoded parameters must be null or empty");
        }
        this.encoded = (byte[])encoded.clone();
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        if (decodingMethod != null && !decodingMethod.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        this.engineInit(encoded);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (IvParameterSpec.class.isAssignableFrom(paramSpec)) {
            if (this.iv == null) {
                try {
                    this.decode();
                }
                catch (IOException e) {
                    throw new InvalidParameterSpecException("Decode parameters failed: " + e.getMessage());
                }
            }
            return (T)((AlgorithmParameterSpec)paramSpec.cast(new IvParameterSpec(this.iv)));
        }
        if (GCMParameterSpec.class.isAssignableFrom(paramSpec)) {
            if (this.iv == null) {
                try {
                    this.gcmDecode();
                }
                catch (IOException e) {
                    throw new InvalidParameterSpecException("Decode GCM parameters failed: " + e.getMessage());
                }
            }
            if (this.tagLen == 16) {
                return (T)((AlgorithmParameterSpec)paramSpec.cast(new GCMParameterSpec(this.tagLen, this.iv)));
            }
            throw new InvalidParameterSpecException("Invalid tag size: " + this.tagLen);
        }
        throw new InvalidParameterSpecException("Only IvParameterSpec and GCMParameterSpec are supported");
    }

    private void decode() throws IOException {
        DerInputStream der = new DerInputStream(this.encoded);
        byte[] tmpIv = der.getOctetString();
        if (der.available() != 0) {
            throw new IOException("IV parsing error: extra data");
        }
        if (tmpIv.length != 16) {
            throw new IOException("IV is not 16-bytes: " + tmpIv.length);
        }
        this.iv = tmpIv;
    }

    private void gcmDecode() throws IOException {
        int tagLen;
        byte[] iv;
        DerValue val = new DerValue(this.encoded);
        if (val.tag == 48) {
            iv = val.data.getOctetString();
            tagLen = -1;
            if (val.data.available() != 0) {
                tagLen = val.data.getInteger();
                if (tagLen != 16) {
                    throw new IOException("GCM parameter parsing error: unsupported tag len: " + tagLen);
                }
                if (val.data.available() != 0) {
                    throw new IOException("GCM parameter parsing error: extra data");
                }
            }
        } else {
            throw new IOException("GCM parameter parsing error: no SEQ tag");
        }
        this.iv = iv;
        this.tagLen = tagLen;
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return this.tagLen == -1 ? this.encode() : this.gcmEncode();
    }

    private byte[] encode() throws IOException {
        DerOutputStream out = new DerOutputStream();
        out.putOctetString(this.iv);
        return out.toByteArray();
    }

    private byte[] gcmEncode() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        bytes.putOctetString(this.iv);
        bytes.putInteger(16);
        out.write((byte)48, bytes);
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        String LINE_SEP = System.lineSeparator();
        String ivString = LINE_SEP + "    iv:" + LINE_SEP + "[";
        HexDumpEncoder encoder = new HexDumpEncoder();
        ivString = ivString + encoder.encodeBuffer(this.iv);
        ivString = ivString + "]" + LINE_SEP;
        return ivString;
    }
}

