/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.provider.nativeImpl.SM4Params;
import com.tencent.kona.crypto.provider.nativeImpl.SymmetricCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;

class AlgoCipher {
    private final SymmetricCipher embeddedCipher;
    private State state = State.NOT_INIT;

    AlgoCipher(SymmetricCipher embeddedCipher) {
        this.embeddedCipher = embeddedCipher;
    }

    final SymmetricCipher getEmbeddedCipher() {
        return this.embeddedCipher;
    }

    final State state() {
        return this.state;
    }

    final int getBlockSize() {
        return this.embeddedCipher.getBlockSize();
    }

    final SM4Params getParamSpec() {
        return this.embeddedCipher.getParamSpec();
    }

    final byte[] getIV() {
        return this.getParamSpec().iv();
    }

    void init(boolean decrypting, String algorithm, byte[] key, SM4Params paramSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.state = State.INIT;
        this.embeddedCipher.init(decrypting, algorithm, key, paramSpec);
    }

    void reset() {
    }

    byte[] encrypt(byte[] plain, int plainOffset, int plainLen) {
        this.state = State.UPDATED;
        return this.embeddedCipher.encryptBlock(plain, plainOffset, plainLen);
    }

    byte[] encryptFinal(byte[] plain, int plainOffset, int plainLen) {
        this.state = State.FINAL;
        return this.embeddedCipher.encryptBlockFinal(plain, plainOffset, plainLen);
    }

    byte[] decrypt(byte[] cipher, int cipherOffset, int cipherLen) {
        this.state = State.UPDATED;
        return this.embeddedCipher.decryptBlock(cipher, cipherOffset, cipherLen);
    }

    byte[] decryptFinal(byte[] cipher, int cipherOffset, int cipherLen) {
        this.state = State.FINAL;
        return this.embeddedCipher.decryptBlockFinal(cipher, cipherOffset, cipherLen);
    }

    void updateAAD(byte[] src, int offset, int len) {
        this.checkState();
        this.getEmbeddedCipher().updateAAD(CryptoUtils.copy(src, offset, len));
    }

    private void checkState() {
        State state = this.state();
        if (state == State.NOT_INIT) {
            throw new IllegalStateException("Cipher is not initialized yet");
        }
        if (state == State.UPDATED || state == State.FINAL) {
            throw new IllegalStateException("update/doFinal was called, so cannot accept more AAD.");
        }
    }

    static enum State {
        NOT_INIT,
        INIT,
        UPDATED,
        FINAL;

    }
}

