/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import java.util.Arrays;

public class ByteArrayWriter {
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private byte[] buf;
    private int size;

    public ByteArrayWriter(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    public ByteArrayWriter() {
        this(128);
    }

    public ByteArrayWriter(byte[] initData) {
        if (initData == null || initData.length == 0) {
            throw new IllegalArgumentException("Null or empty byte array");
        }
        this.buf = (byte[])initData.clone();
        this.size = initData.length;
    }

    public void write(int b) {
        this.ensureCapacity(this.size + 1);
        this.buf[this.size] = (byte)b;
        ++this.size;
    }

    public void write(byte[] src) {
        this.write(src, 0, src.length);
    }

    public void write(byte[] src, int off, int len) {
        if (off < 0 || off > src.length || len < 0 || off + len - src.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.size + len);
        System.arraycopy(src, off, this.buf, this.size, len);
        this.size += len;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ByteArrayWriter.hugeCapacity(minCapacity);
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public void reset() {
        Arrays.fill(this.buf, (byte)0);
        this.size = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.size);
    }

    public int size() {
        return this.size;
    }

    byte[] buf() {
        return Arrays.copyOf(this.buf, this.buf.length);
    }

    int capacity() {
        return this.buf.length;
    }
}

