/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.AlgoCipher;
import com.tencent.kona.crypto.provider.nativeImpl.ConstructKeys;
import com.tencent.kona.crypto.provider.nativeImpl.Mode;
import com.tencent.kona.crypto.provider.nativeImpl.Padding;
import com.tencent.kona.crypto.provider.nativeImpl.SM4Params;
import com.tencent.kona.crypto.provider.nativeImpl.SymmetricCipher;
import com.tencent.kona.sun.security.jca.JCAUtil;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

final class CipherCore {
    private final byte[] buffer;
    private int buffered = 0;
    private Padding padding;
    private Mode cipherMode = Mode.ECB;
    private volatile AlgoCipher cipher;
    private boolean decrypting = false;
    private boolean requireReinit = false;
    private byte[] lastEncKey = null;
    private byte[] lastEncIv = null;
    private final SymmetricCipher rawImpl;

    CipherCore(SymmetricCipher impl) {
        this.rawImpl = impl;
        this.buffer = new byte[32];
    }

    void setMode(String mode) throws NoSuchAlgorithmException {
        Objects.requireNonNull(mode);
        String modeUpperCase = mode.toUpperCase(Locale.ENGLISH);
        if (modeUpperCase.equals("ECB")) {
            this.cipherMode = Mode.ECB;
        } else if (modeUpperCase.equals("CBC")) {
            this.cipherMode = Mode.CBC;
        } else if (modeUpperCase.equals("GCM")) {
            this.cipherMode = Mode.GCM;
        } else if (modeUpperCase.equals("CTR")) {
            this.cipherMode = Mode.CTR;
            this.padding = Padding.NoPadding;
        } else {
            throw new NoSuchAlgorithmException("Unknown mode: " + mode);
        }
        this.cipher = new AlgoCipher(this.rawImpl);
    }

    void setPadding(String paddingScheme) throws NoSuchPaddingException {
        if (paddingScheme == null) {
            throw new NoSuchPaddingException("null padding");
        }
        if (paddingScheme.equalsIgnoreCase("NOPADDING")) {
            this.padding = Padding.NoPadding;
        } else {
            if (!paddingScheme.equalsIgnoreCase("PKCS7PADDING")) {
                throw new NoSuchPaddingException("Padding: " + paddingScheme + " not implemented");
            }
            if (this.cipherMode == Mode.CTR || this.cipherMode == Mode.GCM) {
                throw new NoSuchPaddingException("Padding: " + paddingScheme + " not supported");
            }
            this.padding = Padding.PKCS7Padding;
        }
    }

    int getOutputSize(int inputLen) {
        int totalLen = Math.addExact(this.buffered, inputLen);
        int incr = 0;
        if (!this.decrypting) {
            if (this.cipherMode == Mode.GCM) {
                incr = 16;
            } else if (this.padding == Padding.PKCS7Padding) {
                incr = 16 - totalLen % 16;
            }
        } else if (this.cipherMode == Mode.GCM) {
            incr = -16;
        }
        return Math.max(0, totalLen + incr);
    }

    byte[] getIV() {
        return this.cipher.getIV();
    }

    AlgorithmParameters getParameters(String algName, String provider) {
        AlgorithmParameters params;
        if (this.cipherMode == Mode.ECB) {
            return null;
        }
        byte[] iv = this.getIV();
        if (iv == null) {
            iv = new byte[16];
            JCAUtil.getSecureRandom().nextBytes(iv);
        }
        AlgorithmParameterSpec paramSpec = this.cipherMode == Mode.GCM ? new GCMParameterSpec(128, iv) : new IvParameterSpec(iv);
        try {
            params = provider != null ? AlgorithmParameters.getInstance("SM4", provider) : AlgorithmParameters.getInstance("SM4");
            params.init(paramSpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Cannot find " + algName + " AlgorithmParameters implementation in SMCS provider");
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException(paramSpec.getClass() + " not supported");
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Cannot find SMCS provider", e);
        }
        return params;
    }

    AlgorithmParameters getParameters(String algName) {
        return this.getParameters(algName, null);
    }

    void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.init(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void init(int opmode, Key key, AlgorithmParameterSpec paramSpec, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.decrypting = opmode == 2 || opmode == 4;
        byte[] keyBytes = CipherCore.getKeyBytes(key);
        byte[] iv = null;
        if (paramSpec != null) {
            if (this.cipherMode == Mode.GCM) {
                if (!(paramSpec instanceof GCMParameterSpec)) throw new InvalidAlgorithmParameterException("Unsupported parameter: " + paramSpec);
                int tagLenBits = ((GCMParameterSpec)paramSpec).getTLen();
                if (tagLenBits != 128) {
                    throw new InvalidAlgorithmParameterException("The length of GCM Tag must be 16-bytes.");
                }
                iv = ((GCMParameterSpec)paramSpec).getIV();
            } else {
                if (!(paramSpec instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("Unsupported parameter: " + paramSpec);
                iv = ((IvParameterSpec)paramSpec).getIV();
            }
        }
        if (this.cipherMode == Mode.ECB) {
            if (iv != null) {
                throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
            }
        } else if (iv == null) {
            if (this.decrypting) {
                throw new InvalidAlgorithmParameterException("Parameters IV for decrypting missing must be set with SetParameter()");
            }
            iv = new byte[16];
            if (random != null) {
                random.nextBytes(iv);
            } else {
                JCAUtil.getSecureRandom().nextBytes(iv);
            }
        }
        this.buffered = 0;
        if (this.cipherMode == Mode.GCM && !this.decrypting) {
            boolean bl = this.requireReinit = Arrays.equals(iv, this.lastEncIv) && MessageDigest.isEqual(keyBytes, this.lastEncKey);
            if (this.requireReinit) {
                throw new InvalidAlgorithmParameterException("Cannot reuse IV for GCM mode");
            }
            this.lastEncIv = iv;
            this.lastEncKey = keyBytes;
        }
        SM4Params sm4ParamSpec = new SM4Params(this.cipherMode, this.padding, iv);
        this.cipher.init(this.decrypting, key.getAlgorithm(), keyBytes, sm4ParamSpec);
        this.requireReinit = false;
    }

    void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec spec = null;
        if (params != null) {
            try {
                spec = this.cipherMode == Mode.GCM ? params.getParameterSpec(GCMParameterSpec.class) : params.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type");
            }
        }
        this.init(opmode, key, spec, random);
    }

    static byte[] getKeyBytes(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        if (!"RAW".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] keyBytes = key.getEncoded();
        if (keyBytes == null) {
            throw new InvalidKeyException("RAW key bytes missing");
        }
        return keyBytes;
    }

    byte[] update(byte[] input, int inputOffset, int inputLen) {
        this.checkReinit();
        byte[] data = !this.decrypting ? this.cipher.encrypt(input, inputOffset, inputLen) : this.cipher.decrypt(input, inputOffset, inputLen);
        this.buffered = this.buffered(this.buffered, inputLen, data.length);
        return data;
    }

    int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.checkReinit();
        byte[] data = !this.decrypting ? this.cipher.encrypt(input, inputOffset, inputLen) : this.cipher.decrypt(input, inputOffset, inputLen);
        this.buffered = this.buffered(this.buffered, inputLen, data.length);
        System.arraycopy(data, 0, output, outputOffset, data.length);
        return data.length;
    }

    private int buffered(int origBuffered, int inputLen, int outputLen) {
        int buffered = 0;
        if (this.decrypting) {
            return buffered;
        }
        buffered = outputLen == 0 ? Math.addExact(origBuffered, inputLen) : Math.subtractExact(Math.addExact(origBuffered, inputLen), outputLen);
        return buffered;
    }

    byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException {
        try {
            this.checkReinit();
            byte[] output = new byte[this.getOutputSize(inputLen)];
            byte[] finalBuf = this.prepareInputBuffer(input, inputOffset, inputLen, output, 0);
            int finalOffset = finalBuf == input ? inputOffset : 0;
            int finalBufLen = finalBuf == input ? inputLen : finalBuf.length;
            byte[] ot = this.encDecOutput(finalBuf, finalOffset, finalBufLen);
            this.endDoFinal();
            return ot;
        }
        catch (ShortBufferException e) {
            throw new ProviderException("Unexpected exception", e);
        }
    }

    int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException {
        byte[] out = this.doFinal(input, inputOffset, inputLen);
        int len = Math.min(out.length, output.length - outputOffset);
        System.arraycopy(out, 0, output, outputOffset, len);
        return len;
    }

    private byte[] prepareInputBuffer(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException {
        int len = Math.addExact(this.buffered, inputLen);
        if (len == 0) {
            return new byte[0];
        }
        if (this.padding == Padding.NoPadding && this.cipherMode != Mode.GCM && this.cipherMode != Mode.CTR && len % 16 != 0) {
            throw new IllegalBlockSizeException("Input size is not multiple of block size: " + len);
        }
        if (this.buffered != 0 || !this.decrypting || input == output && outputOffset - inputOffset < inputLen && inputOffset - outputOffset < this.buffer.length) {
            byte[] finalBuf = new byte[len];
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, finalBuf, 0, this.buffered);
                if (!this.decrypting) {
                    Arrays.fill(this.buffer, (byte)0);
                }
            }
            if (inputLen != 0) {
                System.arraycopy(input, inputOffset, finalBuf, this.buffered, inputLen);
            }
            return finalBuf;
        }
        return input;
    }

    private void endDoFinal() {
        this.buffered = 0;
        if (this.cipherMode != Mode.ECB) {
            this.cipher.reset();
        }
    }

    private void checkReinit() {
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
    }

    private byte[] encDecOutput(byte[] in, int inOfs, int len) throws IllegalBlockSizeException, ShortBufferException {
        if (this.cipherMode != Mode.GCM && this.cipherMode != Mode.CTR && len % 16 != 0 && this.padding == Padding.NoPadding) {
            throw new IllegalBlockSizeException("Input length is not multiple of 16 bytes");
        }
        return !this.decrypting ? this.cipher.encryptFinal(in, inOfs, len) : this.cipher.decryptFinal(in, inOfs, len);
    }

    byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] encodedKey = key.getEncoded();
        if (encodedKey == null || encodedKey.length == 0) {
            throw new InvalidKeyException("No encoded key");
        }
        return this.doFinal(encodedKey, 0, encodedKey.length);
    }

    Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encodedKey;
        try {
            encodedKey = this.doFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeyException("The wrapped key is invalid", e);
        }
        return ConstructKeys.constructKey(encodedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    void updateAAD(byte[] src, int offset, int len) {
        this.checkReinit();
        this.cipher.updateAAD(src, offset, len);
    }
}

