/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.NativeECKeyPairGen;
import com.tencent.kona.crypto.provider.nativeImpl.SweepNativeRef;
import com.tencent.kona.crypto.util.Constants;
import com.tencent.kona.crypto.util.Sweeper;
import com.tencent.kona.sun.security.ec.ECPrivateKeyImpl;
import com.tencent.kona.sun.security.ec.ECPublicKeyImpl;
import com.tencent.kona.sun.security.jca.JCAUtil;
import com.tencent.kona.sun.security.util.ECUtil;
import com.tencent.kona.sun.security.util.SecurityProviderConstants;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;
import java.util.Optional;

public final class KonaECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int KEY_SIZE_MIN = 112;
    private static final int KEY_SIZE_MAX = 571;
    private SecureRandom random;
    private int keySize;
    private AlgorithmParameterSpec params = null;
    private static final Sweeper SWEEPER = Sweeper.instance();
    private NativeECKeyPairGen keyPairGen = null;

    public KonaECKeyPairGenerator() {
        this.initialize(SecurityProviderConstants.DEF_EC_KEY_SIZE, null);
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        this.keyPairGen = null;
        this.checkKeySize(keySize);
        this.params = ECUtil.getECParameterSpec(keySize);
        if (this.params == null) {
            throw new InvalidParameterException("No EC parameters available for key size " + keySize + " bits");
        }
        this.random = random;
        byte[] encodedParams = ECUtil.encodeECParameterSpec((ECParameterSpec)this.params);
        int curveNID = Constants.getNID(encodedParams);
        this.keyPairGen = new NativeECKeyPairGen(curveNID);
        SWEEPER.register(this, new SweepNativeRef(this.keyPairGen));
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.keyPairGen = null;
        ECParameterSpec ecSpec = null;
        if (params instanceof ECParameterSpec) {
            ECParameterSpec ecParams = (ECParameterSpec)params;
            ecSpec = ECUtil.getECParameterSpec(ecParams);
            if (ecSpec == null) {
                throw new InvalidAlgorithmParameterException("Curve not supported: " + params);
            }
        } else if (params instanceof ECGenParameterSpec) {
            String name = ((ECGenParameterSpec)params).getName();
            ecSpec = ECUtil.getECParameterSpec(name);
            if (ecSpec == null) {
                throw new InvalidAlgorithmParameterException("Unknown curve name: " + name);
            }
        } else {
            throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
        }
        byte[] encodedParams = ECUtil.encodeECParameterSpec(ecSpec);
        int curveNID = KonaECKeyPairGenerator.ensureCurveIsSupported(encodedParams, ecSpec);
        this.keyPairGen = new NativeECKeyPairGen(curveNID);
        SWEEPER.register(this, new SweepNativeRef(this.keyPairGen));
        this.params = ecSpec;
        this.keySize = ecSpec.getCurve().getField().getFieldSize();
        this.random = random;
    }

    private static int ensureCurveIsSupported(byte[] encodedParams, ECParameterSpec ecSpec) throws InvalidAlgorithmParameterException {
        int curveNID = Constants.getNID(encodedParams);
        if (curveNID == -1) {
            throw new InvalidAlgorithmParameterException("Curve not supported: " + ecSpec.toString());
        }
        AlgorithmParameters ecParams = ECUtil.getECParameters();
        try {
            ecParams.init(ecSpec);
        }
        catch (InvalidParameterSpecException ex) {
            throw new InvalidAlgorithmParameterException("Curve not supported: " + ecSpec.toString());
        }
        return curveNID;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        try {
            Optional<KeyPair> kp = this.generateKeyPairImpl(this.random);
            if (kp.isPresent()) {
                return kp.get();
            }
        }
        catch (Exception ex) {
            throw new ProviderException(ex);
        }
        throw new ProviderException("Curve not supported: " + this.params.toString());
    }

    private Optional<KeyPair> generateKeyPairImpl(SecureRandom random) throws Exception {
        Object[] keyBytes = this.keyPairGen.genKeyPair();
        ECParameterSpec ecParams = (ECParameterSpec)this.params;
        BigInteger s = new BigInteger(1, (byte[])keyBytes[0]);
        ECPrivateKeyImpl privateKey = new ECPrivateKeyImpl(s, ecParams);
        byte[] pubKey = (byte[])keyBytes[1];
        ECPoint w = ECUtil.decodePoint(pubKey, ecParams.getCurve());
        ECPublicKeyImpl publicKey = new ECPublicKeyImpl(w, ecParams);
        return Optional.of(new KeyPair(publicKey, privateKey));
    }

    private void checkKeySize(int keySize) throws InvalidParameterException {
        if (keySize < 112) {
            throw new InvalidParameterException("Key size must be at least 112 bits");
        }
        if (keySize > 571) {
            throw new InvalidParameterException("Key size must be at most 571 bits");
        }
        this.keySize = keySize;
    }
}

