/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.util.Constants;
import com.tencent.kona.sun.security.ec.ECKeyFactory;
import com.tencent.kona.sun.security.util.ArrayUtil;
import com.tencent.kona.sun.security.util.CurveDB;
import com.tencent.kona.sun.security.util.ECUtil;
import com.tencent.kona.sun.security.util.NamedCurve;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class KonaOneShotECDHKeyAgreement
extends KeyAgreementSpi {
    private ECPrivateKey privateKey;
    private int curveNID = -1;
    private ECPublicKey publicKey;
    private int secretLen;

    private void init(Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.privateKey = null;
        this.publicKey = null;
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be instance of PrivateKey");
        }
        ECPrivateKey ecPrivateKey = (ECPrivateKey)ECKeyFactory.toECKey(key);
        ECUtil.checkPrivateKey(ecPrivateKey);
        NamedCurve curve = CurveDB.lookup(ecPrivateKey.getParams());
        this.curveNID = Constants.getCurveNID(curve.getName());
        this.privateKey = ecPrivateKey;
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.init(key);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.init(key);
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.publicKey != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!lastPhase) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm EC");
        }
        KonaOneShotECDHKeyAgreement.validate((ECPublicKey)key);
        this.publicKey = (ECPublicKey)key;
        int keyLenBits = this.publicKey.getParams().getCurve().getField().getFieldSize();
        this.secretLen = keyLenBits + 7 >> 3;
        return null;
    }

    private static void validateCoordinate(BigInteger c, BigInteger mod) throws InvalidKeyException {
        if (c.compareTo(BigInteger.ZERO) < 0 || c.compareTo(mod) >= 0) {
            throw new InvalidKeyException("Invalid coordinate");
        }
    }

    private static void validate(ECPublicKey key) throws InvalidKeyException {
        ECParameterSpec spec = key.getParams();
        BigInteger x = key.getW().getAffineX();
        BigInteger y = key.getW().getAffineY();
        byte[] order = spec.getOrder().toByteArray();
        ArrayUtil.reverse(order);
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] result;
        if (this.privateKey == null || this.publicKey == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        try {
            result = this.deriveKeyImpl(this.privateKey, this.publicKey);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.publicKey = null;
        return result;
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (this.secretLen > sharedSecret.length - offset) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (sharedSecret.length - offset) + " available");
        }
        byte[] secret = this.engineGenerateSecret();
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (!algorithm.equals("TlsPremasterSecret")) {
            throw new NoSuchAlgorithmException("Only supported for algorithm TlsPremasterSecret");
        }
        return new SecretKeySpec(this.engineGenerateSecret(), "TlsPremasterSecret");
    }

    private byte[] deriveKeyImpl(ECPrivateKey priv, ECPublicKey pubKey) throws InvalidKeyException {
        ECParameterSpec params = priv.getParams();
        byte[] priKeyValue = ECUtil.sArray(priv.getS(), params);
        ArrayUtil.reverse(priKeyValue);
        byte[] pubKeyValue = ECUtil.encodePoint(pubKey.getW(), params.getCurve());
        return NativeCrypto.ecdhOneShotDeriveKey(this.curveNID, priKeyValue, pubKeyValue);
    }
}

