/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

enum Mode {
    CBC("CBC"),
    CTR("CTR"),
    ECB("ECB"),
    GCM("GCM");

    final String name;

    private Mode(String name) {
        this.name = name;
    }

    static boolean isCBC(String mode) {
        return Mode.CBC.name.equalsIgnoreCase(mode);
    }

    static boolean isCTR(String mode) {
        return Mode.CTR.name.equalsIgnoreCase(mode);
    }

    static boolean isECB(String mode) {
        return Mode.ECB.name.equalsIgnoreCase(mode);
    }

    static boolean isGCM(String mode) {
        return Mode.GCM.name.equalsIgnoreCase(mode);
    }

    static Mode getMode(String mode) {
        switch (mode) {
            case "CBC": {
                return CBC;
            }
            case "CTR": {
                return CTR;
            }
            case "ECB": {
                return ECB;
            }
            case "GCM": {
                return GCM;
            }
        }
        return null;
    }
}

