/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.provider.nativeImpl.NativeRef;

public class NativeECDHKeyAgreement
extends NativeRef {
    NativeECDHKeyAgreement(int curveNID, byte[] priKey) {
        super(NativeECDHKeyAgreement.createCtx(curveNID, priKey));
    }

    private static long createCtx(int curveNID, byte[] priKey) {
        if (priKey == null || priKey.length == 0) {
            throw new IllegalStateException("Private key is null or empty");
        }
        return NativeCrypto.ecdhCreateCtx(curveNID, priKey);
    }

    public byte[] deriveKey(byte[] pubKey) {
        byte[] sharedKey;
        if (pubKey == null || pubKey.length == 0) {
            throw new IllegalStateException("Public key cannot be null");
        }
        byte[] byArray = sharedKey = this.pointer == 0L ? null : NativeCrypto.ecdhDeriveKey(this.pointer, pubKey);
        if (sharedKey == null) {
            throw new IllegalStateException("Derive key failed");
        }
        return sharedKey;
    }

    @Override
    public void close() {
        if (this.pointer != 0L) {
            NativeCrypto.ecdhFreeCtx(this.pointer);
            super.close();
        }
    }
}

