/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.provider.nativeImpl.NativeRef;

final class NativeSM2KeyPairGen
extends NativeRef {
    NativeSM2KeyPairGen() {
        super(NativeSM2KeyPairGen.createCtx());
    }

    private static long createCtx() {
        return NativeCrypto.nativeCrypto().sm2KeyPairGenCreateCtx();
    }

    public byte[] genKeyPair() {
        byte[] keyPair;
        byte[] byArray = keyPair = this.pointer == 0L ? null : NativeCrypto.nativeCrypto().sm2KeyPairGenGenKeyPair(this.pointer);
        if (keyPair == null) {
            throw new IllegalStateException("Generate key pair failed");
        }
        if (keyPair.length == 97) {
            return keyPair;
        }
        if (keyPair.length == 65) {
            byte[] uncompPubKey = NativeCrypto.sm2ToUncompPubKey(CryptoUtils.copy(keyPair, 32, 33));
            byte[] uncompKeyPair = new byte[97];
            System.arraycopy(keyPair, 0, uncompKeyPair, 0, 32);
            System.arraycopy(uncompPubKey, 0, uncompKeyPair, 32, 65);
            return uncompKeyPair;
        }
        throw new IllegalStateException("Illegal key pair");
    }

    @Override
    public void close() {
        if (this.pointer != 0L) {
            NativeCrypto.nativeCrypto().sm2KeyPairGenFreeCtx(this.pointer);
            super.close();
        }
    }
}

