/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.provider.nativeImpl.NativeRef;
import javax.crypto.BadPaddingException;

final class NativeSM2Signature
extends NativeRef {
    NativeSM2Signature(byte[] priKey, byte[] pubKey, byte[] id, boolean isSign) {
        super(NativeSM2Signature.createCtx(priKey, pubKey, id, isSign));
    }

    NativeSM2Signature(byte[] pubKey, byte[] id, boolean isSign) {
        this(null, pubKey, id, isSign);
    }

    private static long createCtx(byte[] priKey, byte[] pubKey, byte[] id, boolean isSign) {
        NativeSM2Signature.checkKey(priKey, pubKey, isSign);
        NativeSM2Signature.checkId(id);
        int keySize = priKey == null ? 0 : priKey.length;
        byte[] key = new byte[keySize += pubKey == null ? 0 : pubKey.length];
        if (priKey != null) {
            System.arraycopy(priKey, 0, key, 0, priKey.length);
            if (pubKey != null) {
                System.arraycopy(pubKey, 0, key, priKey.length, pubKey.length);
            }
        } else {
            System.arraycopy(pubKey, 0, key, 0, pubKey.length);
        }
        return NativeCrypto.nativeCrypto().sm2SignatureCreateCtx(key, id, isSign);
    }

    private static void checkKey(byte[] priKey, byte[] pubKey, boolean isSign) {
        if (isSign) {
            if (priKey == null || priKey.length != 32) {
                throw new IllegalStateException("Invalid private key");
            }
        } else if (priKey != null || pubKey == null || pubKey.length != 65) {
            throw new IllegalStateException("Invalid public key");
        }
    }

    private static void checkId(byte[] id) {
        if (id == null || id.length == 0) {
            throw new IllegalStateException("Illegal ID");
        }
    }

    public byte[] sign(byte[] message) throws BadPaddingException {
        byte[] signature;
        if (message == null) {
            throw new BadPaddingException("Message cannot be null");
        }
        byte[] byArray = signature = this.pointer == 0L ? null : NativeCrypto.nativeCrypto().sm2SignatureSign(this.pointer, message);
        if (signature == null) {
            throw new BadPaddingException("Sign failed");
        }
        return signature;
    }

    public boolean verify(byte[] message, byte[] signature) throws BadPaddingException {
        if (message == null) {
            throw new BadPaddingException("Message cannot be null");
        }
        if (signature == null || signature.length == 0) {
            throw new BadPaddingException("Invalid signature");
        }
        int verified = this.pointer == 0L ? 0 : NativeCrypto.nativeCrypto().sm2SignatureVerify(this.pointer, message, signature);
        return verified == 1;
    }

    @Override
    public void close() {
        if (this.pointer != 0L) {
            NativeCrypto.nativeCrypto().sm2SignatureFreeCtx(this.pointer);
            super.close();
        }
    }
}

