/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.provider.nativeImpl.NativeRef;
import java.util.Objects;

final class NativeSM3
extends NativeRef
implements Cloneable {
    public NativeSM3() {
        super(NativeCrypto.nativeCrypto().sm3CreateCtx());
    }

    public NativeSM3(long pointer) {
        super(pointer);
    }

    public void update(byte[] data) {
        Objects.requireNonNull(data);
        if (this.pointer == 0L || NativeCrypto.nativeCrypto().sm3Update(this.pointer, data) != 1) {
            throw new IllegalStateException("sm3 update operation failed");
        }
    }

    public byte[] doFinal() {
        byte[] result;
        byte[] byArray = result = this.pointer == 0L ? null : NativeCrypto.nativeCrypto().sm3Final(this.pointer);
        if (result == null) {
            throw new IllegalStateException("sm3 final operation failed");
        }
        return result;
    }

    public byte[] doFinal(byte[] data) {
        this.update(data);
        return this.doFinal();
    }

    @Override
    public void close() {
        if (this.pointer != 0L) {
            NativeCrypto.nativeCrypto().sm3FreeCtx(this.pointer);
            super.close();
        }
    }

    public void reset() {
        if (this.pointer == 0L || NativeCrypto.nativeCrypto().sm3Reset(this.pointer) != 1) {
            throw new IllegalStateException("sm3 reset operation failed");
        }
    }

    protected NativeSM3 clone() {
        if (this.pointer == 0L) {
            throw new IllegalStateException("Cannot clone SM3 instance");
        }
        long clonePointer = NativeCrypto.nativeCrypto().sm3Clone(this.pointer);
        if (clonePointer <= 0L) {
            throw new IllegalStateException("SM3 clone operation failed");
        }
        return new NativeSM3(clonePointer);
    }
}

