/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.Mode;
import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.crypto.provider.nativeImpl.NativeRef;
import java.util.Objects;
import javax.crypto.AEADBadTagException;

abstract class NativeSM4
extends NativeRef {
    final boolean encrypt;
    final Mode mode;
    final boolean padding;
    final byte[] key;
    byte[] iv;

    NativeSM4(boolean encrypt, Mode mode, boolean padding, byte[] key, byte[] iv) {
        super(NativeSM4.createCtx(encrypt, mode, padding, key, iv));
        this.encrypt = encrypt;
        this.mode = mode;
        this.padding = padding;
        this.key = key;
        this.iv = iv;
    }

    private static long createCtx(boolean encrypt, Mode mode, boolean padding, byte[] key, byte[] iv) {
        if (mode == null) {
            throw new IllegalStateException("mode cannot be null");
        }
        if (key == null || key.length != 16) {
            throw new IllegalStateException("key must be 16-bytes");
        }
        if (mode == Mode.CBC || mode == Mode.CTR || mode == Mode.GCM) {
            if (iv == null) {
                throw new IllegalStateException("iv cannot be null");
            }
            if (mode == Mode.GCM) {
                if (iv.length != 12) {
                    throw new IllegalStateException("iv for GCM mode must be 12-bytes");
                }
            } else if (iv.length != 16) {
                throw new IllegalStateException("iv must be 16-bytes");
            }
        } else if (iv != null) {
            throw new IllegalStateException("iv is unnecessary");
        }
        return NativeCrypto.nativeCrypto().sm4CreateCtx(encrypt, mode.name, padding, key, iv);
    }

    byte[] update(byte[] data) {
        byte[] result;
        Objects.requireNonNull(data);
        byte[] byArray = result = this.pointer == 0L ? null : NativeCrypto.nativeCrypto().sm4Update(this.pointer, data);
        if (result == null) {
            throw new IllegalStateException("SM4 update operation failed");
        }
        return result;
    }

    byte[] doFinal() {
        byte[] result;
        byte[] byArray = result = this.pointer == 0L ? null : NativeCrypto.nativeCrypto().sm4Final(this.pointer, this.key, this.iv);
        if (result == null) {
            throw new IllegalStateException("SM4 final operation failed");
        }
        return result;
    }

    byte[] doFinal(byte[] data) {
        Objects.requireNonNull(data);
        byte[] lastOut = this.update(data);
        byte[] finalOut = this.doFinal();
        byte[] out = new byte[lastOut.length + finalOut.length];
        System.arraycopy(lastOut, 0, out, 0, lastOut.length);
        System.arraycopy(finalOut, 0, out, lastOut.length, finalOut.length);
        return out;
    }

    @Override
    public void close() {
        if (this.pointer != 0L) {
            NativeCrypto.nativeCrypto().sm4FreeCtx(this.pointer);
            super.close();
        }
    }

    static class SM4GCM
    extends NativeSM4 {
        private final boolean encrypt;

        SM4GCM(boolean encrypt, byte[] key, byte[] iv) {
            super(encrypt, Mode.GCM, false, key, iv);
            this.encrypt = encrypt;
        }

        void updateAAD(byte[] aad) {
            Objects.requireNonNull(aad);
            if (this.pointer == 0L || NativeCrypto.nativeCrypto().sm4GCMUpdateAAD(this.pointer, aad) != 1) {
                throw new IllegalStateException("SM4 updateAAD operation failed");
            }
        }

        @Override
        byte[] doFinal() {
            byte[] result;
            byte[] byArray = result = this.pointer == 0L ? null : NativeCrypto.nativeCrypto().sm4Final(this.pointer, null, null);
            if (result == null) {
                throw new IllegalStateException(new AEADBadTagException("Tag is incorrect"));
            }
            return result;
        }

        void setIV(byte[] iv) {
            Objects.requireNonNull(iv);
            if (this.pointer == 0L || NativeCrypto.nativeCrypto().sm4GCMSetIV(this.pointer, iv) != 1) {
                throw new IllegalStateException("SM4 setting IV operation failed");
            }
            this.iv = iv;
        }

        byte[] getTag() {
            byte[] tag = new byte[16];
            if (this.pointer == 0L || NativeCrypto.nativeCrypto().sm4GCMProcTag(this.pointer, tag) != 1) {
                throw new IllegalStateException("SM4GCM getTag operation failed");
            }
            return tag;
        }

        void setTag(byte[] tag) {
            if (tag == null || tag.length != 16) {
                throw new IllegalArgumentException("Tag must be 16-bytes");
            }
            if (this.pointer == 0L || NativeCrypto.nativeCrypto().sm4GCMProcTag(this.pointer, tag) != 1) {
                throw new IllegalStateException("SM4GCM setTag operation failed");
            }
        }

        @Override
        byte[] doFinal(byte[] data) {
            return this.encrypt ? this.encDoFinal(data) : this.decDoFinal(data);
        }

        private byte[] encDoFinal(byte[] data) {
            Objects.requireNonNull(data);
            byte[] lastOut = this.update(data);
            byte[] finalOut = this.doFinal();
            byte[] tag = this.getTag();
            byte[] out = new byte[lastOut.length + finalOut.length + tag.length];
            System.arraycopy(lastOut, 0, out, 0, lastOut.length);
            System.arraycopy(finalOut, 0, out, lastOut.length, finalOut.length);
            System.arraycopy(tag, 0, out, lastOut.length + finalOut.length, tag.length);
            return out;
        }

        private byte[] decDoFinal(byte[] data) {
            byte[] msg;
            byte[] tag;
            if (data == null || data.length < 16) {
                throw new IllegalArgumentException("data must not be less than 16-bytes");
            }
            if (data.length == 16) {
                tag = data;
                msg = new byte[]{};
            } else {
                tag = new byte[16];
                System.arraycopy(data, data.length - 16, tag, 0, 16);
                msg = new byte[data.length - 16];
                System.arraycopy(data, 0, msg, 0, data.length - 16);
            }
            byte[] plaintext = this.update(msg);
            this.setTag(tag);
            try {
                this.doFinal();
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Tag is incorrect");
            }
            return plaintext;
        }
    }

    static final class SM4ECB
    extends NativeSM4 {
        SM4ECB(boolean encrypt, boolean padding, byte[] key) {
            super(encrypt, Mode.ECB, padding, key, null);
        }

        void processBlock(byte[] in, int inOff, byte[] out, int outOff) {
            byte[] inBlock = new byte[16];
            System.arraycopy(in, inOff, inBlock, 0, 16);
            byte[] outBlock = this.update(inBlock);
            System.arraycopy(outBlock, 0, out, outOff, outBlock.length);
        }
    }

    static final class SM4CTR
    extends NativeSM4 {
        SM4CTR(boolean encrypt, byte[] key, byte[] iv) {
            super(encrypt, Mode.CTR, false, key, iv);
        }
    }

    static final class SM4CBC
    extends NativeSM4 {
        SM4CBC(boolean encrypt, boolean padding, byte[] key, byte[] iv) {
            super(encrypt, Mode.CBC, padding, key, iv);
        }
    }
}

