/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.NativeSM3;
import com.tencent.kona.crypto.provider.nativeImpl.SweepNativeRef;
import com.tencent.kona.crypto.util.Sweeper;
import com.tencent.kona.jdk.internal.util.Preconditions;
import java.security.MessageDigest;

public final class SM3MessageDigest
extends MessageDigest
implements Cloneable {
    private static final Sweeper SWEEPER = Sweeper.instance();
    private NativeSM3 sm3 = new NativeSM3();

    public SM3MessageDigest() {
        super("SM3");
        SWEEPER.register(this, new SweepNativeRef(this.sm3));
    }

    @Override
    protected void engineUpdate(byte input) {
        this.sm3.update(new byte[]{input});
    }

    @Override
    protected int engineGetDigestLength() {
        return 32;
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (len == 0) {
            return;
        }
        Preconditions.checkFromIndexSize(offset, len, input.length, Preconditions.AIOOBE_FORMATTER);
        byte[] data = new byte[len];
        System.arraycopy(input, offset, data, 0, len);
        this.sm3.update(data);
    }

    @Override
    protected byte[] engineDigest() {
        return this.sm3.doFinal();
    }

    @Override
    protected void engineReset() {
        this.sm3.reset();
    }

    @Override
    public SM3MessageDigest clone() throws CloneNotSupportedException {
        SM3MessageDigest clone = (SM3MessageDigest)super.clone();
        clone.sm3 = this.sm3.clone();
        return clone;
    }
}

