/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.provider.nativeImpl.ByteArrayWriter;
import com.tencent.kona.crypto.provider.nativeImpl.NativeCrypto;
import com.tencent.kona.jdk.internal.util.Preconditions;
import java.security.MessageDigest;

public final class SM3OneShotMessageDigest
extends MessageDigest
implements Cloneable {
    private final ByteArrayWriter buffer = new ByteArrayWriter();

    public SM3OneShotMessageDigest() {
        super("SM3");
    }

    @Override
    protected void engineUpdate(byte input) {
        this.buffer.write(new byte[]{input});
    }

    @Override
    protected int engineGetDigestLength() {
        return 32;
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (len == 0) {
            return;
        }
        Preconditions.checkFromIndexSize(offset, len, input.length, Preconditions.AIOOBE_FORMATTER);
        this.buffer.write(input, offset, len);
    }

    @Override
    protected byte[] engineDigest() {
        byte[] digest = NativeCrypto.sm3OneShotDigest(this.buffer.toByteArray());
        this.buffer.reset();
        return digest;
    }

    @Override
    protected void engineReset() {
        this.buffer.reset();
    }

    @Override
    public SM3OneShotMessageDigest clone() throws CloneNotSupportedException {
        SM3OneShotMessageDigest clone = new SM3OneShotMessageDigest();
        clone.buffer.write(this.buffer.toByteArray());
        return clone;
    }
}

