/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider.nativeImpl;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.provider.nativeImpl.Mode;
import com.tencent.kona.crypto.provider.nativeImpl.Padding;
import java.security.InvalidAlgorithmParameterException;
import java.util.Arrays;

final class SM4Params {
    private final Mode mode;
    private final Padding padding;
    private final byte[] iv;

    public SM4Params(Mode mode, Padding padding, byte[] iv) throws InvalidAlgorithmParameterException {
        this.checkParams(mode, padding, iv);
        this.mode = mode;
        this.padding = padding;
        this.iv = CryptoUtils.clone(iv);
    }

    public SM4Params(Mode mode, Padding padding) throws InvalidAlgorithmParameterException {
        this(mode, padding, new byte[0]);
    }

    private void checkParams(Mode mode, Padding padding, byte[] iv) throws InvalidAlgorithmParameterException {
        if (mode == null) {
            throw new InvalidAlgorithmParameterException("Unsupported mode: " + (Object)((Object)mode));
        }
        switch (mode) {
            case ECB: {
                this.checkECBParams(iv);
                break;
            }
            case CBC: {
                this.checkCBCParams(iv);
                break;
            }
            case GCM: {
                this.checkGCMParams(padding, iv);
                break;
            }
            case CTR: {
                this.checkCTRParams(padding, iv);
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException("Unsupported mode: " + (Object)((Object)mode));
            }
        }
    }

    private void checkECBParams(byte[] iv) throws InvalidAlgorithmParameterException {
        SM4Params.checkIvNotNeeded(iv);
    }

    private void checkCBCParams(byte[] iv) throws InvalidAlgorithmParameterException {
        SM4Params.checkIvNeeded(iv, false);
    }

    private void checkGCMParams(Padding padding, byte[] iv) throws InvalidAlgorithmParameterException {
        SM4Params.checkPaddingNoNeeded(padding);
        SM4Params.checkIvNeeded(iv, true);
    }

    private void checkCTRParams(Padding padding, byte[] iv) throws InvalidAlgorithmParameterException {
        SM4Params.checkPaddingNoNeeded(padding);
        SM4Params.checkIvNeeded(iv, false);
    }

    private static void checkPaddingNoNeeded(Padding padding) throws InvalidAlgorithmParameterException {
        if (padding != Padding.NoPadding) {
            throw new InvalidAlgorithmParameterException("Padding is not supported");
        }
    }

    private static void checkIvNotNeeded(byte[] iv) throws InvalidAlgorithmParameterException {
        if (iv != null && iv.length > 0) {
            throw new InvalidAlgorithmParameterException("IV is not needed");
        }
    }

    private static void checkIvNeeded(byte[] iv, boolean isGCM) throws InvalidAlgorithmParameterException {
        if (iv == null || iv.length == 0) {
            throw new InvalidAlgorithmParameterException("IV is missing");
        }
        if (!isGCM && iv.length != 16) {
            throw new InvalidAlgorithmParameterException("The length of IV must be 16-bytes: " + iv.length);
        }
        if (isGCM && iv.length != 12) {
            throw new InvalidAlgorithmParameterException("The length of GCM IV must be 12-bytes: " + iv.length);
        }
    }

    public Mode mode() {
        return this.mode;
    }

    public Padding padding() {
        return this.padding;
    }

    public byte[] iv() {
        return (byte[])this.iv.clone();
    }

    public void resetIV() {
        Arrays.fill(this.iv, (byte)0);
    }
}

