/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.spec;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;

public final class SM2KeyAgreementParamSpec
implements AlgorithmParameterSpec {
    private static final byte[] DEFAULT_ID = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    private final byte[] id;
    private final ECPrivateKey privateKey;
    private final ECPublicKey publicKey;
    private final byte[] peerId;
    private final ECPublicKey peerPublicKey;
    private final boolean isInitiator;
    private final int sharedKeyLength;

    public SM2KeyAgreementParamSpec(byte[] id, ECPrivateKey privateKey, ECPublicKey publicKey, byte[] peerId, ECPublicKey peerPublicKey, boolean isInitiator, int sharedKeyLength) {
        Objects.requireNonNull(id, "id must not null");
        Objects.requireNonNull(privateKey, "privateKey must not null");
        Objects.requireNonNull(publicKey, "publicKey must not null");
        Objects.requireNonNull(peerId, "peerId must not null");
        Objects.requireNonNull(peerPublicKey, "peerPublicKey must not null");
        CryptoUtils.checkId(id);
        CryptoUtils.checkId(peerId);
        BigInteger s = privateKey.getS();
        if (s.compareTo(BigInteger.ZERO) <= 0 || s.compareTo(SM2ParameterSpec.ORDER) >= 0) {
            throw new IllegalArgumentException("The private key must be within the range [1, n - 1]");
        }
        this.id = (byte[])id.clone();
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.peerId = (byte[])peerId.clone();
        this.peerPublicKey = peerPublicKey;
        this.isInitiator = isInitiator;
        this.sharedKeyLength = sharedKeyLength;
    }

    public SM2KeyAgreementParamSpec(ECPrivateKey privateKey, ECPublicKey publicKey, ECPublicKey peerPublicKey, boolean isInitiator, int sharedKeyLength) {
        this(DEFAULT_ID, privateKey, publicKey, DEFAULT_ID, peerPublicKey, isInitiator, sharedKeyLength);
    }

    public byte[] id() {
        return (byte[])this.id.clone();
    }

    public ECPrivateKey privateKey() {
        return this.privateKey;
    }

    public ECPublicKey publicKey() {
        return this.publicKey;
    }

    public byte[] peerId() {
        return (byte[])this.peerId.clone();
    }

    public ECPublicKey peerPublicKey() {
        return this.peerPublicKey;
    }

    public boolean isInitiator() {
        return this.isInitiator;
    }

    public int sharedKeyLength() {
        return this.sharedKeyLength;
    }
}

