/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.spec;

import com.tencent.kona.crypto.CryptoUtils;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;

public final class SM2SignatureParameterSpec
implements AlgorithmParameterSpec {
    private static final byte[] DEFAULT_ID = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    private final byte[] id;
    private final ECPublicKey publicKey;

    public SM2SignatureParameterSpec(byte[] id, ECPublicKey publicKey) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(publicKey);
        CryptoUtils.checkId(id);
        this.id = (byte[])id.clone();
        this.publicKey = publicKey;
    }

    public SM2SignatureParameterSpec(ECPublicKey publicKey) {
        this(DEFAULT_ID, publicKey);
    }

    public byte[] getId() {
        return (byte[])this.id.clone();
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }
}

