/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.util;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class Constants {
    public static final BigInteger TWO = BigInteger.valueOf(2L);
    public static final BigInteger THREE = BigInteger.valueOf(3L);
    public static final int SM2_PUBKEY_LEN = 65;
    public static final int SM2_COMP_PUBKEY_LEN = 33;
    public static final int SM2_PUBKEY_AFFINE_LEN = 32;
    public static final int SM2_CURVE_FIELD_SIZE = 32;
    public static final int SM2_PRIKEY_LEN = 32;
    public static final int SM3_BLOCK_SIZE = 64;
    public static final int SM3_DIGEST_LEN = 32;
    public static final int SM3_HMAC_LEN = 32;
    public static final int SM4_BLOCK_SIZE = 16;
    public static final int SM4_KEY_SIZE = 16;
    public static final int SM4_IV_LEN = 16;
    public static final int SM4_GCM_IV_LEN = 12;
    public static final int SM4_GCM_TAG_LEN = 16;
    private static final byte[] DEFAULT_ID = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    public static final int NID_SECP256R1 = 415;
    public static final int NID_SECP384R1 = 715;
    public static final int NID_SECP521R1 = 716;
    public static final int NID_CURVESM2 = 1172;
    public static final int NID_SHA1 = 64;
    public static final int NID_SHA224 = 675;
    public static final int NID_SHA256 = 672;
    public static final int NID_SHA384 = 673;
    public static final int NID_SHA512 = 674;
    private static final byte[] ENCODED_SECP256R1_OID = new byte[]{6, 8, 42, -122, 72, -50, 61, 3, 1, 7};
    private static final byte[] ENCODED_SECP384R1_OID = new byte[]{6, 5, 43, -127, 4, 0, 34};
    private static final byte[] ENCODED_SECP521R1_OID = new byte[]{6, 5, 43, -127, 4, 0, 35};
    private static final byte[] ENCODED_CURVESM2_OID = new byte[]{6, 8, 42, -127, 28, -49, 85, 1, -126, 45};
    private static final Map<String, Integer> MD_NID_MAP = new HashMap<String, Integer>();

    public static byte[] defaultId() {
        return (byte[])DEFAULT_ID.clone();
    }

    public static int getNID(byte[] encodedOID) {
        if (Arrays.equals(encodedOID, ENCODED_SECP256R1_OID)) {
            return 415;
        }
        if (Arrays.equals(encodedOID, ENCODED_SECP384R1_OID)) {
            return 715;
        }
        if (Arrays.equals(encodedOID, ENCODED_SECP521R1_OID)) {
            return 716;
        }
        if (Arrays.equals(encodedOID, ENCODED_CURVESM2_OID)) {
            return 1172;
        }
        return -1;
    }

    public static int getPrivateKeySize(int curveNID) {
        switch (curveNID) {
            case 415: 
            case 1172: {
                return 32;
            }
            case 715: {
                return 48;
            }
            case 716: {
                return 66;
            }
        }
        return -1;
    }

    public static int getDigestNID(String digest) {
        String name = digest.replace("-", "").toUpperCase();
        Integer nid = MD_NID_MAP.get(name);
        return nid == null ? -1 : nid;
    }

    public static int getCurveNID(String curve) {
        String curveName = curve.toUpperCase();
        if (curveName.contains("SECP256R1")) {
            return 415;
        }
        if (curveName.contains("SECP384R1")) {
            return 715;
        }
        if (curveName.contains("SECP521R1")) {
            return 716;
        }
        if (curveName.contains("CURVESM2")) {
            return 1172;
        }
        return -1;
    }

    static {
        MD_NID_MAP.put("SHA1", 64);
        MD_NID_MAP.put("SHA224", 675);
        MD_NID_MAP.put("SHA256", 672);
        MD_NID_MAP.put("SHA384", 673);
        MD_NID_MAP.put("SHA512", 674);
    }
}

