/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.jdk.internal.misc;

import com.tencent.kona.crypto.CryptoUtils;
import java.io.Console;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.EncodedKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class SharedSecretsUtil {
    private static final boolean USE_SHARED_SECRETS = CryptoUtils.privilegedGetBoolProperty("com.tencent.kona.misc.useSharedSecrets", CryptoUtils.isJdk8() ? "true" : "false");
    private static final Method langNewStringNoRepl;
    private static final Method initialSystemIn;
    private static final Object langAccess;
    private static final Method console;
    private static final Method charset;
    private static final Object ioAccess;
    private static final Method cryptoSpecClearSecretKeySpec;
    private static final Object cryptoSpecAccess;
    private static final Method netInetAddressGetOriginalHostName;
    private static final Object netInetAddressAccess;
    private static final Method secSignatureInitVerifyWithPubKey;
    private static final Method secSignatureInitVerifyWithCert;
    private static final Method secSignatureInitSign;
    private static final Object secSignatureAccess;
    private static final Method secSpecClearEncodedKeySpec;
    private static final Object secSpecAccess;

    private static boolean useSharedSecrets() {
        return USE_SHARED_SECRETS && !CryptoUtils.isAndroid();
    }

    private static Class<?> getSharedSecretsClass() {
        if (CryptoUtils.isJdk8()) {
            return SharedSecretsUtil.getClass("sun.misc.SharedSecrets");
        }
        if (CryptoUtils.isJdk11()) {
            return SharedSecretsUtil.getClass("jdk.internal.misc.SharedSecrets");
        }
        if (CryptoUtils.isJdk17() || CryptoUtils.isJdk21()) {
            return SharedSecretsUtil.getClass("jdk.internal.access.SharedSecrets");
        }
        return null;
    }

    private static Class<?> getClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    private static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Method method = null;
        if (clazz != null) {
            try {
                method = clazz.getMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }

    public static String langNewStringNoRepl(byte[] bytes, Charset cs) throws CharacterCodingException {
        if (langNewStringNoRepl == null) {
            return new String(bytes, cs);
        }
        try {
            return (String)langNewStringNoRepl.invoke(langAccess, bytes, cs);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("getOriginalHostName failed", e);
        }
    }

    public static InputStream initialSystemIn() {
        if (initialSystemIn == null) {
            return System.in;
        }
        try {
            return (InputStream)initialSystemIn.invoke(langAccess, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("initialSystemIn failed", e);
        }
    }

    public static Console console() {
        if (console == null) {
            return null;
        }
        try {
            return (Console)console.invoke(ioAccess, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("console failed", e);
        }
    }

    public static Charset charset() {
        if (charset == null) {
            return null;
        }
        try {
            return (Charset)charset.invoke(ioAccess, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("charset failed", e);
        }
    }

    public static void cryptoSpecClearSecretKeySpec(SecretKeySpec keySpec) {
        if (cryptoSpecClearSecretKeySpec == null) {
            return;
        }
        try {
            cryptoSpecClearSecretKeySpec.invoke(cryptoSpecAccess, keySpec);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("specAccessClearEncodedKeySpec failed", e);
        }
    }

    public static String netInetAddressGetOriginalHostName(InetAddress inetAddress) {
        if (netInetAddressGetOriginalHostName == null) {
            return inetAddress.getHostName();
        }
        try {
            return (String)netInetAddressGetOriginalHostName.invoke(netInetAddressAccess, inetAddress);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("getOriginalHostName failed", e);
        }
    }

    public static void secSignatureInitVerify(Signature signature, PublicKey publicKey, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secSignatureInitVerifyWithPubKey == null) {
            if (params != null) {
                signature.setParameter(params);
            }
            signature.initVerify(publicKey);
        } else {
            try {
                secSignatureInitVerifyWithPubKey.invoke(secSignatureAccess, signature, publicKey, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("signatureAccessInitVerify failed", e);
            }
        }
    }

    public static void secSignatureInitVerify(Signature signature, Certificate certificate, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secSignatureInitVerifyWithCert == null) {
            if (params != null) {
                signature.setParameter(params);
            }
            signature.initVerify(certificate);
        } else {
            try {
                secSignatureInitVerifyWithCert.invoke(secSignatureAccess, signature, certificate, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("signatureAccessInitVerify failed", e);
            }
        }
    }

    public static void secSignatureInitSign(Signature signature, PrivateKey privateKey, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secSignatureInitSign == null) {
            if (params != null) {
                signature.setParameter(params);
            }
            signature.initSign(privateKey, random);
        } else {
            try {
                secSignatureInitSign.invoke(secSignatureAccess, signature, privateKey, params, random);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("signatureAccessInitSign failed", e);
            }
        }
    }

    public static void secSpecClearEncodedKeySpec(EncodedKeySpec keySpec) {
        if (secSpecClearEncodedKeySpec == null) {
            return;
        }
        try {
            secSpecClearEncodedKeySpec.invoke(secSpecAccess, keySpec);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("specAccessClearEncodedKeySpec failed", e);
        }
    }

    private static Object getAccessObject(Class<?> sharedSecretsClass, String sharedSecretedMethodName) {
        Object accessObject = null;
        if (sharedSecretsClass != null) {
            try {
                Method sharedSecretedMethod = sharedSecretsClass.getDeclaredMethod(sharedSecretedMethodName, new Class[0]);
                sharedSecretedMethod.setAccessible(true);
                accessObject = sharedSecretedMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return accessObject;
    }

    static {
        if (SharedSecretsUtil.useSharedSecrets()) {
            Class<?> sharedSecretsClass = SharedSecretsUtil.getSharedSecretsClass();
            Class<?> javaLangAccessClass = null;
            Class<?> javaIOAccessClass = null;
            Class<?> javaxCryptoSpecAccessClass = null;
            Class<?> inetAddressAccessClass = null;
            Class<?> secSignatureAccessClass = null;
            Class<?> secSpecAccessClass = null;
            if (CryptoUtils.isJdk8()) {
                javaLangAccessClass = SharedSecretsUtil.getClass("sun.misc.JavaLangAccess");
                javaIOAccessClass = SharedSecretsUtil.getClass("sun.misc.JavaIOAccess");
                inetAddressAccessClass = SharedSecretsUtil.getClass("sun.misc.JavaNetAccess");
                secSignatureAccessClass = SharedSecretsUtil.getClass("sun.misc.JavaSecuritySignatureAccess");
            } else if (CryptoUtils.isJdk11()) {
                javaLangAccessClass = SharedSecretsUtil.getClass("jdk.internal.misc.JavaLangAccess");
                javaIOAccessClass = SharedSecretsUtil.getClass("jdk.internal.misc.JavaIOAccess");
                inetAddressAccessClass = SharedSecretsUtil.getClass("jdk.internal.misc.JavaNetInetAddressAccess");
                secSignatureAccessClass = SharedSecretsUtil.getClass("jdk.internal.misc.JavaSecuritySignatureAccess");
            } else if (CryptoUtils.isJdk17() || CryptoUtils.isJdk21()) {
                javaLangAccessClass = SharedSecretsUtil.getClass("jdk.internal.access.JavaLangAccess");
                javaIOAccessClass = SharedSecretsUtil.getClass("jdk.internal.access.JavaIOAccess");
                javaxCryptoSpecAccessClass = SharedSecretsUtil.getClass("jdk.internal.access.JavaxCryptoSpecAccess");
                inetAddressAccessClass = SharedSecretsUtil.getClass("jdk.internal.access.JavaNetInetAddressAccess");
                secSignatureAccessClass = SharedSecretsUtil.getClass("jdk.internal.access.JavaSecuritySignatureAccess");
                secSpecAccessClass = SharedSecretsUtil.getClass("jdk.internal.access.JavaSecuritySpecAccess");
            }
            langNewStringNoRepl = SharedSecretsUtil.getMethod(javaLangAccessClass, "newStringNoRepl", byte[].class, Charset.class);
            initialSystemIn = SharedSecretsUtil.getMethod(javaLangAccessClass, "initialSystemIn", new Class[0]);
            console = SharedSecretsUtil.getMethod(javaIOAccessClass, "console", new Class[0]);
            charset = SharedSecretsUtil.getMethod(javaIOAccessClass, "charset", new Class[0]);
            cryptoSpecClearSecretKeySpec = SharedSecretsUtil.getMethod(javaxCryptoSpecAccessClass, "clearSecretKeySpec", SecretKeySpec.class);
            netInetAddressGetOriginalHostName = SharedSecretsUtil.getMethod(inetAddressAccessClass, "getOriginalHostName", InetAddress.class);
            secSignatureInitVerifyWithPubKey = SharedSecretsUtil.getMethod(secSignatureAccessClass, "initVerify", Signature.class, PublicKey.class, AlgorithmParameterSpec.class);
            secSignatureInitVerifyWithCert = SharedSecretsUtil.getMethod(secSignatureAccessClass, "initVerify", Signature.class, Certificate.class, AlgorithmParameterSpec.class);
            secSignatureInitSign = SharedSecretsUtil.getMethod(secSignatureAccessClass, "initSign", Signature.class, PrivateKey.class, AlgorithmParameterSpec.class, SecureRandom.class);
            secSpecClearEncodedKeySpec = SharedSecretsUtil.getMethod(secSpecAccessClass, "clearEncodedKeySpec", EncodedKeySpec.class);
            langAccess = SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaLangAccess");
            ioAccess = SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaIOAccess");
            cryptoSpecAccess = SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaxCryptoSpecAccess");
            netInetAddressAccess = CryptoUtils.isJdk8() ? SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaNetAccess") : SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaNetInetAddressAccess");
            secSignatureAccess = SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaSecuritySignatureAccess");
            secSpecAccess = SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaSecuritySpecAccess");
        } else {
            langNewStringNoRepl = null;
            initialSystemIn = null;
            langAccess = null;
            console = null;
            charset = null;
            ioAccess = null;
            cryptoSpecClearSecretKeySpec = null;
            cryptoSpecAccess = null;
            netInetAddressGetOriginalHostName = null;
            netInetAddressAccess = null;
            secSignatureInitVerifyWithPubKey = null;
            secSignatureInitVerifyWithCert = null;
            secSignatureInitSign = null;
            secSignatureAccess = null;
            secSpecClearEncodedKeySpec = null;
            secSpecAccess = null;
        }
    }
}

