/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.jdk.internal.util;

public class ArraysSupport {
    public static final int SOFT_MAX_ARRAY_LENGTH = 0x7FFFFFF7;

    public static int newLength(int oldLength, int minGrowth, int prefGrowth) {
        int prefLength = oldLength + Math.max(minGrowth, prefGrowth);
        if (0 < prefLength && prefLength <= 0x7FFFFFF7) {
            return prefLength;
        }
        return ArraysSupport.hugeLength(oldLength, minGrowth);
    }

    private static int hugeLength(int oldLength, int minGrowth) {
        int minLength = oldLength + minGrowth;
        if (minLength < 0) {
            throw new OutOfMemoryError("Required array length " + oldLength + " + " + minGrowth + " is too large");
        }
        if (minLength <= 0x7FFFFFF7) {
            return 0x7FFFFFF7;
        }
        return minLength;
    }
}

