/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ec;

import com.tencent.kona.sun.security.ec.ECKeyFactory;
import com.tencent.kona.sun.security.ec.ECOperations;
import com.tencent.kona.sun.security.ec.point.MutablePoint;
import com.tencent.kona.sun.security.util.ArrayUtil;
import com.tencent.kona.sun.security.util.CurveDB;
import com.tencent.kona.sun.security.util.ECUtil;
import com.tencent.kona.sun.security.util.KeyUtil;
import com.tencent.kona.sun.security.util.NamedCurve;
import com.tencent.kona.sun.security.util.math.IntegerFieldModuloP;
import com.tencent.kona.sun.security.util.math.IntegerMontgomeryFieldModuloP;
import com.tencent.kona.sun.security.util.math.MutableIntegerModuloP;
import com.tencent.kona.sun.security.util.math.SmallValue;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.Optional;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class ECDHKeyAgreement
extends KeyAgreementSpi {
    private ECPrivateKey privateKey;
    private NamedCurve namedCurve;
    private ECOperations privateKeyOps;
    private ECPublicKey publicKey;
    private int secretLen;

    private void init(Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.privateKey = null;
        this.privateKeyOps = null;
        this.publicKey = null;
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be instance of PrivateKey");
        }
        ECPrivateKey ecPrivateKey = (ECPrivateKey)ECKeyFactory.toECKey(key);
        Optional<ECOperations> opsOpt = ECOperations.forParameters(ecPrivateKey.getParams());
        if (!opsOpt.isPresent()) {
            NamedCurve nc = CurveDB.lookup(ecPrivateKey.getParams());
            throw new InvalidAlgorithmParameterException("Curve not supported: " + (nc != null ? nc.toString() : "unknown"));
        }
        ECUtil.checkPrivateKey(ecPrivateKey);
        this.privateKey = ecPrivateKey;
        this.privateKeyOps = opsOpt.get();
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.init(key);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.init(key);
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.publicKey != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!lastPhase) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm EC");
        }
        ECDHKeyAgreement.validate(this.privateKeyOps, (ECPublicKey)key);
        this.publicKey = (ECPublicKey)key;
        int keyLenBits = this.publicKey.getParams().getCurve().getField().getFieldSize();
        this.secretLen = keyLenBits + 7 >> 3;
        return null;
    }

    private static void validateCoordinate(BigInteger c, BigInteger mod) throws InvalidKeyException {
        if (c.compareTo(BigInteger.ZERO) < 0 || c.compareTo(mod) >= 0) {
            throw new InvalidKeyException("Invalid coordinate");
        }
    }

    private static void validate(ECOperations ops, ECPublicKey key) throws InvalidKeyException {
        ECParameterSpec spec = key.getParams();
        BigInteger x = key.getW().getAffineX();
        BigInteger y = key.getW().getAffineY();
        BigInteger p = ops.getField().getSize();
        ECDHKeyAgreement.validateCoordinate(x, p);
        ECDHKeyAgreement.validateCoordinate(y, p);
        EllipticCurve curve = spec.getCurve();
        BigInteger rhs = x.modPow(BigInteger.valueOf(3L), p).add(curve.getA().multiply(x)).add(curve.getB()).mod(p);
        BigInteger lhs = y.modPow(BigInteger.valueOf(2L), p);
        if (!rhs.equals(lhs)) {
            throw new InvalidKeyException("Point is not on curve");
        }
        byte[] order = spec.getOrder().toByteArray();
        ArrayUtil.reverse(order);
        MutablePoint product = ops.multiply(key.getW(), order);
        if (!ops.isNeutral(product)) {
            throw new InvalidKeyException("Point has incorrect order");
        }
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] result;
        if (this.privateKey == null || this.publicKey == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        try {
            result = ECDHKeyAgreement.deriveKeyImpl(this.privateKey, this.privateKeyOps, this.publicKey);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.publicKey = null;
        return result;
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (this.secretLen > sharedSecret.length - offset) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (sharedSecret.length - offset) + " available");
        }
        byte[] secret = this.engineGenerateSecret();
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (!KeyUtil.isSupportedKeyAgreementOutputAlgorithm(algorithm)) {
            throw new NoSuchAlgorithmException("Unsupported secret key algorithm: " + algorithm);
        }
        return new SecretKeySpec(this.engineGenerateSecret(), algorithm);
    }

    private static byte[] deriveKeyImpl(ECPrivateKey priv, ECOperations ops, ECPublicKey pubKey) throws InvalidKeyException {
        IntegerFieldModuloP field = ops.getField();
        if (field instanceof IntegerMontgomeryFieldModuloP) {
            field = ((IntegerMontgomeryFieldModuloP)field).residueField();
        }
        MutableIntegerModuloP scalar = field.getElement(priv.getS()).mutable();
        SmallValue cofactor = field.getSmallValue(priv.getParams().getCofactor());
        scalar.setProduct(cofactor);
        int keySize = (priv.getParams().getCurve().getField().getFieldSize() + 7) / 8;
        MutablePoint product = ops.multiply(pubKey.getW(), scalar.asByteArray(keySize));
        if (ops.isNeutral(product)) {
            throw new InvalidKeyException("Product is zero");
        }
        byte[] result = product.asAffine().getX().asByteArray(keySize);
        ArrayUtil.reverse(result);
        return result;
    }
}

