/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ec;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import com.tencent.kona.crypto.util.Constants;
import com.tencent.kona.java.util.HexFormat;
import com.tencent.kona.sun.security.ec.point.AffinePoint;
import com.tencent.kona.sun.security.ec.point.MutablePoint;
import com.tencent.kona.sun.security.ec.point.Point;
import com.tencent.kona.sun.security.ec.point.ProjectivePoint;
import com.tencent.kona.sun.security.util.ArrayUtil;
import com.tencent.kona.sun.security.util.CurveDB;
import com.tencent.kona.sun.security.util.KnownOIDs;
import com.tencent.kona.sun.security.util.math.ImmutableIntegerModuloP;
import com.tencent.kona.sun.security.util.math.IntegerFieldModuloP;
import com.tencent.kona.sun.security.util.math.IntegerModuloP;
import com.tencent.kona.sun.security.util.math.IntegerMontgomeryFieldModuloP;
import com.tencent.kona.sun.security.util.math.MutableIntegerModuloP;
import com.tencent.kona.sun.security.util.math.SmallValue;
import com.tencent.kona.sun.security.util.math.intpoly.IntegerPolynomialP256;
import com.tencent.kona.sun.security.util.math.intpoly.IntegerPolynomialP384;
import com.tencent.kona.sun.security.util.math.intpoly.IntegerPolynomialP521;
import com.tencent.kona.sun.security.util.math.intpoly.IntegerPolynomialSM2;
import com.tencent.kona.sun.security.util.math.intpoly.MontgomeryIntegerPolynomialP256;
import com.tencent.kona.sun.security.util.math.intpoly.P256OrderField;
import com.tencent.kona.sun.security.util.math.intpoly.P384OrderField;
import com.tencent.kona.sun.security.util.math.intpoly.P521OrderField;
import com.tencent.kona.sun.security.util.math.intpoly.SM2OrderField;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ECOperations {
    public static final ECOperations SM2OPS = new ECOperations(IntegerPolynomialSM2.ONE.getElement(SM2ParameterSpec.CURVE.getB()), SM2OrderField.ONE);
    private static final ECOperations secp256r1Ops = new ECOperations(IntegerPolynomialP256.ONE.getElement(CurveDB.lookup(KnownOIDs.secp256r1.value()).getCurve().getB()), P256OrderField.ONE);
    static final Map<BigInteger, IntegerFieldModuloP> fields = new HashMap<BigInteger, IntegerFieldModuloP>();
    static final Map<BigInteger, IntegerFieldModuloP> orderFields;
    final ImmutableIntegerModuloP b;
    final SmallValue one;
    final SmallValue two;
    final SmallValue three;
    final SmallValue four;
    final ProjectivePoint.Immutable neutral;
    private final IntegerFieldModuloP orderField;
    private static final byte[] SM2_KEY_CAP;

    public static Optional<ECOperations> forParameters(ECParameterSpec params) {
        EllipticCurve curve = params.getCurve();
        if (!(curve.getField() instanceof ECFieldFp)) {
            return Optional.empty();
        }
        ECFieldFp primeField = (ECFieldFp)curve.getField();
        BigInteger three = BigInteger.valueOf(3L);
        if (!primeField.getP().subtract(curve.getA()).equals(three)) {
            return Optional.empty();
        }
        IntegerFieldModuloP field = fields.get(primeField.getP());
        if (field == null) {
            return Optional.empty();
        }
        IntegerFieldModuloP orderField = orderFields.get(params.getOrder());
        if (orderField == null) {
            return Optional.empty();
        }
        ImmutableIntegerModuloP b = field.getElement(curve.getB());
        ECOperations ecOps = new ECOperations(b, orderField);
        return Optional.of(ecOps);
    }

    public ECOperations(IntegerModuloP b, IntegerFieldModuloP orderField) {
        this.b = b.fixed();
        this.orderField = orderField;
        this.one = b.getField().getSmallValue(1);
        this.two = b.getField().getSmallValue(2);
        this.three = b.getField().getSmallValue(3);
        this.four = b.getField().getSmallValue(4);
        IntegerFieldModuloP field = b.getField();
        this.neutral = new ProjectivePoint.Immutable(field.get0(), field.get1(), field.get0());
    }

    public IntegerFieldModuloP getField() {
        return this.b.getField();
    }

    public IntegerFieldModuloP getOrderField() {
        return this.orderField;
    }

    protected ProjectivePoint.Immutable getNeutral() {
        return this.neutral;
    }

    public boolean isNeutral(Point p) {
        ProjectivePoint pp = (ProjectivePoint)p;
        Object z = pp.getZ();
        IntegerFieldModuloP field = z.getField();
        int byteLength = (field.getSize().bitLength() + 7) / 8;
        byte[] zBytes = z.asByteArray(byteLength);
        return ECOperations.allZero(zBytes);
    }

    public byte[] seedToScalar(byte[] seedBytes) throws IntermediateValueException {
        int seedBits = this.orderField.getSize().bitLength() + 64;
        if (seedBytes.length * 8 < seedBits) {
            throw new ProviderException("Incorrect seed length: " + seedBytes.length * 8 + " < " + seedBits);
        }
        int lastByteBits = seedBits % 8;
        if (lastByteBits != 0) {
            int lastByteIndex = seedBits / 8;
            byte mask = (byte)(255 >>> 8 - lastByteBits);
            int n = lastByteIndex;
            seedBytes[n] = (byte)(seedBytes[n] & mask);
        }
        int seedLength = (seedBits + 7) / 8;
        ImmutableIntegerModuloP scalarElem = this.orderField.getElement(seedBytes, 0, seedLength, (byte)0);
        int scalarLength = (this.orderField.getSize().bitLength() + 7) / 8;
        byte[] scalarArr = new byte[scalarLength];
        scalarElem.asByteArray(scalarArr);
        if (ECOperations.allZero(scalarArr)) {
            throw new IntermediateValueException();
        }
        return scalarArr;
    }

    public static boolean allZero(byte[] arr) {
        byte acc = 0;
        for (int i = 0; i < arr.length; ++i) {
            acc = (byte)(acc | arr[i]);
        }
        return acc == 0;
    }

    public MutablePoint multiply(AffinePoint affineP, byte[] s) {
        PointMultiplier multiplier = null;
        multiplier = this.getField() instanceof IntegerMontgomeryFieldModuloP && affineP.equals(Secp256R1GeneratorMontgomeryMultiplier.generator) ? Secp256R1GeneratorMontgomeryMultiplier.multiplier : new DefaultMultiplier(this, affineP);
        return multiplier.pointMultiply(s);
    }

    public MutablePoint multiply(ECPoint ecPoint, byte[] s) {
        return this.multiply(AffinePoint.fromECPoint(ecPoint, this.getField()), s);
    }

    public AffinePoint toAffinePoint(ECPoint ecPoint) {
        IntegerFieldModuloP field = this.getField();
        ImmutableIntegerModuloP x = field.getElement(ecPoint.getAffineX());
        ImmutableIntegerModuloP y = field.getElement(ecPoint.getAffineY());
        return new AffinePoint(x, y);
    }

    private void setDouble(ProjectivePoint.Mutable p, MutableIntegerModuloP t0, MutableIntegerModuloP t1, MutableIntegerModuloP t2, MutableIntegerModuloP t3, MutableIntegerModuloP t4) {
        t0.setValue((IntegerModuloP)p.getX()).setSquare();
        t1.setValue((IntegerModuloP)p.getY()).setSquare();
        t2.setValue((IntegerModuloP)p.getZ()).setSquare();
        t3.setValue((IntegerModuloP)p.getX()).setProduct((IntegerModuloP)p.getY());
        t4.setValue((IntegerModuloP)p.getY()).setProduct((IntegerModuloP)p.getZ());
        t3.setSum(t3);
        ((MutableIntegerModuloP)p.getZ()).setProduct((IntegerModuloP)p.getX());
        ((MutableIntegerModuloP)p.getZ()).setProduct(this.two);
        ((MutableIntegerModuloP)p.getY()).setValue(t2).setProduct(this.b);
        ((MutableIntegerModuloP)p.getY()).setDifference((IntegerModuloP)p.getZ());
        ((MutableIntegerModuloP)p.getY()).setProduct(this.three);
        ((MutableIntegerModuloP)p.getX()).setValue(t1).setDifference((IntegerModuloP)p.getY());
        ((MutableIntegerModuloP)p.getY()).setSum(t1);
        ((MutableIntegerModuloP)p.getY()).setProduct((IntegerModuloP)p.getX());
        ((MutableIntegerModuloP)p.getX()).setProduct(t3);
        t2.setProduct(this.three);
        ((MutableIntegerModuloP)p.getZ()).setProduct(this.b);
        ((MutableIntegerModuloP)p.getZ()).setDifference(t2);
        ((MutableIntegerModuloP)p.getZ()).setDifference(t0);
        ((MutableIntegerModuloP)p.getZ()).setProduct(this.three);
        t0.setProduct(this.three);
        t0.setDifference(t2);
        t0.setProduct((IntegerModuloP)p.getZ());
        ((MutableIntegerModuloP)p.getY()).setSum(t0);
        t4.setSum(t4);
        ((MutableIntegerModuloP)p.getZ()).setProduct(t4);
        ((MutableIntegerModuloP)p.getX()).setDifference((IntegerModuloP)p.getZ());
        ((MutableIntegerModuloP)p.getZ()).setValue(t4).setProduct(t1);
        ((MutableIntegerModuloP)p.getZ()).setProduct(this.four);
    }

    public void setSum(MutablePoint p, MutablePoint p2) {
        ImmutableIntegerModuloP zero = p.getField().get0();
        MutableIntegerModuloP t0 = zero.mutable();
        MutableIntegerModuloP t1 = zero.mutable();
        MutableIntegerModuloP t2 = zero.mutable();
        MutableIntegerModuloP t3 = zero.mutable();
        MutableIntegerModuloP t4 = zero.mutable();
        this.setSum((ProjectivePoint.Mutable)p, (ProjectivePoint.Mutable)p2, t0, t1, t2, t3, t4);
    }

    public void setSum(MutablePoint p, AffinePoint p2) {
        ImmutableIntegerModuloP zero = p.getField().get0();
        MutableIntegerModuloP t0 = zero.mutable();
        MutableIntegerModuloP t1 = zero.mutable();
        MutableIntegerModuloP t2 = zero.mutable();
        MutableIntegerModuloP t3 = zero.mutable();
        MutableIntegerModuloP t4 = zero.mutable();
        this.setSum((ProjectivePoint.Mutable)p, p2, t0, t1, t2, t3, t4);
    }

    private void setSum(ProjectivePoint.Mutable p, AffinePoint p2, MutableIntegerModuloP t0, MutableIntegerModuloP t1, MutableIntegerModuloP t2, MutableIntegerModuloP t3, MutableIntegerModuloP t4) {
        t0.setValue((IntegerModuloP)p.getX()).setProduct(p2.getX(false));
        t1.setValue((IntegerModuloP)p.getY()).setProduct(p2.getY(false));
        t3.setValue(p2.getX(false)).setSum(p2.getY(false));
        t4.setValue((IntegerModuloP)p.getX()).setSum((IntegerModuloP)p.getY());
        t3.setProduct(t4);
        t4.setValue(t0).setSum(t1);
        t3.setDifference(t4);
        t4.setValue(p2.getY(false)).setProduct((IntegerModuloP)p.getZ());
        t4.setSum((IntegerModuloP)p.getY());
        ((MutableIntegerModuloP)p.getY()).setValue(p2.getX(false)).setProduct((IntegerModuloP)p.getZ());
        ((MutableIntegerModuloP)p.getY()).setSum((IntegerModuloP)p.getX());
        t2.setValue((IntegerModuloP)p.getZ());
        ((MutableIntegerModuloP)p.getZ()).setProduct(this.b);
        ((MutableIntegerModuloP)p.getX()).setValue((IntegerModuloP)p.getY()).setDifference((IntegerModuloP)p.getZ());
        ((MutableIntegerModuloP)p.getX()).setProduct(this.three);
        ((MutableIntegerModuloP)p.getZ()).setValue(t1).setDifference((IntegerModuloP)p.getX());
        ((MutableIntegerModuloP)p.getX()).setSum(t1);
        ((MutableIntegerModuloP)p.getY()).setProduct(this.b);
        t2.setProduct(this.three);
        ((MutableIntegerModuloP)p.getY()).setDifference(t2);
        ((MutableIntegerModuloP)p.getY()).setDifference(t0);
        ((MutableIntegerModuloP)p.getY()).setProduct(this.three);
        t0.setProduct(this.three);
        t0.setDifference(t2);
        t1.setValue(t4).setProduct((IntegerModuloP)p.getY());
        t2.setValue(t0).setProduct((IntegerModuloP)p.getY());
        ((MutableIntegerModuloP)p.getY()).setValue((IntegerModuloP)p.getX()).setProduct((IntegerModuloP)p.getZ());
        ((MutableIntegerModuloP)p.getY()).setSum(t2);
        ((MutableIntegerModuloP)p.getX()).setProduct(t3);
        ((MutableIntegerModuloP)p.getX()).setDifference(t1);
        ((MutableIntegerModuloP)p.getZ()).setProduct(t4);
        t3.setProduct(t0);
        ((MutableIntegerModuloP)p.getZ()).setSum(t3);
    }

    private void setSum(ProjectivePoint.Mutable p, ProjectivePoint.Mutable p2, MutableIntegerModuloP t0, MutableIntegerModuloP t1, MutableIntegerModuloP t2, MutableIntegerModuloP t3, MutableIntegerModuloP t4) {
        t0.setValue((IntegerModuloP)p.getX()).setProduct((IntegerModuloP)p2.getX());
        t1.setValue((IntegerModuloP)p.getY()).setProduct((IntegerModuloP)p2.getY());
        t2.setValue((IntegerModuloP)p.getZ()).setProduct((IntegerModuloP)p2.getZ());
        t3.setValue((IntegerModuloP)p.getX()).setSum((IntegerModuloP)p.getY());
        t4.setValue((IntegerModuloP)p2.getX()).setSum((IntegerModuloP)p2.getY());
        t3.setProduct(t4);
        t4.setValue(t0).setSum(t1);
        t3.setDifference(t4);
        t4.setValue((IntegerModuloP)p.getY()).setSum((IntegerModuloP)p.getZ());
        ((MutableIntegerModuloP)p.getY()).setValue((IntegerModuloP)p2.getY()).setSum((IntegerModuloP)p2.getZ());
        t4.setProduct((IntegerModuloP)p.getY());
        ((MutableIntegerModuloP)p.getY()).setValue(t1).setSum(t2);
        t4.setDifference((IntegerModuloP)p.getY());
        ((MutableIntegerModuloP)p.getX()).setSum((IntegerModuloP)p.getZ());
        ((MutableIntegerModuloP)p.getY()).setValue((IntegerModuloP)p2.getX()).setSum((IntegerModuloP)p2.getZ());
        ((MutableIntegerModuloP)p.getX()).setProduct((IntegerModuloP)p.getY());
        ((MutableIntegerModuloP)p.getY()).setValue(t0).setSum(t2);
        ((MutableIntegerModuloP)p.getY()).setAdditiveInverse().setSum((IntegerModuloP)p.getX());
        ((MutableIntegerModuloP)p.getZ()).setValue(t2).setProduct(this.b);
        ((MutableIntegerModuloP)p.getX()).setValue((IntegerModuloP)p.getY()).setDifference((IntegerModuloP)p.getZ());
        ((MutableIntegerModuloP)p.getX()).setProduct(this.three);
        ((MutableIntegerModuloP)p.getZ()).setValue(t1).setDifference((IntegerModuloP)p.getX());
        ((MutableIntegerModuloP)p.getX()).setSum(t1);
        ((MutableIntegerModuloP)p.getY()).setProduct(this.b);
        t2.setProduct(this.three);
        ((MutableIntegerModuloP)p.getY()).setDifference(t2);
        ((MutableIntegerModuloP)p.getY()).setDifference(t0);
        ((MutableIntegerModuloP)p.getY()).setProduct(this.three);
        t0.setProduct(this.three);
        t0.setDifference(t2);
        t1.setValue(t4).setProduct((IntegerModuloP)p.getY());
        t2.setValue(t0).setProduct((IntegerModuloP)p.getY());
        ((MutableIntegerModuloP)p.getY()).setValue((IntegerModuloP)p.getX()).setProduct((IntegerModuloP)p.getZ());
        ((MutableIntegerModuloP)p.getY()).setSum(t2);
        ((MutableIntegerModuloP)p.getX()).setProduct(t3);
        ((MutableIntegerModuloP)p.getX()).setDifference(t1);
        ((MutableIntegerModuloP)p.getZ()).setProduct(t4);
        t3.setProduct(t0);
        ((MutableIntegerModuloP)p.getZ()).setSum(t3);
    }

    public boolean checkOrder(ECPoint point) {
        BigInteger x = point.getAffineX();
        BigInteger y = point.getAffineY();
        IntegerFieldModuloP field = this.getField();
        AffinePoint ap = new AffinePoint(field.getElement(x), field.getElement(y));
        byte[] scalar = this.orderField.getSize().toByteArray();
        ArrayUtil.reverse(scalar);
        return this.isNeutral(this.multiply(ap, scalar));
    }

    public byte[] generatePrivateScalar(SecureRandom random) {
        byte[] privArr = this.generatePrivateScalar0(random);
        if (this.orderField == SM2OrderField.ONE && MessageDigest.isEqual(SM2_KEY_CAP, privArr)) {
            privArr = this.generatePrivateScalar0(random);
        }
        return privArr;
    }

    private byte[] generatePrivateScalar0(SecureRandom random) {
        int seedSize = (this.orderField.getSize().bitLength() + 64 + 7) / 8;
        byte[] seedArr = new byte[seedSize];
        int numAttempts = 128;
        for (int i = 0; i < numAttempts; ++i) {
            random.nextBytes(seedArr);
            try {
                return this.seedToScalar(seedArr);
            }
            catch (IntermediateValueException intermediateValueException) {
                continue;
            }
        }
        throw new ProviderException("Unable to produce private key after " + numAttempts + " attempts");
    }

    public static ECPoint toECPoint(Point point) {
        AffinePoint affPoint = point.asAffine();
        return new ECPoint(affPoint.getX().asBigInteger(), affPoint.getY().asBigInteger());
    }

    public static boolean isInfinitePoint(Point point) {
        AffinePoint affPoint = point.asAffine();
        return affPoint.getX() == null || affPoint.getY() == null;
    }

    static {
        fields.put(IntegerPolynomialSM2.MODULUS, IntegerPolynomialSM2.ONE);
        fields.put(IntegerPolynomialP256.MODULUS, IntegerPolynomialP256.ONE);
        fields.put(IntegerPolynomialP384.MODULUS, IntegerPolynomialP384.ONE);
        fields.put(IntegerPolynomialP521.MODULUS, IntegerPolynomialP521.ONE);
        orderFields = new HashMap<BigInteger, IntegerFieldModuloP>();
        orderFields.put(SM2OrderField.MODULUS, SM2OrderField.ONE);
        orderFields.put(P256OrderField.MODULUS, P256OrderField.ONE);
        orderFields.put(P384OrderField.MODULUS, P384OrderField.ONE);
        orderFields.put(P521OrderField.MODULUS, P521OrderField.ONE);
        SM2_KEY_CAP = CryptoUtils.toBytesLE("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54122");
    }

    static final class Secp256R1GeneratorMontgomeryMultiplier
    implements PointMultiplier {
        private static final ECOperations secp256r1Ops = new ECOperations(MontgomeryIntegerPolynomialP256.ONE.getElement(CurveDB.P_256.getCurve().getB()), P256OrderField.ONE);
        public static final AffinePoint generator = AffinePoint.fromECPoint(CurveDB.P_256.getGenerator(), secp256r1Ops.getField());
        public static final PointMultiplier multiplier = new Secp256R1GeneratorMontgomeryMultiplier();
        private final ImmutableIntegerModuloP zero;
        private final ImmutableIntegerModuloP one;
        private final ProjectivePoint.Immutable[][] points;
        private final BigInteger[] base;

        private Secp256R1GeneratorMontgomeryMultiplier() {
            this(MontgomeryIntegerPolynomialP256.ONE, new DefaultMultiplier(secp256r1Ops, generator));
            if (ECOperations.class.desiredAssertionStatus()) {
                this.verifyTables(this);
            }
        }

        private Secp256R1GeneratorMontgomeryMultiplier(IntegerFieldModuloP field, PointMultiplier smallTableMultiplier) {
            this.zero = field.get0();
            this.one = field.get1();
            this.points = new ProjectivePoint.Immutable[4][16];
            BigInteger[] factors = new BigInteger[]{BigInteger.ONE, Constants.TWO.pow(64), Constants.TWO.pow(128), Constants.TWO.pow(192)};
            this.base = new BigInteger[16];
            this.base[0] = BigInteger.ZERO;
            this.base[1] = BigInteger.ONE;
            this.base[2] = factors[1];
            for (int i = 3; i < 16; ++i) {
                this.base[i] = BigInteger.ZERO;
                for (int k = 0; k < 4; ++k) {
                    if ((i >>> k & 1) == 0) continue;
                    this.base[i] = this.base[i].add(factors[k]);
                }
            }
            for (int d = 0; d < 4; ++d) {
                for (int w = 0; w < 16; ++w) {
                    BigInteger bi = this.base[w];
                    if (d != 0) {
                        bi = bi.multiply(Constants.TWO.pow(d * 16));
                    }
                    if (w == 0) {
                        this.points[d][0] = new ProjectivePoint.Immutable(this.zero.fixed(), this.one.fixed(), this.zero.fixed());
                        continue;
                    }
                    byte[] s = bi.toByteArray();
                    ArrayUtil.reverse(s);
                    ProjectivePoint.Mutable m = smallTableMultiplier.pointMultiply(s);
                    this.points[d][w] = m.fixed();
                }
            }
        }

        @Override
        public ProjectivePoint.Mutable pointMultiply(byte[] s) {
            MutableIntegerModuloP t0 = this.zero.mutable();
            MutableIntegerModuloP t1 = this.zero.mutable();
            MutableIntegerModuloP t2 = this.zero.mutable();
            MutableIntegerModuloP t3 = this.zero.mutable();
            MutableIntegerModuloP t4 = this.zero.mutable();
            ProjectivePoint.Mutable d = new ProjectivePoint.Mutable(this.zero.mutable(), this.one.mutable(), this.zero.mutable());
            MutablePoint r = d.mutable();
            for (int i = 15; i >= 0; --i) {
                Secp256R1GeneratorMontgomeryMultiplier.secp256r1Ops.setDouble(d, t0, t1, t2, t3, t4);
                for (int j = 3; j >= 0; --j) {
                    int pos = i + j * 16;
                    int index = Secp256R1GeneratorMontgomeryMultiplier.bit(s, pos + 192) << 3 | Secp256R1GeneratorMontgomeryMultiplier.bit(s, pos + 128) << 2 | Secp256R1GeneratorMontgomeryMultiplier.bit(s, pos + 64) << 1 | Secp256R1GeneratorMontgomeryMultiplier.bit(s, pos);
                    PointMultiplier.lookup(this.points[j], index, (ProjectivePoint.Mutable)r);
                    Secp256R1GeneratorMontgomeryMultiplier.secp256r1Ops.setSum(d, (ProjectivePoint.Mutable)r, t0, t1, t2, t3, t4);
                }
            }
            return d;
        }

        private static int bit(byte[] k, int i) {
            return k[i >> 3] >> (i & 7) & 1;
        }

        protected void verifyTables(PointMultiplier multiplier) {
            for (int d = 0; d < 4; ++d) {
                for (int w = 0; w < 16; ++w) {
                    BigInteger bi = this.base[w];
                    if (d != 0) {
                        bi = bi.multiply(Constants.TWO.pow(d * 16));
                    }
                    if (w == 0) continue;
                    byte[] s = new byte[32];
                    byte[] b = bi.toByteArray();
                    ArrayUtil.reverse(b);
                    System.arraycopy(b, 0, s, 0, b.length);
                    AffinePoint m = multiplier.pointMultiply(s).asAffine();
                    AffinePoint v = this.points[d][w].asAffine();
                    if (m.equals(v)) continue;
                    HexFormat hex = HexFormat.of();
                    throw new RuntimeException("Bad multiple found at [" + d + "][" + w + "]" + hex.formatHex(s) + " " + m.getX().asBigInteger());
                }
            }
        }
    }

    static final class DefaultMultiplier
    implements PointMultiplier {
        private final ECOperations ecOps;
        private final ProjectivePoint.Immutable[] pointMultiples;

        DefaultMultiplier(ECOperations ecOps, AffinePoint affineP) {
            this.ecOps = ecOps;
            this.pointMultiples = new ProjectivePoint.Immutable[16];
            IntegerFieldModuloP field = ecOps.getField();
            ImmutableIntegerModuloP zero = field.get0();
            MutableIntegerModuloP t0 = zero.mutable();
            MutableIntegerModuloP t1 = zero.mutable();
            MutableIntegerModuloP t2 = zero.mutable();
            MutableIntegerModuloP t3 = zero.mutable();
            MutableIntegerModuloP t4 = zero.mutable();
            ProjectivePoint.Mutable ps = new ProjectivePoint.Mutable(field);
            ((MutableIntegerModuloP)ps.getY()).setValue(field.get1().mutable());
            this.pointMultiples[0] = ps.fixed();
            ps.setValue(affineP);
            this.pointMultiples[1] = ps.fixed();
            for (int i = 2; i < 16; ++i) {
                ecOps.setSum(ps, affineP, t0, t1, t2, t3, t4);
                this.pointMultiples[i] = ps.fixed();
            }
        }

        @Override
        public ProjectivePoint.Mutable pointMultiply(byte[] s) {
            IntegerFieldModuloP field = this.ecOps.getField();
            ImmutableIntegerModuloP zero = field.get0();
            MutableIntegerModuloP t0 = zero.mutable();
            MutableIntegerModuloP t1 = zero.mutable();
            MutableIntegerModuloP t2 = zero.mutable();
            MutableIntegerModuloP t3 = zero.mutable();
            MutableIntegerModuloP t4 = zero.mutable();
            ProjectivePoint.Mutable result = new ProjectivePoint.Mutable(field);
            ((MutableIntegerModuloP)result.getY()).setValue(field.get1().mutable());
            ProjectivePoint.Mutable lookupResult = new ProjectivePoint.Mutable(field);
            for (int i = s.length - 1; i >= 0; --i) {
                this.double4(result, t0, t1, t2, t3, t4);
                int high = (0xFF & s[i]) >>> 4;
                PointMultiplier.lookup(this.pointMultiples, high, lookupResult);
                this.ecOps.setSum(result, lookupResult, t0, t1, t2, t3, t4);
                this.double4(result, t0, t1, t2, t3, t4);
                int low = 0xF & s[i];
                PointMultiplier.lookup(this.pointMultiples, low, lookupResult);
                this.ecOps.setSum(result, lookupResult, t0, t1, t2, t3, t4);
            }
            return result;
        }

        private void double4(ProjectivePoint.Mutable p, MutableIntegerModuloP t0, MutableIntegerModuloP t1, MutableIntegerModuloP t2, MutableIntegerModuloP t3, MutableIntegerModuloP t4) {
            for (int i = 0; i < 4; ++i) {
                this.ecOps.setDouble(p, t0, t1, t2, t3, t4);
            }
        }
    }

    static interface PointMultiplier {
        public ProjectivePoint.Mutable pointMultiply(byte[] var1);

        public static void lookup(ProjectivePoint.Immutable[] ips, int index, ProjectivePoint.Mutable result) {
            for (int i = 0; i < 16; ++i) {
                int xor = index ^ i;
                int bit3 = (xor & 8) >>> 3;
                int bit2 = (xor & 4) >>> 2;
                int bit1 = (xor & 2) >>> 1;
                int bit0 = xor & 1;
                int inverse = bit0 | bit1 | bit2 | bit3;
                int set = 1 - inverse;
                ProjectivePoint.Immutable pi = ips[i];
                result.conditionalSet((Point)pi, set);
            }
        }
    }

    public static class IntermediateValueException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

