/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.ec;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

@Deprecated
public class ECOperator {
    public static final ECOperator SM2 = new ECOperator(SM2ParameterSpec.instance());
    public static final ECOperator SECP256R1 = new ECOperator(CryptoUtils.toBigInt("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC"), CryptoUtils.toBigInt("5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B"), CryptoUtils.toBigInt("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF"), new ECPoint(CryptoUtils.toBigInt("6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296"), CryptoUtils.toBigInt("4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5")), CryptoUtils.toBigInt("FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551"), 1);
    public static final ECOperator SECP384R1 = new ECOperator(CryptoUtils.toBigInt("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC"), CryptoUtils.toBigInt("B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF"), CryptoUtils.toBigInt("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF"), new ECPoint(CryptoUtils.toBigInt("AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7"), CryptoUtils.toBigInt("3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F")), CryptoUtils.toBigInt("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973"), 1);
    public static final ECOperator SECP521R1 = new ECOperator(CryptoUtils.toBigInt("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC"), CryptoUtils.toBigInt("0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00"), CryptoUtils.toBigInt("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF"), new ECPoint(CryptoUtils.toBigInt("00C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3DBAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66"), CryptoUtils.toBigInt("011839296A789A3BC0045C8A5FB42C7D1BD998F54449579B446817AFBD17273E662C97EE72995EF42640C550B9013FAD0761353C7086A272C24088BE94769FD16650")), CryptoUtils.toBigInt("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409"), 1);
    public static final ECOperator SECP256K1 = new ECOperator(CryptoUtils.toBigInt("0000000000000000000000000000000000000000000000000000000000000000"), CryptoUtils.toBigInt("0000000000000000000000000000000000000000000000000000000000000007"), CryptoUtils.toBigInt("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F"), new ECPoint(CryptoUtils.toBigInt("79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798"), CryptoUtils.toBigInt("483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8")), CryptoUtils.toBigInt("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141"), 1);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);
    private final BigInteger a;
    private final BigInteger b;
    private final BigInteger prime;
    private final EllipticCurve curve;
    private final ECPoint generator;
    private final BigInteger order;
    private final int cofactor;

    public ECOperator(ECParameterSpec paramSpec) {
        this.curve = paramSpec.getCurve();
        this.a = this.curve.getA();
        this.b = this.curve.getB();
        this.prime = ((ECFieldFp)this.curve.getField()).getP();
        this.generator = paramSpec.getGenerator();
        this.order = paramSpec.getOrder();
        this.cofactor = paramSpec.getCofactor();
    }

    public ECOperator(BigInteger a, BigInteger b, BigInteger prime, ECPoint generator, BigInteger order, int cofactor) {
        this.a = a;
        this.b = b;
        this.prime = prime;
        this.curve = new EllipticCurve(new ECFieldFp(prime), a, b);
        this.generator = generator;
        this.order = order;
        this.cofactor = cofactor;
    }

    public BigInteger getA() {
        return this.a;
    }

    public BigInteger getB() {
        return this.b;
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public ECPoint getGenerator() {
        return this.generator;
    }

    public BigInteger getOrder() {
        return this.order;
    }

    public int getCofactor() {
        return this.cofactor;
    }

    public EllipticCurve getCurve() {
        return this.curve;
    }

    public boolean isOnCurve(ECPoint p) {
        if (ECOperator.isInfinity(p)) {
            return true;
        }
        return this.lhs(p.getAffineY()).equals(this.rhs(p.getAffineX()));
    }

    public boolean checkOrder(ECPoint p) {
        return ECOperator.isInfinity(this.multiply(p, this.order));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ECPoint add(ECPoint p1, ECPoint p2) {
        BigInteger lambda;
        if (ECOperator.isInfinity(p1)) {
            return ECOperator.isInfinity(p2) ? ECPoint.POINT_INFINITY : new ECPoint(p2.getAffineX(), p2.getAffineY());
        }
        if (ECOperator.isInfinity(p2)) {
            return new ECPoint(p1.getAffineX(), p1.getAffineY());
        }
        if (p1.getAffineX().subtract(p2.getAffineX()).mod(this.prime).equals(BigInteger.ZERO)) {
            if (!p1.getAffineY().subtract(p2.getAffineY()).mod(this.prime).equals(BigInteger.ZERO)) return ECPoint.POINT_INFINITY;
            lambda = this.lambda(p1, p2);
            if (lambda != null) return this.calcPoint(p1, p2, lambda);
            return ECPoint.POINT_INFINITY;
        }
        BigInteger nom = p2.getAffineY().subtract(p1.getAffineY());
        BigInteger denom = p2.getAffineX().subtract(p1.getAffineX());
        lambda = nom.multiply(denom.modInverse(this.prime)).mod(this.prime);
        return this.calcPoint(p1, p2, lambda);
    }

    public ECPoint doubling(ECPoint p) {
        if (ECOperator.isInfinity(p)) {
            return p;
        }
        BigInteger denom = p.getAffineY().multiply(TWO).mod(this.prime);
        if (BigInteger.ZERO.equals(denom)) {
            return ECPoint.POINT_INFINITY;
        }
        BigInteger lambda = this.lambda(p, p);
        if (lambda == null) {
            return ECPoint.POINT_INFINITY;
        }
        return this.calcPoint(p, p, lambda);
    }

    private BigInteger lambda(ECPoint p1, ECPoint p2) {
        BigInteger denom = p1.getAffineY().add(p1.getAffineY());
        if (BigInteger.ZERO.equals(denom)) {
            return null;
        }
        BigInteger nom = p1.getAffineX().multiply(p1.getAffineX()).mod(this.prime).multiply(THREE).mod(this.prime).add(this.a);
        return nom.multiply(denom.modInverse(this.prime)).mod(this.prime);
    }

    private ECPoint calcPoint(ECPoint p1, ECPoint p2, BigInteger lambda) {
        BigInteger x = lambda.multiply(lambda).mod(this.prime).subtract(p1.getAffineX()).subtract(p2.getAffineX()).mod(this.prime);
        BigInteger y = lambda.multiply(p1.getAffineX().subtract(x)).mod(this.prime).subtract(p1.getAffineY()).mod(this.prime);
        return new ECPoint(x, y);
    }

    public ECPoint subtract(ECPoint p1, ECPoint p2) {
        return this.add(p1, ECOperator.negate(p2));
    }

    public ECPoint multiply(ECPoint p, BigInteger k) {
        return this.montgomeryLadder(p, k);
    }

    private ECPoint montgomeryLadder(ECPoint p, BigInteger k) {
        ECPoint p0 = ECPoint.POINT_INFINITY;
        ECPoint p1 = p;
        int idx = k.bitLength();
        while (idx >= 0) {
            if (k.testBit(idx--)) {
                p0 = this.add(p0, p1);
                p1 = this.doubling(p1);
                continue;
            }
            p1 = this.add(p0, p1);
            p0 = this.doubling(p0);
        }
        return p0;
    }

    private ECPoint doubleAndAdd(ECPoint p, BigInteger k) {
        if (ECOperator.isInfinity(p) || k.equals(BigInteger.ZERO)) {
            return ECPoint.POINT_INFINITY;
        }
        if (k.equals(BigInteger.ONE)) {
            return p;
        }
        ECPoint result = p;
        for (int i = k.bitLength() - 2; i >= 0; --i) {
            result = this.doubling(result);
            if (!k.testBit(i)) continue;
            result = this.add(result, p);
        }
        return result;
    }

    public ECPoint multiply(ECPoint p, long k) {
        return this.multiply(p, BigInteger.valueOf(k));
    }

    public ECPoint multiply(BigInteger k) {
        return this.multiply(this.generator, k);
    }

    public ECPoint multiply(long k) {
        return this.multiply(this.generator, k);
    }

    private BigInteger lhs(BigInteger y) {
        return y.modPow(TWO, this.prime);
    }

    private BigInteger rhs(BigInteger x) {
        return x.modPow(THREE, this.prime).add(this.a.multiply(x)).add(this.b).mod(this.prime);
    }

    private static boolean isInfinity(ECPoint p) {
        return p.equals(ECPoint.POINT_INFINITY);
    }

    private static ECPoint negate(ECPoint p) {
        return ECOperator.isInfinity(p) ? ECPoint.POINT_INFINITY : new ECPoint(p.getAffineX(), p.getAffineY().negate());
    }
}

