/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.util;

import com.tencent.kona.crypto.CryptoInsts;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PBEUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PBEKeySpec getPBAKeySpec(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        char[] passwdChars;
        byte[] salt = null;
        int iCount = 0;
        if (key instanceof PBEKey) {
            PBEKey pbeKey = (PBEKey)key;
            passwdChars = pbeKey.getPassword();
            salt = pbeKey.getSalt();
            iCount = pbeKey.getIterationCount();
        } else if (key instanceof SecretKey) {
            byte[] passwdBytes;
            if (!key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3) || (passwdBytes = key.getEncoded()) == null) {
                throw new InvalidKeyException("Missing password");
            }
            passwdChars = new char[passwdBytes.length];
            for (int i = 0; i < passwdChars.length; ++i) {
                passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
            }
            Arrays.fill(passwdBytes, (byte)0);
        } else {
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        try {
            if (params == null) {
                if (salt == null || iCount == 0) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec required for salt and iteration count");
                }
            } else {
                if (!(params instanceof PBEParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
                }
                PBEParameterSpec pbeParams = (PBEParameterSpec)params;
                if (salt != null) {
                    if (!Arrays.equals(salt, pbeParams.getSalt())) {
                        throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                    }
                } else {
                    salt = pbeParams.getSalt();
                }
                if (iCount != 0) {
                    if (iCount != pbeParams.getIterationCount()) {
                        throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                    }
                } else {
                    iCount = pbeParams.getIterationCount();
                }
            }
            if (salt.length < 8) {
                throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
            }
            if (iCount <= 0) {
                throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
            }
            PBEKeySpec pBEKeySpec = new PBEKeySpec(passwdChars, salt, iCount);
            return pBEKeySpec;
        }
        finally {
            Arrays.fill(passwdChars, '\u0000');
        }
    }

    public static void checkKeyAndParams(Key key, AlgorithmParameterSpec params, String algorithm) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key instanceof PBEKey) {
            PBEParameterSpec pbeParams;
            PBEKey pbeKey = (PBEKey)key;
            if (params instanceof PBEParameterSpec && ((pbeParams = (PBEParameterSpec)params).getIterationCount() != pbeKey.getIterationCount() || !Arrays.equals(pbeParams.getSalt(), pbeKey.getSalt()))) {
                throw new InvalidAlgorithmParameterException("Salt or iteration count parameters are not consistent with PBE key");
            }
        } else {
            throw new InvalidKeyException("Cannot use a " + algorithm + " service with a key that does not implement javax.crypto.interfaces.PBEKey");
        }
    }

    public static final class PBES2Params {
        private static final int DEFAULT_SALT_LENGTH = 20;
        private static final int DEFAULT_ITERATIONS = 4096;
        private int iCount;
        private byte[] salt;
        private IvParameterSpec ivSpec;

        public void initialize(int blkSize, int opmode, int iCount, byte[] salt, AlgorithmParameterSpec ivSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            try {
                boolean doEncrypt;
                boolean bl = doEncrypt = opmode == 1 || opmode == 3;
                if (ivSpec instanceof IvParameterSpec) {
                    IvParameterSpec iv;
                    this.ivSpec = iv = (IvParameterSpec)ivSpec;
                } else if (ivSpec == null && doEncrypt) {
                    byte[] ivBytes = new byte[blkSize];
                    random.nextBytes(ivBytes);
                    this.ivSpec = new IvParameterSpec(ivBytes);
                } else {
                    throw new InvalidAlgorithmParameterException("Wrong parameter type: IvParameterSpec " + (doEncrypt ? "or null " : "") + "expected");
                }
                int n = this.iCount = iCount == 0 ? 4096 : iCount;
                if (salt == null) {
                    if (doEncrypt) {
                        salt = new byte[20];
                        random.nextBytes(salt);
                    } else {
                        throw new InvalidAlgorithmParameterException("Salt needed for decryption");
                    }
                }
                this.salt = salt;
            }
            catch (InvalidAlgorithmParameterException e) {
                this.ivSpec = null;
                this.iCount = 0;
                this.salt = null;
                throw e;
            }
        }

        public IvParameterSpec getIvSpec() {
            return this.ivSpec;
        }

        public AlgorithmParameters getAlgorithmParameters(int blkSize, String pbeAlgo, SecureRandom random) {
            AlgorithmParameters params;
            try {
                if (this.iCount == 0 && this.salt == null && this.ivSpec == null) {
                    this.initialize(blkSize, 1, 0, null, null, random);
                }
                params = CryptoInsts.getAlgorithmParameters(pbeAlgo);
                params.init(new PBEParameterSpec(this.salt, this.iCount, this.ivSpec));
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("AlgorithmParameters for " + pbeAlgo + " not configured");
            }
            catch (InvalidParameterSpecException ipse) {
                throw new RuntimeException("PBEParameterSpec not supported");
            }
            catch (InvalidAlgorithmParameterException iape) {
                throw new RuntimeException("Error initializing PBES2Params");
            }
            return params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PBEKeySpec getPBEKeySpec(int blkSize, int keyLength, int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
            PBEKeySpec pBEKeySpec;
            byte[] passwdBytes;
            block14: {
                if (key == null) {
                    throw new InvalidKeyException("Null key");
                }
                char[] passwdChars = null;
                if (!key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3) || (passwdBytes = key.getEncoded()) == null) {
                    throw new InvalidKeyException("Missing password");
                }
                try {
                    AlgorithmParameterSpec ivSpecInit;
                    byte[] saltInit;
                    int iCountInit;
                    if (params instanceof PBEParameterSpec) {
                        PBEParameterSpec pbeParams = (PBEParameterSpec)params;
                        iCountInit = PBES2Params.check(pbeParams.getIterationCount());
                        saltInit = PBES2Params.check(pbeParams.getSalt());
                        ivSpecInit = pbeParams.getParameterSpec();
                    } else if (params == null) {
                        if (key instanceof PBEKey) {
                            PBEKey pbeKey = (PBEKey)key;
                            iCountInit = PBES2Params.check(pbeKey.getIterationCount());
                            saltInit = PBES2Params.check(pbeKey.getSalt());
                        } else {
                            iCountInit = 0;
                            saltInit = null;
                        }
                        ivSpecInit = null;
                    } else {
                        throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
                    }
                    this.initialize(blkSize, opmode, iCountInit, saltInit, ivSpecInit, random);
                    passwdChars = new char[passwdBytes.length];
                    for (int i = 0; i < passwdChars.length; ++i) {
                        passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
                    }
                    pBEKeySpec = new PBEKeySpec(passwdChars, this.salt, this.iCount, keyLength);
                    if (passwdChars == null) break block14;
                }
                catch (Throwable throwable) {
                    if (passwdChars != null) {
                        Arrays.fill(passwdChars, '\u0000');
                    }
                    if (passwdBytes != null) {
                        Arrays.fill(passwdBytes, (byte)0);
                    }
                    throw throwable;
                }
                Arrays.fill(passwdChars, '\u0000');
            }
            if (passwdBytes != null) {
                Arrays.fill(passwdBytes, (byte)0);
            }
            return pBEKeySpec;
        }

        public static AlgorithmParameterSpec getParameterSpec(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
            PBEParameterSpec pbeSpec = null;
            if (params != null) {
                try {
                    pbeSpec = params.getParameterSpec(PBEParameterSpec.class);
                }
                catch (InvalidParameterSpecException ipse) {
                    throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
                }
            }
            return pbeSpec;
        }

        private static byte[] check(byte[] salt) throws InvalidAlgorithmParameterException {
            if (salt != null && salt.length < 8) {
                throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
            }
            return salt;
        }

        private static int check(int iCount) throws InvalidAlgorithmParameterException {
            if (iCount < 0) {
                throw new InvalidAlgorithmParameterException("Iteration count must be a positive number");
            }
            return iCount;
        }
    }
}

