/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.util.calendar;

import com.tencent.kona.sun.util.calendar.BaseCalendar;
import com.tencent.kona.sun.util.calendar.CalendarDate;
import com.tencent.kona.sun.util.calendar.CalendarUtils;
import com.tencent.kona.sun.util.calendar.Era;
import java.util.TimeZone;

public class JulianCalendar
extends BaseCalendar {
    private static final int BCE = 0;
    private static final int CE = 1;
    private static final Era[] eras = new Era[]{new Era("BeforeCommonEra", "B.C.E.", Long.MIN_VALUE, false), new Era("CommonEra", "C.E.", -62135709175808L, true)};
    private static final int JULIAN_EPOCH = -1;

    JulianCalendar() {
        this.setEras(eras);
    }

    @Override
    public String getName() {
        return "julian";
    }

    @Override
    public Date getCalendarDate() {
        return this.getCalendarDate(System.currentTimeMillis(), this.newCalendarDate());
    }

    @Override
    public Date getCalendarDate(long millis) {
        return this.getCalendarDate(millis, this.newCalendarDate());
    }

    @Override
    public Date getCalendarDate(long millis, CalendarDate date) {
        return (Date)super.getCalendarDate(millis, date);
    }

    @Override
    public Date getCalendarDate(long millis, TimeZone zone) {
        return this.getCalendarDate(millis, this.newCalendarDate(zone));
    }

    @Override
    public Date newCalendarDate() {
        return new Date();
    }

    @Override
    public Date newCalendarDate(TimeZone zone) {
        return new Date(zone);
    }

    @Override
    public long getFixedDate(int jyear, int month, int dayOfMonth, BaseCalendar.Date cache) {
        boolean isJan1;
        boolean bl = isJan1 = month == 1 && dayOfMonth == 1;
        if (cache != null && cache.hit(jyear)) {
            if (isJan1) {
                return cache.getCachedJan1();
            }
            return cache.getCachedJan1() + this.getDayOfYear(jyear, month, dayOfMonth) - 1L;
        }
        long y = jyear;
        long days = -2L + 365L * (y - 1L) + (long)dayOfMonth;
        days = y > 0L ? (days += (y - 1L) / 4L) : (days += CalendarUtils.floorDivide(y - 1L, 4L));
        days = month > 0 ? (days += (367L * (long)month - 362L) / 12L) : (days += CalendarUtils.floorDivide(367L * (long)month - 362L, 12L));
        if (month > 2) {
            days -= CalendarUtils.isJulianLeapYear(jyear) ? 1L : 2L;
        }
        if (cache != null && isJan1) {
            cache.setCache(jyear, days, CalendarUtils.isJulianLeapYear(jyear) ? 366 : 365);
        }
        return days;
    }

    @Override
    public void getCalendarDateFromFixedDate(CalendarDate date, long fixedDate) {
        int month;
        Date jdate = (Date)date;
        long fd = 4L * (fixedDate - -1L) + 1464L;
        int year = fd >= 0L ? (int)(fd / 1461L) : (int)CalendarUtils.floorDivide(fd, 1461L);
        int priorDays = (int)(fixedDate - this.getFixedDate(year, 1, 1, jdate));
        boolean isLeap = CalendarUtils.isJulianLeapYear(year);
        if (fixedDate >= this.getFixedDate(year, 3, 1, jdate)) {
            priorDays += isLeap ? 1 : 2;
        }
        month = (month = 12 * priorDays + 373) > 0 ? (month /= 367) : CalendarUtils.floorDivide(month, 367);
        int dayOfMonth = (int)(fixedDate - this.getFixedDate(year, month, 1, jdate)) + 1;
        int dayOfWeek = JulianCalendar.getDayOfWeekFromFixedDate(fixedDate);
        assert (dayOfWeek > 0) : "negative day of week " + dayOfWeek;
        jdate.setNormalizedYear(year);
        jdate.setMonth(month);
        jdate.setDayOfMonth(dayOfMonth);
        jdate.setDayOfWeek(dayOfWeek);
        jdate.setLeapYear(isLeap);
        jdate.setNormalized(true);
    }

    @Override
    public int getYearFromFixedDate(long fixedDate) {
        int year = (int)CalendarUtils.floorDivide(4L * (fixedDate - -1L) + 1464L, 1461L);
        return year;
    }

    @Override
    public int getDayOfWeek(CalendarDate date) {
        long fixedDate = this.getFixedDate(date);
        return JulianCalendar.getDayOfWeekFromFixedDate(fixedDate);
    }

    @Override
    boolean isLeapYear(int jyear) {
        return CalendarUtils.isJulianLeapYear(jyear);
    }

    private static class Date
    extends BaseCalendar.Date {
        protected Date() {
            this.setCache(1, -1L, 365);
        }

        protected Date(TimeZone zone) {
            super(zone);
            this.setCache(1, -1L, 365);
        }

        @Override
        public Date setEra(Era era) {
            if (era == null) {
                throw new NullPointerException();
            }
            if (era != eras[0] || era != eras[1]) {
                throw new IllegalArgumentException("unknown era: " + era);
            }
            super.setEra(era);
            return this;
        }

        protected void setKnownEra(Era era) {
            super.setEra(era);
        }

        @Override
        public int getNormalizedYear() {
            if (this.getEra() == eras[0]) {
                return 1 - this.getYear();
            }
            return this.getYear();
        }

        @Override
        public void setNormalizedYear(int year) {
            if (year <= 0) {
                this.setYear(1 - year);
                this.setKnownEra(eras[0]);
            } else {
                this.setYear(year);
                this.setKnownEra(eras[1]);
            }
        }

        @Override
        public String toString() {
            String n;
            String time = super.toString();
            time = time.substring(time.indexOf(84));
            StringBuilder sb = new StringBuilder();
            Era era = this.getEra();
            if (era != null && (n = era.getAbbreviation()) != null) {
                sb.append(n).append(' ');
            }
            sb.append(this.getYear()).append('-');
            CalendarUtils.sprintf0d(sb, this.getMonth(), 2).append('-');
            CalendarUtils.sprintf0d(sb, this.getDayOfMonth(), 2);
            sb.append(time);
            return sb.toString();
        }
    }
}

