/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoUtils;

public final class SM3Engine {
    private static final int[] IV = new int[]{1937774191, 1226093241, 388252375, -628488704, -1452330820, 372324522, -477237683, -1325724082};
    private static final int T0 = 2043430169;
    private static final int T1 = 2055708042;
    private static final int[] T = new int[]{2043430169, -208106958, -416213915, -832427829, -1664855657, 965255983, 1930511966, -433943364, -867886727, -1735773453, 823420391, 1646840782, -1001285732, -2002571463, 289824371, 579648742, -1651869049, 991229199, 1982458398, -330050500, -660100999, -1320201997, 1654563303, -985840690, -1971681379, 351604539, 703209078, 1406418156, -1482130984, 1330705329, -1633556638, 1027854021, 2055708042, -183551212, -367102423, -734204845, -1468409689, 1358147919, -1578671458, 1137624381, -2019718534, 255530229, 511060458, 1022120916, 2044241832, -206483632, -412967263, -825934525, -1651869049, 991229199, 1982458398, -330050500, -660100999, -1320201997, 1654563303, -985840690, -1971681379, 351604539, 703209078, 1406418156, -1482130984, 1330705329, -1633556638, 1027854021};
    private static final int SM3_BLOCK_INT_SIZE = 16;
    private static final byte[][] TAILS = new byte[][]{{-128, 0, 0, 0}, {-128, 0, 0}, {-128, 0}, {-128}};
    private int[] v;
    private int[] w = new int[68];
    private final byte[] word = new byte[4];
    private int wordOffset;
    private final int[] block = new int[16];
    private int blockOffset;
    private long countOfBytes;

    public SM3Engine() {
        this.reset();
    }

    public void reset() {
        this.v = (int[])IV.clone();
        this.wordOffset = 0;
        this.blockOffset = 0;
        this.countOfBytes = 0L;
    }

    public void update(byte message) {
        this.word[this.wordOffset++] = message;
        if (this.wordOffset >= this.word.length) {
            this.processWord();
        }
        ++this.countOfBytes;
    }

    public void update(byte[] message) {
        this.update(message, 0, message.length);
    }

    public void update(byte[] message, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.word[this.wordOffset++] = message[i];
            if (this.wordOffset < this.word.length) continue;
            this.processWord();
        }
        this.countOfBytes += (long)length;
    }

    public void doFinal(byte[] out) {
        this.doFinal(out, 0);
    }

    public void doFinal(byte[] out, int offset) {
        long messageLength = this.countOfBytes << 3;
        this.update(TAILS[this.wordOffset]);
        this.processLength(messageLength);
        this.processBlock();
        CryptoUtils.intsToBytes(this.v, 0, out, offset, this.v.length);
        this.reset();
    }

    private void processWord() {
        this.block[this.blockOffset] = (this.word[0] & 0xFF) << 24 | (this.word[1] & 0xFF) << 16 | (this.word[2] & 0xFF) << 8 | this.word[3] & 0xFF;
        this.wordOffset = 0;
        ++this.blockOffset;
        if (this.blockOffset >= 16) {
            this.processBlock();
        }
    }

    private void processBlock() {
        this.expand();
        this.compress();
        this.blockOffset = 0;
    }

    private void processLength(long messageLength) {
        if (this.blockOffset > 14) {
            this.block[this.blockOffset] = 0;
            ++this.blockOffset;
            this.processBlock();
        }
        while (this.blockOffset < 14) {
            this.block[this.blockOffset] = 0;
            ++this.blockOffset;
        }
        this.block[this.blockOffset++] = (int)(messageLength >>> 32);
        this.block[this.blockOffset++] = (int)messageLength;
    }

    private void expand() {
        System.arraycopy(this.block, 0, this.w, 0, this.block.length);
        for (int i = 16; i < 68; ++i) {
            this.w[i] = SM3Engine.p1(this.w[i - 16] ^ this.w[i - 9] ^ CryptoUtils.circularLeftShift(this.w[i - 3], 15)) ^ CryptoUtils.circularLeftShift(this.w[i - 13], 7) ^ this.w[i - 6];
        }
    }

    private void compress() {
        int tt2;
        int tt1;
        int ss2;
        int ss1;
        int a12;
        int i;
        int a = this.v[0];
        int b = this.v[1];
        int c = this.v[2];
        int d = this.v[3];
        int e = this.v[4];
        int f = this.v[5];
        int g = this.v[6];
        int h = this.v[7];
        for (i = 0; i < 16; ++i) {
            a12 = CryptoUtils.circularLeftShift(a, 12);
            ss1 = CryptoUtils.circularLeftShift(a12 + e + T[i], 7);
            ss2 = ss1 ^ a12;
            tt1 = SM3Engine.ff0(a, b, c) + d + ss2 + (this.w[i] ^ this.w[i + 4]);
            tt2 = SM3Engine.gg0(e, f, g) + h + ss1 + this.w[i];
            d = c;
            c = CryptoUtils.circularLeftShift(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = CryptoUtils.circularLeftShift(f, 19);
            f = e;
            e = SM3Engine.p0(tt2);
        }
        for (i = 16; i < 64; ++i) {
            a12 = CryptoUtils.circularLeftShift(a, 12);
            ss1 = CryptoUtils.circularLeftShift(a12 + e + T[i], 7);
            ss2 = ss1 ^ a12;
            tt1 = SM3Engine.ff1(a, b, c) + d + ss2 + (this.w[i] ^ this.w[i + 4]);
            tt2 = SM3Engine.gg1(e, f, g) + h + ss1 + this.w[i];
            d = c;
            c = CryptoUtils.circularLeftShift(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = CryptoUtils.circularLeftShift(f, 19);
            f = e;
            e = SM3Engine.p0(tt2);
        }
        this.v[0] = this.v[0] ^ a;
        this.v[1] = this.v[1] ^ b;
        this.v[2] = this.v[2] ^ c;
        this.v[3] = this.v[3] ^ d;
        this.v[4] = this.v[4] ^ e;
        this.v[5] = this.v[5] ^ f;
        this.v[6] = this.v[6] ^ g;
        this.v[7] = this.v[7] ^ h;
    }

    private static int ff0(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private static int ff1(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private static int gg0(int x, int y, int z) {
        return SM3Engine.ff0(x, y, z);
    }

    private static int gg1(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private static int p0(int x) {
        return x ^ CryptoUtils.circularLeftShift(x, 9) ^ CryptoUtils.circularLeftShift(x, 17);
    }

    private static int p1(int x) {
        return x ^ CryptoUtils.circularLeftShift(x, 15) ^ CryptoUtils.circularLeftShift(x, 23);
    }

    public static void main(String[] args) {
        SM3Engine.genConstantTable();
    }

    private static void genConstantTable() {
        for (int i = 0; i < 64; ++i) {
            int t = i < 16 ? 2043430169 : 2055708042;
            int n = i % 32;
            int elem = CryptoUtils.circularLeftShift(t, n);
            System.out.printf("0x%08X,", elem);
            if ((i + 1) % 4 != 0) {
                System.out.print(" ");
                continue;
            }
            System.out.println();
        }
    }
}

