/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.provider.ConstructKeys;
import com.tencent.kona.crypto.provider.SM2Engine;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.bouncycastle.jcajce.provider.asymmetric.ec.GMCipherSpi;

public class SM2Cipher
extends GMCipherSpi {
    public SM2Cipher() {
        super((org.bouncycastle.crypto.engines.SM2Engine)new SM2Engine());
    }

    public void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("none")) {
            throw new NoSuchAlgorithmException("Mode must be none");
        }
    }

    public void engineSetPadding(String paddingName) throws NoSuchPaddingException {
        if (!paddingName.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException("Padding must be NoPadding");
        }
    }

    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        super.engineInit(opmode, key, random);
    }

    public void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        super.engineInit(opmode, key, params, random);
    }

    public void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        super.engineInit(opmode, key, params, random);
    }

    public byte[] engineUpdate(byte[] in, int inOfs, int inLen) {
        throw new UnsupportedOperationException("update() is not supported yet, please use doFinal() instead.");
    }

    public int engineUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) {
        throw new UnsupportedOperationException("update() is not supported yet, please use doFinal() instead.");
    }

    public byte[] engineDoFinal(byte[] in, int inOfs, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        return super.engineDoFinal(in, inOfs, inLen);
    }

    public int engineDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return super.engineDoFinal(in, inOfs, inLen, out, outOfs);
    }

    public byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] encoded = key.getEncoded();
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("No encoded key");
        }
        try {
            return this.engineDoFinal(encoded, 0, encoded.length);
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException("Wrap key failed", e);
        }
    }

    public Key engineUnwrap(byte[] wrappedKey, String algorithm, int type) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encoded;
        if (wrappedKey == null || wrappedKey.length == 0) {
            throw new InvalidKeyException("No wrapped key");
        }
        try {
            encoded = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidKeyException("Unwrap key failed", e);
        }
        return ConstructKeys.constructKey(encoded, algorithm, type);
    }

    public AlgorithmParameters engineGetParameters() {
        return super.engineGetParameters();
    }

    public byte[] engineGetIV() {
        return super.engineGetIV();
    }

    public int engineGetBlockSize() {
        return super.engineGetBlockSize();
    }

    public int engineGetOutputSize(int inputLen) {
        return super.engineGetOutputSize(inputLen);
    }

    public int engineGetKeySize(Key key) {
        return super.engineGetKeySize(key);
    }
}

