/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.provider.SM2PrivateKey;
import com.tencent.kona.crypto.provider.SM2PublicKey;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import com.tencent.kona.sun.security.ec.ECOperations;
import com.tencent.kona.sun.security.ec.point.MutablePoint;
import com.tencent.kona.sun.security.util.ArrayUtil;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;

public class SM2KeyPairGenerator
extends KeyPairGeneratorSpi {
    private SecureRandom random;

    @Override
    public void initialize(int keySize, SecureRandom random) {
        if (keySize != 256) {
            throw new IllegalArgumentException("keySize must be 256-bit: " + keySize);
        }
        this.random = random;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) {
        if (!(params instanceof ECParameterSpec)) {
            throw new IllegalArgumentException("params must be ECParameterSpec: " + params);
        }
        this.random = random;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] privArr = ECOperations.SM2OPS.generatePrivateScalar(this.random);
        MutablePoint point = ECOperations.SM2OPS.multiply(SM2ParameterSpec.instance().getGenerator(), privArr);
        ECPoint w = ECOperations.toECPoint(point);
        SM2PublicKey publicKey = new SM2PublicKey(w);
        ArrayUtil.reverse(privArr);
        SM2PrivateKey privateKey = new SM2PrivateKey(privArr);
        Arrays.fill(privArr, (byte)0);
        return new KeyPair(publicKey, privateKey);
    }
}

