/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;

public class SM2PublicKey
implements ECPublicKey {
    private static final long serialVersionUID = 682873544399078680L;
    private final byte[] key;
    private final transient ECPoint w;

    public SM2PublicKey(byte[] key) {
        CryptoUtils.checkKey(key);
        this.key = (byte[])key.clone();
        this.w = CryptoUtils.pubKeyPoint(key);
    }

    public SM2PublicKey(ECPoint w) {
        CryptoUtils.checkKey(w);
        this.w = w;
        this.key = CryptoUtils.pubKey(w);
    }

    public SM2PublicKey(ECPublicKey ecPublicKey) {
        this(ecPublicKey.getW());
    }

    @Override
    public String getAlgorithm() {
        return "SM2";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public ECPoint getW() {
        return this.w;
    }

    @Override
    public ECParameterSpec getParams() {
        return SM2ParameterSpec.instance();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SM2PublicKey that = (SM2PublicKey)o;
        return Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }
}

