/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.util;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.spec.SM2ParameterSpec;
import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECCurve;

public class Constants {
    public static final BigInteger TWO = BigInteger.valueOf(2L);
    public static final BigInteger THREE = BigInteger.valueOf(3L);
    public static final String JDK_VERSION = CryptoUtils.privilegedGetProperty("java.specification.version");
    public static final String JDK_VENDOR = CryptoUtils.privilegedGetProperty("java.specification.vendor");
    public static final int SM2_PUBKEY_LEN = 65;
    public static final int SM2_PUBKEY_AFFINE_LEN = 32;
    public static final int SM2_PRIKEY_LEN = 32;
    public static final int SM3_BLOCK_SIZE = 64;
    public static final int SM3_DIGEST_LEN = 32;
    public static final int SM3_HMAC_LEN = 32;
    public static final int SM4_BLOCK_SIZE = 16;
    public static final int SM4_KEY_SIZE = 16;
    public static final int SM4_IV_LEN = 16;
    public static final int SM4_GCM_IV_LEN = 12;
    public static final int SM4_GCM_TAG_LEN = 16;
    private static final byte[] DEFAULT_ID = CryptoUtils.toBytes("31323334353637383132333435363738");
    public static final ECDomainParameters SM2_DOMAIN = Constants.sm2DomainParams();

    public static byte[] defaultId() {
        return (byte[])DEFAULT_ID.clone();
    }

    private static ECDomainParameters sm2DomainParams() {
        SM2ParameterSpec sm2ParamSpec = SM2ParameterSpec.instance();
        EllipticCurve sm2Curve = sm2ParamSpec.getCurve();
        ECFieldFp sm2Filed = (ECFieldFp)sm2Curve.getField();
        BigInteger order = sm2ParamSpec.getOrder();
        ECCurve.Fp curve = new ECCurve.Fp(sm2Filed.getP(), sm2Curve.getA(), sm2Curve.getB(), order, BigInteger.valueOf(sm2ParamSpec.getCofactor()));
        ECPoint sm2Generator = sm2ParamSpec.getGenerator();
        org.bouncycastle.math.ec.ECPoint generator = curve.createPoint(sm2Generator.getAffineX(), sm2Generator.getAffineY());
        return new ECDomainParameters((ECCurve)curve, generator, order);
    }
}

