/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.java.util;

import com.tencent.kona.jdk.internal.misc.SharedSecretsUtil;
import com.tencent.kona.jdk.internal.util.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public final class HexFormat {
    private static final byte[] UPPERCASE_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final byte[] LOWERCASE_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final byte[] DIGITS = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final HexFormat HEX_FORMAT = new HexFormat("", "", "", LOWERCASE_DIGITS);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final String delimiter;
    private final String prefix;
    private final String suffix;
    private final byte[] digits;

    private HexFormat(String delimiter, String prefix, String suffix, byte[] digits) {
        this.delimiter = Objects.requireNonNull(delimiter, "delimiter");
        this.prefix = Objects.requireNonNull(prefix, "prefix");
        this.suffix = Objects.requireNonNull(suffix, "suffix");
        this.digits = digits;
    }

    public static HexFormat of() {
        return HEX_FORMAT;
    }

    public static HexFormat ofDelimiter(String delimiter) {
        return new HexFormat(delimiter, "", "", LOWERCASE_DIGITS);
    }

    public HexFormat withDelimiter(String delimiter) {
        return new HexFormat(delimiter, this.prefix, this.suffix, this.digits);
    }

    public HexFormat withPrefix(String prefix) {
        return new HexFormat(this.delimiter, prefix, this.suffix, this.digits);
    }

    public HexFormat withSuffix(String suffix) {
        return new HexFormat(this.delimiter, this.prefix, suffix, this.digits);
    }

    public HexFormat withUpperCase() {
        return new HexFormat(this.delimiter, this.prefix, this.suffix, UPPERCASE_DIGITS);
    }

    public HexFormat withLowerCase() {
        return new HexFormat(this.delimiter, this.prefix, this.suffix, LOWERCASE_DIGITS);
    }

    public String delimiter() {
        return this.delimiter;
    }

    public String prefix() {
        return this.prefix;
    }

    public String suffix() {
        return this.suffix;
    }

    public boolean isUpperCase() {
        return Arrays.equals(this.digits, UPPERCASE_DIGITS);
    }

    public String formatHex(byte[] bytes) {
        return this.formatHex(bytes, 0, bytes.length);
    }

    public String formatHex(byte[] bytes, int fromIndex, int toIndex) {
        Objects.requireNonNull(bytes, "bytes");
        Preconditions.checkFromToIndex(fromIndex, toIndex, bytes.length, null);
        if (toIndex - fromIndex == 0) {
            return "";
        }
        String s = this.formatOptDelimiter(bytes, fromIndex, toIndex);
        if (s == null) {
            long stride = (long)this.prefix.length() + 2L + (long)this.suffix.length() + (long)this.delimiter.length();
            int capacity = HexFormat.checkMaxArraySize((long)(toIndex - fromIndex) * stride - (long)this.delimiter.length());
            StringBuilder sb = new StringBuilder(capacity);
            this.formatHex(sb, bytes, fromIndex, toIndex);
            s = sb.toString();
        }
        return s;
    }

    public <A extends Appendable> A formatHex(A out, byte[] bytes) {
        return this.formatHex(out, bytes, 0, bytes.length);
    }

    public <A extends Appendable> A formatHex(A out, byte[] bytes, int fromIndex, int toIndex) {
        Objects.requireNonNull(out, "out");
        Objects.requireNonNull(bytes, "bytes");
        Preconditions.checkFromToIndex(fromIndex, toIndex, bytes.length, null);
        int length = toIndex - fromIndex;
        if (length > 0) {
            try {
                String between = this.suffix + this.delimiter + this.prefix;
                out.append(this.prefix);
                this.toHexDigits(out, bytes[fromIndex]);
                if (between.isEmpty()) {
                    for (int i = 1; i < length; ++i) {
                        this.toHexDigits(out, bytes[fromIndex + i]);
                    }
                } else {
                    for (int i = 1; i < length; ++i) {
                        out.append(between);
                        this.toHexDigits(out, bytes[fromIndex + i]);
                    }
                }
                out.append(this.suffix);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe.getMessage(), ioe);
            }
        }
        return out;
    }

    private String formatOptDelimiter(byte[] bytes, int fromIndex, int toIndex) {
        byte[] rep;
        if (!this.prefix.isEmpty() || !this.suffix.isEmpty()) {
            return null;
        }
        int length = toIndex - fromIndex;
        if (this.delimiter.isEmpty()) {
            rep = new byte[HexFormat.checkMaxArraySize((long)length * 2L)];
            for (int i = 0; i < length; ++i) {
                rep[i * 2] = (byte)this.toHighHexDigit(bytes[fromIndex + i]);
                rep[i * 2 + 1] = (byte)this.toLowHexDigit(bytes[fromIndex + i]);
            }
        } else if (this.delimiter.length() == 1 && this.delimiter.charAt(0) < '\u0100') {
            char sep = this.delimiter.charAt(0);
            rep = new byte[HexFormat.checkMaxArraySize((long)length * 3L - 1L)];
            rep[0] = (byte)this.toHighHexDigit(bytes[fromIndex]);
            rep[1] = (byte)this.toLowHexDigit(bytes[fromIndex]);
            for (int i = 1; i < length; ++i) {
                rep[i * 3 - 1] = (byte)sep;
                rep[i * 3] = (byte)this.toHighHexDigit(bytes[fromIndex + i]);
                rep[i * 3 + 1] = (byte)this.toLowHexDigit(bytes[fromIndex + i]);
            }
        } else {
            return null;
        }
        try {
            return SharedSecretsUtil.langNewStringNoRepl(rep, StandardCharsets.ISO_8859_1);
        }
        catch (CharacterCodingException cce) {
            throw new AssertionError((Object)cce);
        }
    }

    private static int checkMaxArraySize(long length) {
        if (length > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("String size " + length + " exceeds maximum " + Integer.MAX_VALUE);
        }
        return (int)length;
    }

    public byte[] parseHex(CharSequence string) {
        return this.parseHex(string, 0, string.length());
    }

    public byte[] parseHex(CharSequence string, int fromIndex, int toIndex) {
        Objects.requireNonNull(string, "string");
        Preconditions.checkFromToIndex(fromIndex, toIndex, string.length(), null);
        if (fromIndex != 0 || toIndex != string.length()) {
            string = string.subSequence(fromIndex, toIndex);
        }
        if (string.length() == 0) {
            return EMPTY_BYTES;
        }
        if (this.delimiter.isEmpty() && this.prefix.isEmpty() && this.suffix.isEmpty()) {
            return HexFormat.parseNoDelimiter(string);
        }
        long valueChars = (long)this.prefix.length() + 2L + (long)this.suffix.length();
        long stride = valueChars + (long)this.delimiter.length();
        if (((long)string.length() - valueChars) % stride != 0L) {
            throw new IllegalArgumentException("extra or missing delimiters or values consisting of prefix, two hexadecimal digits, and suffix");
        }
        HexFormat.checkLiteral(string, 0, this.prefix);
        HexFormat.checkLiteral(string, string.length() - this.suffix.length(), this.suffix);
        String between = this.suffix + this.delimiter + this.prefix;
        int len = (int)(((long)string.length() - valueChars) / stride + 1L);
        byte[] bytes = new byte[len];
        int i = 0;
        int offset = this.prefix.length();
        while (i < len - 1) {
            bytes[i] = (byte)HexFormat.fromHexDigits(string, offset);
            HexFormat.checkLiteral(string, offset + 2, between);
            ++i;
            offset += 2 + between.length();
        }
        bytes[i] = (byte)HexFormat.fromHexDigits(string, offset);
        return bytes;
    }

    public byte[] parseHex(char[] chars, int fromIndex, int toIndex) {
        Objects.requireNonNull(chars, "chars");
        Preconditions.checkFromToIndex(fromIndex, toIndex, chars.length, null);
        CharBuffer cb = CharBuffer.wrap(chars, fromIndex, toIndex - fromIndex);
        return this.parseHex(cb);
    }

    private static void checkLiteral(CharSequence string, int index, String literal) {
        assert (index <= string.length() - literal.length()) : "pre-checked invariant error";
        if (literal.isEmpty() || literal.length() == 1 && literal.charAt(0) == string.charAt(index)) {
            return;
        }
        for (int i = 0; i < literal.length(); ++i) {
            if (string.charAt(index + i) == literal.charAt(i)) continue;
            throw new IllegalArgumentException(HexFormat.escapeNL("found: \"" + string.subSequence(index, index + literal.length()) + "\", expected: \"" + literal + "\", index: " + index + " ch: " + string.charAt(index + i)));
        }
    }

    private static String escapeNL(String string) {
        return string.replace("\n", "\\n").replace("\r", "\\r");
    }

    public char toLowHexDigit(int value) {
        return (char)this.digits[value & 0xF];
    }

    public char toHighHexDigit(int value) {
        return (char)this.digits[value >> 4 & 0xF];
    }

    public <A extends Appendable> A toHexDigits(A out, byte value) {
        Objects.requireNonNull(out, "out");
        try {
            out.append(this.toHighHexDigit(value));
            out.append(this.toLowHexDigit(value));
            return out;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe.getMessage(), ioe);
        }
    }

    public String toHexDigits(byte value) {
        byte[] rep = new byte[]{(byte)this.toHighHexDigit(value), (byte)this.toLowHexDigit(value)};
        try {
            return SharedSecretsUtil.langNewStringNoRepl(rep, StandardCharsets.ISO_8859_1);
        }
        catch (CharacterCodingException cce) {
            throw new AssertionError((Object)cce);
        }
    }

    public String toHexDigits(char value) {
        return this.toHexDigits((short)value);
    }

    public String toHexDigits(short value) {
        byte[] rep = new byte[]{(byte)this.toHighHexDigit((byte)(value >> 8)), (byte)this.toLowHexDigit((byte)(value >> 8)), (byte)this.toHighHexDigit((byte)value), (byte)this.toLowHexDigit((byte)value)};
        try {
            return SharedSecretsUtil.langNewStringNoRepl(rep, StandardCharsets.ISO_8859_1);
        }
        catch (CharacterCodingException cce) {
            throw new AssertionError((Object)cce);
        }
    }

    public String toHexDigits(int value) {
        byte[] rep = new byte[]{(byte)this.toHighHexDigit((byte)(value >> 24)), (byte)this.toLowHexDigit((byte)(value >> 24)), (byte)this.toHighHexDigit((byte)(value >> 16)), (byte)this.toLowHexDigit((byte)(value >> 16)), (byte)this.toHighHexDigit((byte)(value >> 8)), (byte)this.toLowHexDigit((byte)(value >> 8)), (byte)this.toHighHexDigit((byte)value), (byte)this.toLowHexDigit((byte)value)};
        try {
            return SharedSecretsUtil.langNewStringNoRepl(rep, StandardCharsets.ISO_8859_1);
        }
        catch (CharacterCodingException cce) {
            throw new AssertionError((Object)cce);
        }
    }

    public String toHexDigits(long value) {
        byte[] rep = new byte[]{(byte)this.toHighHexDigit((byte)(value >>> 56)), (byte)this.toLowHexDigit((byte)(value >>> 56)), (byte)this.toHighHexDigit((byte)(value >>> 48)), (byte)this.toLowHexDigit((byte)(value >>> 48)), (byte)this.toHighHexDigit((byte)(value >>> 40)), (byte)this.toLowHexDigit((byte)(value >>> 40)), (byte)this.toHighHexDigit((byte)(value >>> 32)), (byte)this.toLowHexDigit((byte)(value >>> 32)), (byte)this.toHighHexDigit((byte)(value >>> 24)), (byte)this.toLowHexDigit((byte)(value >>> 24)), (byte)this.toHighHexDigit((byte)(value >>> 16)), (byte)this.toLowHexDigit((byte)(value >>> 16)), (byte)this.toHighHexDigit((byte)(value >>> 8)), (byte)this.toLowHexDigit((byte)(value >>> 8)), (byte)this.toHighHexDigit((byte)value), (byte)this.toLowHexDigit((byte)value)};
        try {
            return SharedSecretsUtil.langNewStringNoRepl(rep, StandardCharsets.ISO_8859_1);
        }
        catch (CharacterCodingException cce) {
            throw new AssertionError((Object)cce);
        }
    }

    public String toHexDigits(long value, int digits) {
        if (digits < 0 || digits > 16) {
            throw new IllegalArgumentException("number of digits: " + digits);
        }
        if (digits == 0) {
            return "";
        }
        byte[] rep = new byte[digits];
        for (int i = rep.length - 1; i >= 0; --i) {
            rep[i] = (byte)this.toLowHexDigit((byte)value);
            value >>>= 4;
        }
        try {
            return SharedSecretsUtil.langNewStringNoRepl(rep, StandardCharsets.ISO_8859_1);
        }
        catch (CharacterCodingException cce) {
            throw new AssertionError((Object)cce);
        }
    }

    private static byte[] parseNoDelimiter(CharSequence string) {
        if ((string.length() & 1) != 0) {
            throw new IllegalArgumentException("string length not even: " + string.length());
        }
        byte[] bytes = new byte[string.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)HexFormat.fromHexDigits(string, i * 2);
        }
        return bytes;
    }

    private static int checkDigitCount(int fromIndex, int toIndex, int limit) {
        int length = toIndex - fromIndex;
        if (length > limit) {
            throw new IllegalArgumentException("string length greater than " + limit + ": " + length);
        }
        return length;
    }

    public static boolean isHexDigit(int ch) {
        return ch >>> 8 == 0 && DIGITS[ch] >= 0;
    }

    public static int fromHexDigit(int ch) {
        byte value;
        if (ch >>> 8 == 0 && (value = DIGITS[ch]) >= 0) {
            return value;
        }
        throw new NumberFormatException("not a hexadecimal digit: \"" + (char)ch + "\" = " + ch);
    }

    private static int fromHexDigits(CharSequence string, int index) {
        int high = HexFormat.fromHexDigit(string.charAt(index));
        int low = HexFormat.fromHexDigit(string.charAt(index + 1));
        return high << 4 | low;
    }

    public static int fromHexDigits(CharSequence string) {
        return HexFormat.fromHexDigits(string, 0, string.length());
    }

    public static int fromHexDigits(CharSequence string, int fromIndex, int toIndex) {
        Objects.requireNonNull(string, "string");
        Preconditions.checkFromToIndex(fromIndex, toIndex, string.length(), null);
        int length = HexFormat.checkDigitCount(fromIndex, toIndex, 8);
        int value = 0;
        for (int i = 0; i < length; ++i) {
            value = (value << 4) + HexFormat.fromHexDigit(string.charAt(fromIndex + i));
        }
        return value;
    }

    public static long fromHexDigitsToLong(CharSequence string) {
        return HexFormat.fromHexDigitsToLong(string, 0, string.length());
    }

    public static long fromHexDigitsToLong(CharSequence string, int fromIndex, int toIndex) {
        Objects.requireNonNull(string, "string");
        Preconditions.checkFromToIndex(fromIndex, toIndex, string.length(), null);
        int length = HexFormat.checkDigitCount(fromIndex, toIndex, 16);
        long value = 0L;
        for (int i = 0; i < length; ++i) {
            value = (value << 4) + (long)HexFormat.fromHexDigit(string.charAt(fromIndex + i));
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HexFormat otherHex = (HexFormat)o;
        return Arrays.equals(this.digits, otherHex.digits) && this.delimiter.equals(otherHex.delimiter) && this.prefix.equals(otherHex.prefix) && this.suffix.equals(otherHex.suffix);
    }

    public int hashCode() {
        int result = Objects.hash(this.delimiter, this.prefix, this.suffix);
        result = 31 * result + Boolean.hashCode(Arrays.equals(this.digits, UPPERCASE_DIGITS));
        return result;
    }

    public String toString() {
        return HexFormat.escapeNL("uppercase: " + Arrays.equals(this.digits, UPPERCASE_DIGITS) + ", delimiter: \"" + this.delimiter + "\", prefix: \"" + this.prefix + "\", suffix: \"" + this.suffix + "\"");
    }
}

