/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.action;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class GetIntegerAction
implements PrivilegedAction<Integer> {
    private final String theProp;
    private final int defaultVal;
    private final boolean defaultSet;

    public GetIntegerAction(String theProp) {
        this.theProp = theProp;
        this.defaultVal = 0;
        this.defaultSet = false;
    }

    public GetIntegerAction(String theProp, int defaultVal) {
        this.theProp = theProp;
        this.defaultVal = defaultVal;
        this.defaultSet = true;
    }

    @Override
    public Integer run() {
        Integer value = Integer.getInteger(this.theProp);
        if (value == null && this.defaultSet) {
            return this.defaultVal;
        }
        return value;
    }

    public static Integer privilegedGetProperty(String theProp) {
        if (System.getSecurityManager() == null) {
            return Integer.getInteger(theProp);
        }
        return AccessController.doPrivileged(new GetIntegerAction(theProp));
    }

    public static Integer privilegedGetProperty(String theProp, int defaultVal) {
        Integer value = System.getSecurityManager() == null ? Integer.getInteger(theProp) : AccessController.doPrivileged(new GetIntegerAction(theProp));
        return value != null ? value : defaultVal;
    }
}

