/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoInsts;
import com.tencent.kona.crypto.provider.CipherCore;
import com.tencent.kona.crypto.provider.PBKDF2Core;
import com.tencent.kona.crypto.provider.PBKDF2KeyImpl;
import com.tencent.kona.crypto.provider.SM4Crypt;
import com.tencent.kona.crypto.provider.SecureRandomHolder;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class PBES2Core
extends CipherSpi {
    private static final int DEFAULT_SALT_LENGTH = 20;
    private static final int DEFAULT_COUNT = 4096;
    private final CipherCore cipher;
    private final int keyLength;
    private final int blkSize;
    private final PBKDF2Core kdf;
    private final String pbeAlgo;
    private final String cipherAlgo;
    private int iCount = 4096;
    private byte[] salt = null;
    private IvParameterSpec ivSpec = null;

    PBES2Core(String kdfAlgo, String cipherAlgo, int keySize) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipherAlgo = cipherAlgo;
        this.keyLength = keySize * 8;
        this.pbeAlgo = "SM4".equalsIgnoreCase(cipherAlgo) ? "PBEWith" + kdfAlgo + "And" + cipherAlgo : "PBEWith" + kdfAlgo + "And" + cipherAlgo + "_" + this.keyLength;
        if ("SM4".equalsIgnoreCase(cipherAlgo)) {
            this.blkSize = 16;
            this.cipher = new CipherCore(new SM4Crypt(), this.blkSize);
            switch (kdfAlgo) {
                case "HmacSM3": {
                    this.kdf = new PBKDF2Core.HmacSM3();
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException("No Cipher implementation for " + kdfAlgo);
                }
            }
        } else {
            throw new NoSuchAlgorithmException("No Cipher implementation for " + this.pbeAlgo);
        }
        this.cipher.setMode("CBC");
        this.cipher.setPadding("PKCS5Padding");
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode != null && !mode.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (paddingScheme != null && !paddingScheme.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Invalid padding scheme: " + paddingScheme);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blkSize;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.cipher.getOutputSize(inputLen);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.cipher.getIV();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters params = null;
        if (this.salt == null) {
            this.salt = new byte[20];
            SecureRandomHolder.getRandom().nextBytes(this.salt);
            this.iCount = 4096;
        }
        if (this.ivSpec == null) {
            byte[] ivBytes = new byte[this.blkSize];
            SecureRandomHolder.getRandom().nextBytes(ivBytes);
            this.ivSpec = new IvParameterSpec(ivBytes);
        }
        PBEParameterSpec pbeSpec = new PBEParameterSpec(this.salt, this.iCount, this.ivSpec);
        try {
            params = CryptoInsts.getAlgorithmParameters(this.pbeAlgo);
            params.init(pbeSpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("SunJCE called, but not configured");
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("PBEParameterSpec not supported");
        }
        return params;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException ie) {
            throw new InvalidKeyException("requires PBE parameters", ie);
        }
    }

    private static byte[] check(byte[] salt) throws InvalidAlgorithmParameterException {
        if (salt != null && salt.length < 8) {
            throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
        }
        return salt;
    }

    private static int check(int iCount) throws InvalidAlgorithmParameterException {
        if (iCount < 0) {
            throw new InvalidAlgorithmParameterException("Iteration count must be a positive number");
        }
        return iCount == 0 ? 4096 : iCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBKDF2KeyImpl s;
        PBEKeySpec pbeSpec;
        byte[] passwdBytes;
        block19: {
            if (key == null) {
                throw new InvalidKeyException("Null key");
            }
            passwdBytes = key.getEncoded();
            char[] passwdChars = null;
            this.salt = null;
            this.iCount = 0;
            this.ivSpec = null;
            try {
                boolean doEncrypt;
                if (passwdBytes == null || !key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
                    throw new InvalidKeyException("Missing password");
                }
                boolean bl = doEncrypt = opmode == 1 || opmode == 3;
                if (params instanceof PBEParameterSpec) {
                    PBEParameterSpec pbeParams = (PBEParameterSpec)params;
                    this.salt = PBES2Core.check(pbeParams.getSalt());
                    this.iCount = PBES2Core.check(pbeParams.getIterationCount());
                    AlgorithmParameterSpec ivParams = pbeParams.getParameterSpec();
                    if (ivParams instanceof IvParameterSpec) {
                        IvParameterSpec iv;
                        this.ivSpec = iv = (IvParameterSpec)ivParams;
                    } else {
                        if (ivParams != null || !doEncrypt) throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                        byte[] ivBytes = new byte[this.blkSize];
                        random.nextBytes(ivBytes);
                        this.ivSpec = new IvParameterSpec(ivBytes);
                    }
                } else {
                    if (params != null || !doEncrypt) throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
                    if (key instanceof PBEKey) {
                        PBEKey pbeKey = (PBEKey)key;
                        this.salt = PBES2Core.check(pbeKey.getSalt());
                        this.iCount = PBES2Core.check(pbeKey.getIterationCount());
                    }
                    if (this.salt == null) {
                        this.salt = new byte[20];
                        random.nextBytes(this.salt);
                    }
                    if (this.iCount == 0) {
                        this.iCount = 4096;
                    }
                    byte[] ivBytes = new byte[this.blkSize];
                    random.nextBytes(ivBytes);
                    this.ivSpec = new IvParameterSpec(ivBytes);
                }
                passwdChars = new char[passwdBytes.length];
                for (int i = 0; i < passwdChars.length; ++i) {
                    passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
                }
                pbeSpec = new PBEKeySpec(passwdChars, this.salt, this.iCount, this.keyLength);
                if (passwdChars == null) break block19;
            }
            catch (Throwable throwable) {
                if (passwdChars != null) {
                    Arrays.fill(passwdChars, '\u0000');
                }
                if (passwdBytes == null) throw throwable;
                Arrays.fill(passwdBytes, (byte)0);
                throw throwable;
            }
            Arrays.fill(passwdChars, '\u0000');
        }
        if (passwdBytes != null) {
            Arrays.fill(passwdBytes, (byte)0);
        }
        try {
            s = (PBKDF2KeyImpl)this.kdf.engineGenerateSecret(pbeSpec);
        }
        catch (InvalidKeySpecException ikse) {
            throw new InvalidKeyException("Cannot construct PBE key", ikse);
        }
        finally {
            pbeSpec.clearPassword();
        }
        byte[] derivedKey = s.getEncoded();
        s.clearPassword();
        SecretKeySpec cipherKey = new SecretKeySpec(derivedKey, this.cipherAlgo);
        this.cipher.init(opmode, (Key)cipherKey, this.ivSpec, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pbeSpec = null;
        if (params != null) {
            try {
                pbeSpec = params.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
            }
        }
        this.engineInit(opmode, key, pbeSpec, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.update(input, inputOffset, inputLen);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.cipher.update(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inputOffset, inputLen);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return this.keyLength;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.cipher.wrap(key);
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.cipher.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    public static final class HmacSM3AndSM4
    extends PBES2Core {
        public HmacSM3AndSM4() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSM3", "SM4", 16);
        }
    }
}

