/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.spec;

import com.tencent.kona.crypto.CryptoUtils;
import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class SM2ParameterSpec
extends ECParameterSpec {
    public static final EllipticCurve CURVE = SM2ParameterSpec.curve();
    public static final ECPoint GENERATOR = SM2ParameterSpec.generator();
    public static final BigInteger ORDER = SM2ParameterSpec.order();
    public static final BigInteger COFACTOR = SM2ParameterSpec.cofactor();
    public static final String OID = "1.2.156.10197.1.301";
    private static final byte[] ENCODED = new byte[]{6, 8, 42, -127, 28, -49, 85, 1, -126, 45};

    public static SM2ParameterSpec instance() {
        return InstanceHolder.INSTANCE;
    }

    private SM2ParameterSpec() {
        super(CURVE, GENERATOR, ORDER, COFACTOR.intValue());
    }

    private static EllipticCurve curve() {
        return new EllipticCurve(new ECFieldFp(CryptoUtils.toBigInt("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF")), CryptoUtils.toBigInt("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC"), CryptoUtils.toBigInt("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93"), null);
    }

    private static ECPoint generator() {
        return new ECPoint(CryptoUtils.toBigInt("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7"), CryptoUtils.toBigInt("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"));
    }

    private static BigInteger order() {
        return CryptoUtils.toBigInt("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123");
    }

    private static BigInteger cofactor() {
        return BigInteger.ONE;
    }

    public String oid() {
        return OID;
    }

    public byte[] encoded() {
        return (byte[])ENCODED.clone();
    }

    public String toString() {
        return "SM2 (1.2.156.10197.1.301)";
    }

    private static class InstanceHolder {
        private static final SM2ParameterSpec INSTANCE = new SM2ParameterSpec();

        private InstanceHolder() {
        }
    }
}

