/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.jdk.internal.misc;

import com.tencent.kona.crypto.CryptoUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UnsafeUtil {
    private static final boolean USE_UNSAFE = CryptoUtils.privilegedGetBoolProperty("com.tencent.misc.useUnsafe", "false");
    private static final Method setMemory;
    private static final Object unsafe;

    private static boolean useUnsafe() {
        return USE_UNSAFE && !CryptoUtils.isAndroid();
    }

    public static void setMemory(long address, long bytes, byte value) {
        if (setMemory == null) {
            return;
        }
        try {
            setMemory.invoke(unsafe, address, bytes, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("setMemory failed", e);
        }
    }

    static {
        Class<?> unsafeClass = null;
        if (UnsafeUtil.useUnsafe()) {
            try {
                unsafeClass = CryptoUtils.isJdk8() ? Class.forName("sun.misc.Unsafe") : Class.forName("jdk.internal.misc.Unsafe");
            }
            catch (ClassNotFoundException e) {
                throw new InternalError("Cannot get Unsafe class", e);
            }
        }
        if (unsafeClass != null) {
            Method getUnsafeMethod;
            try {
                getUnsafeMethod = unsafeClass.getMethod("getUnsafe", new Class[0]);
                setMemory = unsafeClass.getMethod("setMemory", Long.TYPE, Long.TYPE, Byte.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError("Cannot get method", e);
            }
            getUnsafeMethod.setAccessible(true);
            try {
                unsafe = getUnsafeMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new InternalError("Cannot get Unsafe object", e);
            }
        }
        setMemory = null;
        unsafe = null;
    }
}

