/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.action;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class GetPropertyAction
implements PrivilegedAction<String> {
    private final String theProp;
    private final String defaultVal;

    public GetPropertyAction(String theProp) {
        this.theProp = theProp;
        this.defaultVal = null;
    }

    public GetPropertyAction(String theProp, String defaultVal) {
        this.theProp = theProp;
        this.defaultVal = defaultVal;
    }

    @Override
    public String run() {
        String value = System.getProperty(this.theProp);
        return value == null ? this.defaultVal : value;
    }

    public static String privilegedGetProperty(String theProp) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(theProp);
        }
        return AccessController.doPrivileged(new GetPropertyAction(theProp));
    }

    public static String privilegedGetProperty(String theProp, String defaultVal) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(theProp, defaultVal);
        }
        return AccessController.doPrivileged(new GetPropertyAction(theProp, defaultVal));
    }

    public static Properties privilegedGetProperties() {
        if (System.getSecurityManager() == null) {
            return System.getProperties();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
    }
}

