/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.util;

import com.tencent.kona.sun.security.util.DerInputStream;
import com.tencent.kona.sun.security.util.DerOutputStream;
import com.tencent.kona.sun.security.util.KnownOIDs;
import com.tencent.kona.sun.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class Oid {
    private static final int MAXIMUM_OID_SIZE = 4096;

    public static ObjectIdentifier of(String oid) {
        try {
            return Oid.of(Oid.encode(oid));
        }
        catch (IOException e) {
            throw new RuntimeException("OID is wrong: " + oid);
        }
    }

    public static ObjectIdentifier of(int[] values) {
        try {
            Oid.checkCount(values.length);
            Oid.checkFirstComponent(values[0]);
            Oid.checkSecondComponent(values[0], values[1]);
            for (int i = 2; i < values.length; ++i) {
                Oid.checkOtherComponent(i, values[i]);
            }
            return Oid.of(Oid.init(values, values.length));
        }
        catch (IOException e) {
            throw new RuntimeException("OID is wrong: " + Arrays.toString(values));
        }
    }

    public static ObjectIdentifier of(byte[] encoded) throws IOException {
        DerOutputStream derOut = new DerOutputStream();
        derOut.write((byte)6, encoded);
        return new ObjectIdentifier(new DerInputStream(derOut.toByteArray()));
    }

    public static ObjectIdentifier of(KnownOIDs oid) {
        return Oid.of(oid.value());
    }

    private static byte[] init(int[] components, int length) throws IOException {
        int pos = 0;
        byte[] tmp = new byte[length * 5 + 1];
        if (components[1] < Integer.MAX_VALUE - components[0] * 40) {
            pos += Oid.pack7Oid(components[0] * 40 + components[1], tmp, pos);
        } else {
            BigInteger big = BigInteger.valueOf(components[1]);
            big = big.add(BigInteger.valueOf((long)components[0] * 40L));
            pos += Oid.pack7Oid(big, tmp, pos);
        }
        for (int i = 2; i < length; ++i) {
            pos += Oid.pack7Oid(components[i], tmp, pos);
            Oid.checkOidSize(pos);
        }
        byte[] encoding = new byte[pos];
        System.arraycopy(tmp, 0, encoding, 0, pos);
        return encoding;
    }

    private static byte[] encode(String oid) throws IOException {
        int ch = 46;
        int start = 0;
        int pos = 0;
        byte[] tmp = new byte[oid.length()];
        int first = 0;
        int count = 0;
        try {
            int end;
            do {
                int length;
                String comp;
                if ((end = oid.indexOf(ch, start)) == -1) {
                    comp = oid.substring(start);
                    length = oid.length() - start;
                } else {
                    comp = oid.substring(start, end);
                    length = end - start;
                }
                if (length > 9) {
                    BigInteger bignum = new BigInteger(comp);
                    if (count == 0) {
                        Oid.checkFirstComponent(bignum);
                        first = bignum.intValue();
                    } else {
                        if (count == 1) {
                            Oid.checkSecondComponent(first, bignum);
                            bignum = bignum.add(BigInteger.valueOf(40L * (long)first));
                        } else {
                            Oid.checkOtherComponent(count, bignum);
                        }
                        pos += Oid.pack7Oid(bignum, tmp, pos);
                    }
                } else {
                    int num = Integer.parseInt(comp);
                    if (count == 0) {
                        Oid.checkFirstComponent(num);
                        first = num;
                    } else {
                        if (count == 1) {
                            Oid.checkSecondComponent(first, num);
                            num += 40 * first;
                        } else {
                            Oid.checkOtherComponent(count, num);
                        }
                        pos += Oid.pack7Oid(num, tmp, pos);
                    }
                }
                start = end + 1;
                ++count;
                Oid.checkOidSize(pos);
            } while (end != -1);
            Oid.checkCount(count);
            byte[] encoding = new byte[pos];
            System.arraycopy(tmp, 0, encoding, 0, pos);
            return encoding;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException("ObjectIdentifier() -- Invalid format: " + e, e);
        }
    }

    private static byte[] pack(byte[] in, int ioffset, int ilength, int iw, int ow) {
        assert (iw > 0 && iw <= 8) : "input NUB must be between 1 and 8";
        assert (ow > 0 && ow <= 8) : "output NUB must be between 1 and 8";
        if (iw == ow) {
            return (byte[])in.clone();
        }
        int bits = ilength * iw;
        byte[] out = new byte[(bits + ow - 1) / ow];
        int ipos = 0;
        int opos = (bits + ow - 1) / ow * ow - bits;
        while (ipos < bits) {
            int count = iw - ipos % iw;
            if (count > ow - opos % ow) {
                count = ow - opos % ow;
            }
            int n = opos / ow;
            out[n] = (byte)(out[n] | (in[ioffset + ipos / iw] + 256 >> iw - ipos % iw - count & (1 << count) - 1) << ow - opos % ow - count);
            ipos += count;
            opos += count;
        }
        return out;
    }

    private static int pack7Oid(byte[] in, int ioffset, int ilength, byte[] out, int ooffset) {
        byte[] pack = Oid.pack(in, ioffset, ilength, 8, 7);
        int firstNonZero = pack.length - 1;
        int i = pack.length - 2;
        while (i >= 0) {
            if (pack[i] != 0) {
                firstNonZero = i;
            }
            int n = i--;
            pack[n] = (byte)(pack[n] | 0x80);
        }
        System.arraycopy(pack, firstNonZero, out, ooffset, pack.length - firstNonZero);
        return pack.length - firstNonZero;
    }

    private static int pack8(byte[] in, int ioffset, int ilength, byte[] out, int ooffset) {
        byte[] pack = Oid.pack(in, ioffset, ilength, 7, 8);
        int firstNonZero = pack.length - 1;
        for (int i = pack.length - 2; i >= 0; --i) {
            if (pack[i] == 0) continue;
            firstNonZero = i;
        }
        System.arraycopy(pack, firstNonZero, out, ooffset, pack.length - firstNonZero);
        return pack.length - firstNonZero;
    }

    private static int pack7Oid(int input, byte[] out, int ooffset) {
        byte[] b = new byte[]{(byte)(input >> 24), (byte)(input >> 16), (byte)(input >> 8), (byte)input};
        return Oid.pack7Oid(b, 0, 4, out, ooffset);
    }

    private static int pack7Oid(BigInteger input, byte[] out, int ooffset) {
        byte[] b = input.toByteArray();
        return Oid.pack7Oid(b, 0, b.length, out, ooffset);
    }

    private static void check(byte[] encoding) throws IOException {
        int length = encoding.length;
        if (length < 1 || (encoding[length - 1] & 0x80) != 0) {
            throw new IOException("ObjectIdentifier() -- Invalid DER encoding, not ended");
        }
        for (int i = 0; i < length; ++i) {
            if (encoding[i] != -128 || i != 0 && (encoding[i - 1] & 0x80) != 0) continue;
            throw new IOException("ObjectIdentifier() -- Invalid DER encoding, useless extra octet detected");
        }
    }

    private static void checkCount(int count) throws IOException {
        if (count < 2) {
            throw new IOException("ObjectIdentifier() -- Must be at least two oid components ");
        }
    }

    private static void checkFirstComponent(int first) throws IOException {
        if (first < 0 || first > 2) {
            throw new IOException("ObjectIdentifier() -- First oid component is invalid ");
        }
    }

    private static void checkFirstComponent(BigInteger first) throws IOException {
        if (first.signum() == -1 || first.compareTo(BigInteger.valueOf(2L)) > 0) {
            throw new IOException("ObjectIdentifier() -- First oid component is invalid ");
        }
    }

    private static void checkSecondComponent(int first, int second) throws IOException {
        if (second < 0 || first != 2 && second > 39) {
            throw new IOException("ObjectIdentifier() -- Second oid component is invalid ");
        }
    }

    private static void checkSecondComponent(int first, BigInteger second) throws IOException {
        if (second.signum() == -1 || first != 2 && second.compareTo(BigInteger.valueOf(39L)) == 1) {
            throw new IOException("ObjectIdentifier() -- Second oid component is invalid ");
        }
    }

    private static void checkOtherComponent(int i, int num) throws IOException {
        if (num < 0) {
            throw new IOException("ObjectIdentifier() -- oid component #" + (i + 1) + " must be non-negative ");
        }
    }

    private static void checkOtherComponent(int i, BigInteger num) throws IOException {
        if (num.signum() == -1) {
            throw new IOException("ObjectIdentifier() -- oid component #" + (i + 1) + " must be non-negative ");
        }
    }

    private static void checkOidSize(int oidLength) throws IOException {
        if (oidLength < 0) {
            throw new IOException("ObjectIdentifier encoded length was negative: " + oidLength);
        }
        if (oidLength > 4096) {
            throw new IOException("ObjectIdentifier encoded length exceeds the restriction in JDK (OId length(>=): " + oidLength + ", Restriction: " + 4096 + ")");
        }
    }
}

