/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.sun.security.util.math.intpoly;

import com.tencent.kona.sun.security.util.math.intpoly.IntegerPolynomial;
import java.math.BigInteger;

public final class Curve448OrderField
extends IntegerPolynomial {
    private static final int BITS_PER_LIMB = 28;
    private static final int NUM_LIMBS = 16;
    private static final int MAX_ADDS = 1;
    public static final BigInteger MODULUS = Curve448OrderField.evaluateModulus();
    private static final long CARRY_ADD = 0x8000000L;
    private static final int LIMB_MASK = 0xFFFFFFF;
    public static final Curve448OrderField ONE = new Curve448OrderField();

    private Curve448OrderField() {
        super(28, 16, 1, MODULUS);
    }

    private static BigInteger evaluateModulus() {
        BigInteger result = BigInteger.valueOf(2L).pow(446);
        result = result.subtract(BigInteger.valueOf(78101261L));
        result = result.add(BigInteger.valueOf(126626091L).shiftLeft(28));
        result = result.add(BigInteger.valueOf(93279523L).shiftLeft(56));
        result = result.subtract(BigInteger.valueOf(64542500L).shiftLeft(84));
        result = result.add(BigInteger.valueOf(110109037L).shiftLeft(112));
        result = result.add(BigInteger.valueOf(77262179L).shiftLeft(140));
        result = result.subtract(BigInteger.valueOf(104575269L).shiftLeft(168));
        result = result.add(BigInteger.valueOf(130851391L).shiftLeft(196));
        result = result.subtract(BigInteger.valueOf(1L).shiftLeft(224));
        return result;
    }

    @Override
    protected void reduceIn(long[] limbs, long v, int i) {
        long t0 = 78101261L * v;
        int n = i - 16;
        limbs[n] = limbs[n] + (t0 << 2 & 0xFFFFFFFL);
        int n2 = i - 15;
        limbs[n2] = limbs[n2] + (t0 >> 26);
        long t1 = -126626091L * v;
        int n3 = i - 15;
        limbs[n3] = limbs[n3] + (t1 << 2 & 0xFFFFFFFL);
        int n4 = i - 14;
        limbs[n4] = limbs[n4] + (t1 >> 26);
        long t2 = -93279523L * v;
        int n5 = i - 14;
        limbs[n5] = limbs[n5] + (t2 << 2 & 0xFFFFFFFL);
        int n6 = i - 13;
        limbs[n6] = limbs[n6] + (t2 >> 26);
        long t3 = 64542500L * v;
        int n7 = i - 13;
        limbs[n7] = limbs[n7] + (t3 << 2 & 0xFFFFFFFL);
        int n8 = i - 12;
        limbs[n8] = limbs[n8] + (t3 >> 26);
        long t4 = -110109037L * v;
        int n9 = i - 12;
        limbs[n9] = limbs[n9] + (t4 << 2 & 0xFFFFFFFL);
        int n10 = i - 11;
        limbs[n10] = limbs[n10] + (t4 >> 26);
        long t5 = -77262179L * v;
        int n11 = i - 11;
        limbs[n11] = limbs[n11] + (t5 << 2 & 0xFFFFFFFL);
        int n12 = i - 10;
        limbs[n12] = limbs[n12] + (t5 >> 26);
        long t6 = 104575269L * v;
        int n13 = i - 10;
        limbs[n13] = limbs[n13] + (t6 << 2 & 0xFFFFFFFL);
        int n14 = i - 9;
        limbs[n14] = limbs[n14] + (t6 >> 26);
        long t7 = -130851391L * v;
        int n15 = i - 9;
        limbs[n15] = limbs[n15] + (t7 << 2 & 0xFFFFFFFL);
        int n16 = i - 8;
        limbs[n16] = limbs[n16] + (t7 >> 26);
        int n17 = i - 8;
        limbs[n17] = limbs[n17] + (v << 2 & 0xFFFFFFFL);
        int n18 = i - 7;
        limbs[n18] = limbs[n18] + (v >> 26);
    }

    @Override
    protected void finalCarryReduceLast(long[] limbs) {
        long c = limbs[15] >> 26;
        limbs[15] = limbs[15] - (c << 26);
        long t8 = 78101261L * c;
        limbs[0] = limbs[0] + t8;
        t8 = -126626091L * c;
        limbs[1] = limbs[1] + t8;
        t8 = -93279523L * c;
        limbs[2] = limbs[2] + t8;
        t8 = 64542500L * c;
        limbs[3] = limbs[3] + t8;
        t8 = -110109037L * c;
        limbs[4] = limbs[4] + t8;
        t8 = -77262179L * c;
        limbs[5] = limbs[5] + t8;
        t8 = 104575269L * c;
        limbs[6] = limbs[6] + t8;
        t8 = -130851391L * c;
        limbs[7] = limbs[7] + t8;
        limbs[8] = limbs[8] + c;
    }

    private void carryReduce(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30) {
        long c31 = 0L;
        long t0 = c0 + 0x8000000L >> 28;
        c0 -= t0 << 28;
        c1 += t0;
        t0 = c1 + 0x8000000L >> 28;
        c1 -= t0 << 28;
        c2 += t0;
        t0 = c2 + 0x8000000L >> 28;
        c2 -= t0 << 28;
        c3 += t0;
        t0 = c3 + 0x8000000L >> 28;
        c3 -= t0 << 28;
        c4 += t0;
        t0 = c4 + 0x8000000L >> 28;
        c4 -= t0 << 28;
        c5 += t0;
        t0 = c5 + 0x8000000L >> 28;
        c5 -= t0 << 28;
        c6 += t0;
        t0 = c6 + 0x8000000L >> 28;
        c6 -= t0 << 28;
        c7 += t0;
        t0 = c7 + 0x8000000L >> 28;
        c7 -= t0 << 28;
        c8 += t0;
        t0 = c8 + 0x8000000L >> 28;
        c8 -= t0 << 28;
        c9 += t0;
        t0 = c9 + 0x8000000L >> 28;
        c9 -= t0 << 28;
        c10 += t0;
        t0 = c10 + 0x8000000L >> 28;
        c10 -= t0 << 28;
        c11 += t0;
        t0 = c11 + 0x8000000L >> 28;
        c11 -= t0 << 28;
        c12 += t0;
        t0 = c12 + 0x8000000L >> 28;
        c12 -= t0 << 28;
        c13 += t0;
        t0 = c13 + 0x8000000L >> 28;
        c13 -= t0 << 28;
        c14 += t0;
        t0 = c14 + 0x8000000L >> 28;
        c14 -= t0 << 28;
        c15 += t0;
        t0 = c15 + 0x8000000L >> 28;
        c15 -= t0 << 28;
        c16 += t0;
        t0 = c16 + 0x8000000L >> 28;
        c16 -= t0 << 28;
        c17 += t0;
        t0 = c17 + 0x8000000L >> 28;
        c17 -= t0 << 28;
        c18 += t0;
        t0 = c18 + 0x8000000L >> 28;
        c18 -= t0 << 28;
        c19 += t0;
        t0 = c19 + 0x8000000L >> 28;
        c19 -= t0 << 28;
        c20 += t0;
        t0 = c20 + 0x8000000L >> 28;
        c20 -= t0 << 28;
        c21 += t0;
        t0 = c21 + 0x8000000L >> 28;
        c21 -= t0 << 28;
        c22 += t0;
        t0 = c22 + 0x8000000L >> 28;
        c22 -= t0 << 28;
        c23 += t0;
        t0 = c23 + 0x8000000L >> 28;
        c23 -= t0 << 28;
        c24 += t0;
        t0 = c24 + 0x8000000L >> 28;
        c24 -= t0 << 28;
        c25 += t0;
        t0 = c25 + 0x8000000L >> 28;
        c25 -= t0 << 28;
        c26 += t0;
        t0 = c26 + 0x8000000L >> 28;
        c26 -= t0 << 28;
        c27 += t0;
        t0 = c27 + 0x8000000L >> 28;
        c27 -= t0 << 28;
        c28 += t0;
        t0 = c28 + 0x8000000L >> 28;
        c28 -= t0 << 28;
        c29 += t0;
        t0 = c29 + 0x8000000L >> 28;
        c29 -= t0 << 28;
        c30 += t0;
        t0 = c30 + 0x8000000L >> 28;
        this.carryReduce0(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30 -= t0 << 28, c31 += t0);
    }

    void carryReduce0(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30, long c31) {
        long t0 = 78101261L * c31;
        c15 += t0 << 2 & 0xFFFFFFFL;
        c16 += t0 >> 26;
        t0 = -126626091L * c31;
        c16 += t0 << 2 & 0xFFFFFFFL;
        c17 += t0 >> 26;
        t0 = -93279523L * c31;
        c17 += t0 << 2 & 0xFFFFFFFL;
        c18 += t0 >> 26;
        t0 = 64542500L * c31;
        c18 += t0 << 2 & 0xFFFFFFFL;
        c19 += t0 >> 26;
        t0 = -110109037L * c31;
        c19 += t0 << 2 & 0xFFFFFFFL;
        c20 += t0 >> 26;
        t0 = -77262179L * c31;
        c20 += t0 << 2 & 0xFFFFFFFL;
        c21 += t0 >> 26;
        t0 = 104575269L * c31;
        c21 += t0 << 2 & 0xFFFFFFFL;
        c22 += t0 >> 26;
        t0 = -130851391L * c31;
        c22 += t0 << 2 & 0xFFFFFFFL;
        c23 += t0 >> 26;
        c23 += c31 << 2 & 0xFFFFFFFL;
        c24 += c31 >> 26;
        t0 = 78101261L * c30;
        c14 += t0 << 2 & 0xFFFFFFFL;
        c15 += t0 >> 26;
        t0 = -126626091L * c30;
        c15 += t0 << 2 & 0xFFFFFFFL;
        c16 += t0 >> 26;
        t0 = -93279523L * c30;
        c16 += t0 << 2 & 0xFFFFFFFL;
        c17 += t0 >> 26;
        t0 = 64542500L * c30;
        c17 += t0 << 2 & 0xFFFFFFFL;
        c18 += t0 >> 26;
        t0 = -110109037L * c30;
        c18 += t0 << 2 & 0xFFFFFFFL;
        c19 += t0 >> 26;
        t0 = -77262179L * c30;
        c19 += t0 << 2 & 0xFFFFFFFL;
        c20 += t0 >> 26;
        t0 = 104575269L * c30;
        c20 += t0 << 2 & 0xFFFFFFFL;
        c21 += t0 >> 26;
        t0 = -130851391L * c30;
        c21 += t0 << 2 & 0xFFFFFFFL;
        c22 += t0 >> 26;
        c22 += c30 << 2 & 0xFFFFFFFL;
        c23 += c30 >> 26;
        t0 = 78101261L * c29;
        c13 += t0 << 2 & 0xFFFFFFFL;
        c14 += t0 >> 26;
        t0 = -126626091L * c29;
        c14 += t0 << 2 & 0xFFFFFFFL;
        c15 += t0 >> 26;
        t0 = -93279523L * c29;
        c15 += t0 << 2 & 0xFFFFFFFL;
        c16 += t0 >> 26;
        t0 = 64542500L * c29;
        c16 += t0 << 2 & 0xFFFFFFFL;
        c17 += t0 >> 26;
        t0 = -110109037L * c29;
        c17 += t0 << 2 & 0xFFFFFFFL;
        c18 += t0 >> 26;
        t0 = -77262179L * c29;
        c18 += t0 << 2 & 0xFFFFFFFL;
        c19 += t0 >> 26;
        t0 = 104575269L * c29;
        c19 += t0 << 2 & 0xFFFFFFFL;
        c20 += t0 >> 26;
        t0 = -130851391L * c29;
        c20 += t0 << 2 & 0xFFFFFFFL;
        c21 += t0 >> 26;
        c21 += c29 << 2 & 0xFFFFFFFL;
        c22 += c29 >> 26;
        t0 = 78101261L * c28;
        c12 += t0 << 2 & 0xFFFFFFFL;
        c13 += t0 >> 26;
        t0 = -126626091L * c28;
        c13 += t0 << 2 & 0xFFFFFFFL;
        c14 += t0 >> 26;
        t0 = -93279523L * c28;
        c14 += t0 << 2 & 0xFFFFFFFL;
        c15 += t0 >> 26;
        t0 = 64542500L * c28;
        c15 += t0 << 2 & 0xFFFFFFFL;
        c16 += t0 >> 26;
        t0 = -110109037L * c28;
        c16 += t0 << 2 & 0xFFFFFFFL;
        c17 += t0 >> 26;
        t0 = -77262179L * c28;
        c17 += t0 << 2 & 0xFFFFFFFL;
        c18 += t0 >> 26;
        t0 = 104575269L * c28;
        c18 += t0 << 2 & 0xFFFFFFFL;
        c19 += t0 >> 26;
        t0 = -130851391L * c28;
        c19 += t0 << 2 & 0xFFFFFFFL;
        c20 += t0 >> 26;
        c20 += c28 << 2 & 0xFFFFFFFL;
        c21 += c28 >> 26;
        t0 = 78101261L * c27;
        c11 += t0 << 2 & 0xFFFFFFFL;
        c12 += t0 >> 26;
        t0 = -126626091L * c27;
        c12 += t0 << 2 & 0xFFFFFFFL;
        c13 += t0 >> 26;
        t0 = -93279523L * c27;
        c13 += t0 << 2 & 0xFFFFFFFL;
        c14 += t0 >> 26;
        t0 = 64542500L * c27;
        c14 += t0 << 2 & 0xFFFFFFFL;
        c15 += t0 >> 26;
        t0 = -110109037L * c27;
        c15 += t0 << 2 & 0xFFFFFFFL;
        c16 += t0 >> 26;
        t0 = -77262179L * c27;
        c16 += t0 << 2 & 0xFFFFFFFL;
        c17 += t0 >> 26;
        t0 = 104575269L * c27;
        c17 += t0 << 2 & 0xFFFFFFFL;
        c18 += t0 >> 26;
        t0 = -130851391L * c27;
        c18 += t0 << 2 & 0xFFFFFFFL;
        c19 += t0 >> 26;
        c19 += c27 << 2 & 0xFFFFFFFL;
        c20 += c27 >> 26;
        t0 = 78101261L * c26;
        c10 += t0 << 2 & 0xFFFFFFFL;
        c11 += t0 >> 26;
        t0 = -126626091L * c26;
        c11 += t0 << 2 & 0xFFFFFFFL;
        c12 += t0 >> 26;
        t0 = -93279523L * c26;
        c12 += t0 << 2 & 0xFFFFFFFL;
        c13 += t0 >> 26;
        t0 = 64542500L * c26;
        c13 += t0 << 2 & 0xFFFFFFFL;
        c14 += t0 >> 26;
        t0 = -110109037L * c26;
        c14 += t0 << 2 & 0xFFFFFFFL;
        c15 += t0 >> 26;
        t0 = -77262179L * c26;
        c15 += t0 << 2 & 0xFFFFFFFL;
        c16 += t0 >> 26;
        t0 = 104575269L * c26;
        c16 += t0 << 2 & 0xFFFFFFFL;
        c17 += t0 >> 26;
        t0 = -130851391L * c26;
        c17 += t0 << 2 & 0xFFFFFFFL;
        c18 += t0 >> 26;
        c18 += c26 << 2 & 0xFFFFFFFL;
        c19 += c26 >> 26;
        t0 = 78101261L * c25;
        c9 += t0 << 2 & 0xFFFFFFFL;
        c10 += t0 >> 26;
        t0 = -126626091L * c25;
        c10 += t0 << 2 & 0xFFFFFFFL;
        c11 += t0 >> 26;
        t0 = -93279523L * c25;
        c11 += t0 << 2 & 0xFFFFFFFL;
        c12 += t0 >> 26;
        t0 = 64542500L * c25;
        c12 += t0 << 2 & 0xFFFFFFFL;
        c13 += t0 >> 26;
        t0 = -110109037L * c25;
        c13 += t0 << 2 & 0xFFFFFFFL;
        c14 += t0 >> 26;
        t0 = -77262179L * c25;
        c14 += t0 << 2 & 0xFFFFFFFL;
        c15 += t0 >> 26;
        t0 = 104575269L * c25;
        c15 += t0 << 2 & 0xFFFFFFFL;
        c16 += t0 >> 26;
        t0 = -130851391L * c25;
        c16 += t0 << 2 & 0xFFFFFFFL;
        c17 += t0 >> 26;
        c17 += c25 << 2 & 0xFFFFFFFL;
        c18 += c25 >> 26;
        t0 = 78101261L * c24;
        c8 += t0 << 2 & 0xFFFFFFFL;
        c9 += t0 >> 26;
        t0 = -126626091L * c24;
        c9 += t0 << 2 & 0xFFFFFFFL;
        c10 += t0 >> 26;
        t0 = -93279523L * c24;
        c10 += t0 << 2 & 0xFFFFFFFL;
        c11 += t0 >> 26;
        t0 = 64542500L * c24;
        c11 += t0 << 2 & 0xFFFFFFFL;
        c12 += t0 >> 26;
        t0 = -110109037L * c24;
        c12 += t0 << 2 & 0xFFFFFFFL;
        c13 += t0 >> 26;
        t0 = -77262179L * c24;
        c13 += t0 << 2 & 0xFFFFFFFL;
        c14 += t0 >> 26;
        t0 = 104575269L * c24;
        c14 += t0 << 2 & 0xFFFFFFFL;
        c15 += t0 >> 26;
        t0 = -130851391L * c24;
        c15 += t0 << 2 & 0xFFFFFFFL;
        c16 += t0 >> 26;
        c16 += c24 << 2 & 0xFFFFFFFL;
        c17 += c24 >> 26;
        t0 = 78101261L * c23;
        c7 += t0 << 2 & 0xFFFFFFFL;
        c8 += t0 >> 26;
        t0 = -126626091L * c23;
        c8 += t0 << 2 & 0xFFFFFFFL;
        c9 += t0 >> 26;
        t0 = -93279523L * c23;
        c9 += t0 << 2 & 0xFFFFFFFL;
        c10 += t0 >> 26;
        t0 = 64542500L * c23;
        c10 += t0 << 2 & 0xFFFFFFFL;
        c11 += t0 >> 26;
        t0 = -110109037L * c23;
        c11 += t0 << 2 & 0xFFFFFFFL;
        c12 += t0 >> 26;
        t0 = -77262179L * c23;
        c12 += t0 << 2 & 0xFFFFFFFL;
        c13 += t0 >> 26;
        t0 = 104575269L * c23;
        c13 += t0 << 2 & 0xFFFFFFFL;
        c14 += t0 >> 26;
        t0 = -130851391L * c23;
        c14 += t0 << 2 & 0xFFFFFFFL;
        c15 += t0 >> 26;
        c15 += c23 << 2 & 0xFFFFFFFL;
        c16 += c23 >> 26;
        t0 = 78101261L * c22;
        c6 += t0 << 2 & 0xFFFFFFFL;
        c7 += t0 >> 26;
        t0 = -126626091L * c22;
        c7 += t0 << 2 & 0xFFFFFFFL;
        c8 += t0 >> 26;
        t0 = -93279523L * c22;
        c8 += t0 << 2 & 0xFFFFFFFL;
        c9 += t0 >> 26;
        t0 = 64542500L * c22;
        c9 += t0 << 2 & 0xFFFFFFFL;
        c10 += t0 >> 26;
        t0 = -110109037L * c22;
        c10 += t0 << 2 & 0xFFFFFFFL;
        c11 += t0 >> 26;
        t0 = -77262179L * c22;
        c11 += t0 << 2 & 0xFFFFFFFL;
        c12 += t0 >> 26;
        t0 = 104575269L * c22;
        c12 += t0 << 2 & 0xFFFFFFFL;
        c13 += t0 >> 26;
        t0 = -130851391L * c22;
        c13 += t0 << 2 & 0xFFFFFFFL;
        c14 += t0 >> 26;
        c14 += c22 << 2 & 0xFFFFFFFL;
        c15 += c22 >> 26;
        t0 = 78101261L * c21;
        c5 += t0 << 2 & 0xFFFFFFFL;
        c6 += t0 >> 26;
        t0 = -126626091L * c21;
        c6 += t0 << 2 & 0xFFFFFFFL;
        c7 += t0 >> 26;
        t0 = -93279523L * c21;
        c7 += t0 << 2 & 0xFFFFFFFL;
        c8 += t0 >> 26;
        t0 = 64542500L * c21;
        c8 += t0 << 2 & 0xFFFFFFFL;
        c9 += t0 >> 26;
        t0 = -110109037L * c21;
        c9 += t0 << 2 & 0xFFFFFFFL;
        c10 += t0 >> 26;
        t0 = -77262179L * c21;
        c10 += t0 << 2 & 0xFFFFFFFL;
        c11 += t0 >> 26;
        t0 = 104575269L * c21;
        c11 += t0 << 2 & 0xFFFFFFFL;
        c12 += t0 >> 26;
        t0 = -130851391L * c21;
        c12 += t0 << 2 & 0xFFFFFFFL;
        c13 += t0 >> 26;
        c13 += c21 << 2 & 0xFFFFFFFL;
        c14 += c21 >> 26;
        t0 = 78101261L * c20;
        c4 += t0 << 2 & 0xFFFFFFFL;
        c5 += t0 >> 26;
        t0 = -126626091L * c20;
        c5 += t0 << 2 & 0xFFFFFFFL;
        c6 += t0 >> 26;
        t0 = -93279523L * c20;
        c6 += t0 << 2 & 0xFFFFFFFL;
        c7 += t0 >> 26;
        t0 = 64542500L * c20;
        c7 += t0 << 2 & 0xFFFFFFFL;
        c8 += t0 >> 26;
        t0 = -110109037L * c20;
        c8 += t0 << 2 & 0xFFFFFFFL;
        c9 += t0 >> 26;
        t0 = -77262179L * c20;
        c9 += t0 << 2 & 0xFFFFFFFL;
        c10 += t0 >> 26;
        t0 = 104575269L * c20;
        c10 += t0 << 2 & 0xFFFFFFFL;
        c11 += t0 >> 26;
        t0 = -130851391L * c20;
        c11 += t0 << 2 & 0xFFFFFFFL;
        c12 += t0 >> 26;
        c12 += c20 << 2 & 0xFFFFFFFL;
        c13 += c20 >> 26;
        t0 = 78101261L * c19;
        c3 += t0 << 2 & 0xFFFFFFFL;
        c4 += t0 >> 26;
        t0 = -126626091L * c19;
        c4 += t0 << 2 & 0xFFFFFFFL;
        c5 += t0 >> 26;
        t0 = -93279523L * c19;
        c5 += t0 << 2 & 0xFFFFFFFL;
        c6 += t0 >> 26;
        t0 = 64542500L * c19;
        c6 += t0 << 2 & 0xFFFFFFFL;
        c7 += t0 >> 26;
        t0 = -110109037L * c19;
        c7 += t0 << 2 & 0xFFFFFFFL;
        c8 += t0 >> 26;
        t0 = -77262179L * c19;
        c8 += t0 << 2 & 0xFFFFFFFL;
        c9 += t0 >> 26;
        t0 = 104575269L * c19;
        c9 += t0 << 2 & 0xFFFFFFFL;
        c10 += t0 >> 26;
        t0 = -130851391L * c19;
        c10 += t0 << 2 & 0xFFFFFFFL;
        c11 += t0 >> 26;
        c11 += c19 << 2 & 0xFFFFFFFL;
        c12 += c19 >> 26;
        t0 = 78101261L * c18;
        c2 += t0 << 2 & 0xFFFFFFFL;
        c3 += t0 >> 26;
        t0 = -126626091L * c18;
        c3 += t0 << 2 & 0xFFFFFFFL;
        c4 += t0 >> 26;
        t0 = -93279523L * c18;
        c4 += t0 << 2 & 0xFFFFFFFL;
        c5 += t0 >> 26;
        t0 = 64542500L * c18;
        c5 += t0 << 2 & 0xFFFFFFFL;
        c6 += t0 >> 26;
        t0 = -110109037L * c18;
        c6 += t0 << 2 & 0xFFFFFFFL;
        c7 += t0 >> 26;
        t0 = -77262179L * c18;
        c7 += t0 << 2 & 0xFFFFFFFL;
        c8 += t0 >> 26;
        t0 = 104575269L * c18;
        c8 += t0 << 2 & 0xFFFFFFFL;
        c9 += t0 >> 26;
        t0 = -130851391L * c18;
        c9 += t0 << 2 & 0xFFFFFFFL;
        c10 += t0 >> 26;
        c10 += c18 << 2 & 0xFFFFFFFL;
        c11 += c18 >> 26;
        t0 = 78101261L * c17;
        c1 += t0 << 2 & 0xFFFFFFFL;
        c2 += t0 >> 26;
        t0 = -126626091L * c17;
        c2 += t0 << 2 & 0xFFFFFFFL;
        c3 += t0 >> 26;
        t0 = -93279523L * c17;
        c3 += t0 << 2 & 0xFFFFFFFL;
        c4 += t0 >> 26;
        t0 = 64542500L * c17;
        c4 += t0 << 2 & 0xFFFFFFFL;
        c5 += t0 >> 26;
        t0 = -110109037L * c17;
        c5 += t0 << 2 & 0xFFFFFFFL;
        c6 += t0 >> 26;
        t0 = -77262179L * c17;
        c6 += t0 << 2 & 0xFFFFFFFL;
        c7 += t0 >> 26;
        t0 = 104575269L * c17;
        c7 += t0 << 2 & 0xFFFFFFFL;
        c8 += t0 >> 26;
        t0 = -130851391L * c17;
        c8 += t0 << 2 & 0xFFFFFFFL;
        c9 += t0 >> 26;
        c9 += c17 << 2 & 0xFFFFFFFL;
        c10 += c17 >> 26;
        t0 = 78101261L * c16;
        c0 += t0 << 2 & 0xFFFFFFFL;
        c1 += t0 >> 26;
        t0 = -126626091L * c16;
        c1 += t0 << 2 & 0xFFFFFFFL;
        c2 += t0 >> 26;
        t0 = -93279523L * c16;
        c2 += t0 << 2 & 0xFFFFFFFL;
        c3 += t0 >> 26;
        t0 = 64542500L * c16;
        c3 += t0 << 2 & 0xFFFFFFFL;
        c4 += t0 >> 26;
        t0 = -110109037L * c16;
        c4 += t0 << 2 & 0xFFFFFFFL;
        c5 += t0 >> 26;
        t0 = -77262179L * c16;
        c5 += t0 << 2 & 0xFFFFFFFL;
        c6 += t0 >> 26;
        t0 = 104575269L * c16;
        c6 += t0 << 2 & 0xFFFFFFFL;
        c7 += t0 >> 26;
        t0 = -130851391L * c16;
        c8 += t0 >> 26;
        c8 += c16 << 2 & 0xFFFFFFFL;
        c9 += c16 >> 26;
        c16 = 0L;
        this.carryReduce1(r, c0, c1, c2, c3, c4, c5, c6, c7 += t0 << 2 & 0xFFFFFFFL, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30, c31);
    }

    void carryReduce1(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30, long c31) {
        long t0 = c0 + 0x8000000L >> 28;
        c0 -= t0 << 28;
        c1 += t0;
        t0 = c1 + 0x8000000L >> 28;
        c1 -= t0 << 28;
        c2 += t0;
        t0 = c2 + 0x8000000L >> 28;
        c2 -= t0 << 28;
        c3 += t0;
        t0 = c3 + 0x8000000L >> 28;
        c3 -= t0 << 28;
        c4 += t0;
        t0 = c4 + 0x8000000L >> 28;
        c4 -= t0 << 28;
        c5 += t0;
        t0 = c5 + 0x8000000L >> 28;
        c5 -= t0 << 28;
        c6 += t0;
        t0 = c6 + 0x8000000L >> 28;
        c6 -= t0 << 28;
        c7 += t0;
        t0 = c7 + 0x8000000L >> 28;
        c7 -= t0 << 28;
        c8 += t0;
        t0 = c8 + 0x8000000L >> 28;
        c8 -= t0 << 28;
        c9 += t0;
        t0 = c9 + 0x8000000L >> 28;
        c9 -= t0 << 28;
        c10 += t0;
        t0 = c10 + 0x8000000L >> 28;
        c10 -= t0 << 28;
        c11 += t0;
        t0 = c11 + 0x8000000L >> 28;
        c11 -= t0 << 28;
        c12 += t0;
        t0 = c12 + 0x8000000L >> 28;
        c12 -= t0 << 28;
        c13 += t0;
        t0 = c13 + 0x8000000L >> 28;
        c13 -= t0 << 28;
        c14 += t0;
        t0 = c14 + 0x8000000L >> 28;
        c14 -= t0 << 28;
        c15 += t0;
        t0 = c15 + 0x8000000L >> 28;
        this.carryReduce2(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15 -= t0 << 28, c16 += t0, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30, c31);
    }

    void carryReduce2(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16, long c17, long c18, long c19, long c20, long c21, long c22, long c23, long c24, long c25, long c26, long c27, long c28, long c29, long c30, long c31) {
        long t0 = 78101261L * c16;
        c0 += t0 << 2 & 0xFFFFFFFL;
        c1 += t0 >> 26;
        t0 = -126626091L * c16;
        c1 += t0 << 2 & 0xFFFFFFFL;
        c2 += t0 >> 26;
        t0 = -93279523L * c16;
        c2 += t0 << 2 & 0xFFFFFFFL;
        c3 += t0 >> 26;
        t0 = 64542500L * c16;
        c3 += t0 << 2 & 0xFFFFFFFL;
        c4 += t0 >> 26;
        t0 = -110109037L * c16;
        c4 += t0 << 2 & 0xFFFFFFFL;
        c5 += t0 >> 26;
        t0 = -77262179L * c16;
        c5 += t0 << 2 & 0xFFFFFFFL;
        c6 += t0 >> 26;
        t0 = 104575269L * c16;
        c6 += t0 << 2 & 0xFFFFFFFL;
        c7 += t0 >> 26;
        t0 = -130851391L * c16;
        c7 += t0 << 2 & 0xFFFFFFFL;
        c8 += t0 >> 26;
        c8 += c16 << 2 & 0xFFFFFFFL;
        c9 += c16 >> 26;
        t0 = c0 + 0x8000000L >> 28;
        c0 -= t0 << 28;
        c1 += t0;
        t0 = c1 + 0x8000000L >> 28;
        c1 -= t0 << 28;
        c2 += t0;
        t0 = c2 + 0x8000000L >> 28;
        c2 -= t0 << 28;
        c3 += t0;
        t0 = c3 + 0x8000000L >> 28;
        c3 -= t0 << 28;
        c4 += t0;
        t0 = c4 + 0x8000000L >> 28;
        c4 -= t0 << 28;
        c5 += t0;
        t0 = c5 + 0x8000000L >> 28;
        c5 -= t0 << 28;
        c6 += t0;
        t0 = c6 + 0x8000000L >> 28;
        c6 -= t0 << 28;
        c7 += t0;
        t0 = c7 + 0x8000000L >> 28;
        c7 -= t0 << 28;
        c8 += t0;
        t0 = c8 + 0x8000000L >> 28;
        c8 -= t0 << 28;
        c9 += t0;
        t0 = c9 + 0x8000000L >> 28;
        c9 -= t0 << 28;
        c10 += t0;
        t0 = c10 + 0x8000000L >> 28;
        c10 -= t0 << 28;
        c11 += t0;
        t0 = c11 + 0x8000000L >> 28;
        c11 -= t0 << 28;
        c12 += t0;
        t0 = c12 + 0x8000000L >> 28;
        c12 -= t0 << 28;
        c13 += t0;
        t0 = c13 + 0x8000000L >> 28;
        c13 -= t0 << 28;
        c14 += t0;
        t0 = c14 + 0x8000000L >> 28;
        c14 -= t0 << 28;
        c15 += t0;
        r[0] = c0;
        r[1] = c1;
        r[2] = c2;
        r[3] = c3;
        r[4] = c4;
        r[5] = c5;
        r[6] = c6;
        r[7] = c7;
        r[8] = c8;
        r[9] = c9;
        r[10] = c10;
        r[11] = c11;
        r[12] = c12;
        r[13] = c13;
        r[14] = c14;
        r[15] = c15;
    }

    private void carryReduce(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15) {
        long c16 = 0L;
        long t0 = c0 + 0x8000000L >> 28;
        c0 -= t0 << 28;
        c1 += t0;
        t0 = c1 + 0x8000000L >> 28;
        c1 -= t0 << 28;
        c2 += t0;
        t0 = c2 + 0x8000000L >> 28;
        c2 -= t0 << 28;
        c3 += t0;
        t0 = c3 + 0x8000000L >> 28;
        c3 -= t0 << 28;
        c4 += t0;
        t0 = c4 + 0x8000000L >> 28;
        c4 -= t0 << 28;
        c5 += t0;
        t0 = c5 + 0x8000000L >> 28;
        c5 -= t0 << 28;
        c6 += t0;
        t0 = c6 + 0x8000000L >> 28;
        c6 -= t0 << 28;
        c7 += t0;
        t0 = c7 + 0x8000000L >> 28;
        c7 -= t0 << 28;
        c8 += t0;
        t0 = c8 + 0x8000000L >> 28;
        c8 -= t0 << 28;
        c9 += t0;
        t0 = c9 + 0x8000000L >> 28;
        c9 -= t0 << 28;
        c10 += t0;
        t0 = c10 + 0x8000000L >> 28;
        c10 -= t0 << 28;
        c11 += t0;
        t0 = c11 + 0x8000000L >> 28;
        c11 -= t0 << 28;
        c12 += t0;
        t0 = c12 + 0x8000000L >> 28;
        c12 -= t0 << 28;
        c13 += t0;
        t0 = c13 + 0x8000000L >> 28;
        c13 -= t0 << 28;
        c14 += t0;
        t0 = c14 + 0x8000000L >> 28;
        c14 -= t0 << 28;
        c15 += t0;
        t0 = c15 + 0x8000000L >> 28;
        this.carryReduce0(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15 -= t0 << 28, c16 += t0);
    }

    void carryReduce0(long[] r, long c0, long c1, long c2, long c3, long c4, long c5, long c6, long c7, long c8, long c9, long c10, long c11, long c12, long c13, long c14, long c15, long c16) {
        long t0 = 78101261L * c16;
        c0 += t0 << 2 & 0xFFFFFFFL;
        c1 += t0 >> 26;
        t0 = -126626091L * c16;
        c1 += t0 << 2 & 0xFFFFFFFL;
        c2 += t0 >> 26;
        t0 = -93279523L * c16;
        c2 += t0 << 2 & 0xFFFFFFFL;
        c3 += t0 >> 26;
        t0 = 64542500L * c16;
        c3 += t0 << 2 & 0xFFFFFFFL;
        c4 += t0 >> 26;
        t0 = -110109037L * c16;
        c4 += t0 << 2 & 0xFFFFFFFL;
        c5 += t0 >> 26;
        t0 = -77262179L * c16;
        c5 += t0 << 2 & 0xFFFFFFFL;
        c6 += t0 >> 26;
        t0 = 104575269L * c16;
        c6 += t0 << 2 & 0xFFFFFFFL;
        c7 += t0 >> 26;
        t0 = -130851391L * c16;
        c7 += t0 << 2 & 0xFFFFFFFL;
        c8 += t0 >> 26;
        c8 += c16 << 2 & 0xFFFFFFFL;
        c9 += c16 >> 26;
        t0 = c0 + 0x8000000L >> 28;
        c0 -= t0 << 28;
        c1 += t0;
        t0 = c1 + 0x8000000L >> 28;
        c1 -= t0 << 28;
        c2 += t0;
        t0 = c2 + 0x8000000L >> 28;
        c2 -= t0 << 28;
        c3 += t0;
        t0 = c3 + 0x8000000L >> 28;
        c3 -= t0 << 28;
        c4 += t0;
        t0 = c4 + 0x8000000L >> 28;
        c4 -= t0 << 28;
        c5 += t0;
        t0 = c5 + 0x8000000L >> 28;
        c5 -= t0 << 28;
        c6 += t0;
        t0 = c6 + 0x8000000L >> 28;
        c6 -= t0 << 28;
        c7 += t0;
        t0 = c7 + 0x8000000L >> 28;
        c7 -= t0 << 28;
        c8 += t0;
        t0 = c8 + 0x8000000L >> 28;
        c8 -= t0 << 28;
        c9 += t0;
        t0 = c9 + 0x8000000L >> 28;
        c9 -= t0 << 28;
        c10 += t0;
        t0 = c10 + 0x8000000L >> 28;
        c10 -= t0 << 28;
        c11 += t0;
        t0 = c11 + 0x8000000L >> 28;
        c11 -= t0 << 28;
        c12 += t0;
        t0 = c12 + 0x8000000L >> 28;
        c12 -= t0 << 28;
        c13 += t0;
        t0 = c13 + 0x8000000L >> 28;
        c13 -= t0 << 28;
        c14 += t0;
        t0 = c14 + 0x8000000L >> 28;
        c14 -= t0 << 28;
        c15 += t0;
        r[0] = c0;
        r[1] = c1;
        r[2] = c2;
        r[3] = c3;
        r[4] = c4;
        r[5] = c5;
        r[6] = c6;
        r[7] = c7;
        r[8] = c8;
        r[9] = c9;
        r[10] = c10;
        r[11] = c11;
        r[12] = c12;
        r[13] = c13;
        r[14] = c14;
        r[15] = c15;
    }

    @Override
    protected void mult(long[] a, long[] b, long[] r) {
        long c0 = a[0] * b[0];
        long c1 = a[0] * b[1] + a[1] * b[0];
        long c2 = a[0] * b[2] + a[1] * b[1] + a[2] * b[0];
        long c3 = a[0] * b[3] + a[1] * b[2] + a[2] * b[1] + a[3] * b[0];
        long c4 = a[0] * b[4] + a[1] * b[3] + a[2] * b[2] + a[3] * b[1] + a[4] * b[0];
        long c5 = a[0] * b[5] + a[1] * b[4] + a[2] * b[3] + a[3] * b[2] + a[4] * b[1] + a[5] * b[0];
        long c6 = a[0] * b[6] + a[1] * b[5] + a[2] * b[4] + a[3] * b[3] + a[4] * b[2] + a[5] * b[1] + a[6] * b[0];
        long c7 = a[0] * b[7] + a[1] * b[6] + a[2] * b[5] + a[3] * b[4] + a[4] * b[3] + a[5] * b[2] + a[6] * b[1] + a[7] * b[0];
        long c8 = a[0] * b[8] + a[1] * b[7] + a[2] * b[6] + a[3] * b[5] + a[4] * b[4] + a[5] * b[3] + a[6] * b[2] + a[7] * b[1] + a[8] * b[0];
        long c9 = a[0] * b[9] + a[1] * b[8] + a[2] * b[7] + a[3] * b[6] + a[4] * b[5] + a[5] * b[4] + a[6] * b[3] + a[7] * b[2] + a[8] * b[1] + a[9] * b[0];
        long c10 = a[0] * b[10] + a[1] * b[9] + a[2] * b[8] + a[3] * b[7] + a[4] * b[6] + a[5] * b[5] + a[6] * b[4] + a[7] * b[3] + a[8] * b[2] + a[9] * b[1] + a[10] * b[0];
        long c11 = a[0] * b[11] + a[1] * b[10] + a[2] * b[9] + a[3] * b[8] + a[4] * b[7] + a[5] * b[6] + a[6] * b[5] + a[7] * b[4] + a[8] * b[3] + a[9] * b[2] + a[10] * b[1] + a[11] * b[0];
        long c12 = a[0] * b[12] + a[1] * b[11] + a[2] * b[10] + a[3] * b[9] + a[4] * b[8] + a[5] * b[7] + a[6] * b[6] + a[7] * b[5] + a[8] * b[4] + a[9] * b[3] + a[10] * b[2] + a[11] * b[1] + a[12] * b[0];
        long c13 = a[0] * b[13] + a[1] * b[12] + a[2] * b[11] + a[3] * b[10] + a[4] * b[9] + a[5] * b[8] + a[6] * b[7] + a[7] * b[6] + a[8] * b[5] + a[9] * b[4] + a[10] * b[3] + a[11] * b[2] + a[12] * b[1] + a[13] * b[0];
        long c14 = a[0] * b[14] + a[1] * b[13] + a[2] * b[12] + a[3] * b[11] + a[4] * b[10] + a[5] * b[9] + a[6] * b[8] + a[7] * b[7] + a[8] * b[6] + a[9] * b[5] + a[10] * b[4] + a[11] * b[3] + a[12] * b[2] + a[13] * b[1] + a[14] * b[0];
        long c15 = a[0] * b[15] + a[1] * b[14] + a[2] * b[13] + a[3] * b[12] + a[4] * b[11] + a[5] * b[10] + a[6] * b[9] + a[7] * b[8] + a[8] * b[7] + a[9] * b[6] + a[10] * b[5] + a[11] * b[4] + a[12] * b[3] + a[13] * b[2] + a[14] * b[1] + a[15] * b[0];
        long c16 = a[1] * b[15] + a[2] * b[14] + a[3] * b[13] + a[4] * b[12] + a[5] * b[11] + a[6] * b[10] + a[7] * b[9] + a[8] * b[8] + a[9] * b[7] + a[10] * b[6] + a[11] * b[5] + a[12] * b[4] + a[13] * b[3] + a[14] * b[2] + a[15] * b[1];
        long c17 = a[2] * b[15] + a[3] * b[14] + a[4] * b[13] + a[5] * b[12] + a[6] * b[11] + a[7] * b[10] + a[8] * b[9] + a[9] * b[8] + a[10] * b[7] + a[11] * b[6] + a[12] * b[5] + a[13] * b[4] + a[14] * b[3] + a[15] * b[2];
        long c18 = a[3] * b[15] + a[4] * b[14] + a[5] * b[13] + a[6] * b[12] + a[7] * b[11] + a[8] * b[10] + a[9] * b[9] + a[10] * b[8] + a[11] * b[7] + a[12] * b[6] + a[13] * b[5] + a[14] * b[4] + a[15] * b[3];
        long c19 = a[4] * b[15] + a[5] * b[14] + a[6] * b[13] + a[7] * b[12] + a[8] * b[11] + a[9] * b[10] + a[10] * b[9] + a[11] * b[8] + a[12] * b[7] + a[13] * b[6] + a[14] * b[5] + a[15] * b[4];
        long c20 = a[5] * b[15] + a[6] * b[14] + a[7] * b[13] + a[8] * b[12] + a[9] * b[11] + a[10] * b[10] + a[11] * b[9] + a[12] * b[8] + a[13] * b[7] + a[14] * b[6] + a[15] * b[5];
        long c21 = a[6] * b[15] + a[7] * b[14] + a[8] * b[13] + a[9] * b[12] + a[10] * b[11] + a[11] * b[10] + a[12] * b[9] + a[13] * b[8] + a[14] * b[7] + a[15] * b[6];
        long c22 = a[7] * b[15] + a[8] * b[14] + a[9] * b[13] + a[10] * b[12] + a[11] * b[11] + a[12] * b[10] + a[13] * b[9] + a[14] * b[8] + a[15] * b[7];
        long c23 = a[8] * b[15] + a[9] * b[14] + a[10] * b[13] + a[11] * b[12] + a[12] * b[11] + a[13] * b[10] + a[14] * b[9] + a[15] * b[8];
        long c24 = a[9] * b[15] + a[10] * b[14] + a[11] * b[13] + a[12] * b[12] + a[13] * b[11] + a[14] * b[10] + a[15] * b[9];
        long c25 = a[10] * b[15] + a[11] * b[14] + a[12] * b[13] + a[13] * b[12] + a[14] * b[11] + a[15] * b[10];
        long c26 = a[11] * b[15] + a[12] * b[14] + a[13] * b[13] + a[14] * b[12] + a[15] * b[11];
        long c27 = a[12] * b[15] + a[13] * b[14] + a[14] * b[13] + a[15] * b[12];
        long c28 = a[13] * b[15] + a[14] * b[14] + a[15] * b[13];
        long c29 = a[14] * b[15] + a[15] * b[14];
        long c30 = a[15] * b[15];
        this.carryReduce(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30);
    }

    @Override
    protected void reduce(long[] a) {
        this.carryReduce(a, a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7], a[8], a[9], a[10], a[11], a[12], a[13], a[14], a[15]);
    }

    @Override
    protected void square(long[] a, long[] r) {
        long c0 = a[0] * a[0];
        long c1 = 2L * (a[0] * a[1]);
        long c2 = 2L * (a[0] * a[2]) + a[1] * a[1];
        long c3 = 2L * (a[0] * a[3] + a[1] * a[2]);
        long c4 = 2L * (a[0] * a[4] + a[1] * a[3]) + a[2] * a[2];
        long c5 = 2L * (a[0] * a[5] + a[1] * a[4] + a[2] * a[3]);
        long c6 = 2L * (a[0] * a[6] + a[1] * a[5] + a[2] * a[4]) + a[3] * a[3];
        long c7 = 2L * (a[0] * a[7] + a[1] * a[6] + a[2] * a[5] + a[3] * a[4]);
        long c8 = 2L * (a[0] * a[8] + a[1] * a[7] + a[2] * a[6] + a[3] * a[5]) + a[4] * a[4];
        long c9 = 2L * (a[0] * a[9] + a[1] * a[8] + a[2] * a[7] + a[3] * a[6] + a[4] * a[5]);
        long c10 = 2L * (a[0] * a[10] + a[1] * a[9] + a[2] * a[8] + a[3] * a[7] + a[4] * a[6]) + a[5] * a[5];
        long c11 = 2L * (a[0] * a[11] + a[1] * a[10] + a[2] * a[9] + a[3] * a[8] + a[4] * a[7] + a[5] * a[6]);
        long c12 = 2L * (a[0] * a[12] + a[1] * a[11] + a[2] * a[10] + a[3] * a[9] + a[4] * a[8] + a[5] * a[7]) + a[6] * a[6];
        long c13 = 2L * (a[0] * a[13] + a[1] * a[12] + a[2] * a[11] + a[3] * a[10] + a[4] * a[9] + a[5] * a[8] + a[6] * a[7]);
        long c14 = 2L * (a[0] * a[14] + a[1] * a[13] + a[2] * a[12] + a[3] * a[11] + a[4] * a[10] + a[5] * a[9] + a[6] * a[8]) + a[7] * a[7];
        long c15 = 2L * (a[0] * a[15] + a[1] * a[14] + a[2] * a[13] + a[3] * a[12] + a[4] * a[11] + a[5] * a[10] + a[6] * a[9] + a[7] * a[8]);
        long c16 = 2L * (a[1] * a[15] + a[2] * a[14] + a[3] * a[13] + a[4] * a[12] + a[5] * a[11] + a[6] * a[10] + a[7] * a[9]) + a[8] * a[8];
        long c17 = 2L * (a[2] * a[15] + a[3] * a[14] + a[4] * a[13] + a[5] * a[12] + a[6] * a[11] + a[7] * a[10] + a[8] * a[9]);
        long c18 = 2L * (a[3] * a[15] + a[4] * a[14] + a[5] * a[13] + a[6] * a[12] + a[7] * a[11] + a[8] * a[10]) + a[9] * a[9];
        long c19 = 2L * (a[4] * a[15] + a[5] * a[14] + a[6] * a[13] + a[7] * a[12] + a[8] * a[11] + a[9] * a[10]);
        long c20 = 2L * (a[5] * a[15] + a[6] * a[14] + a[7] * a[13] + a[8] * a[12] + a[9] * a[11]) + a[10] * a[10];
        long c21 = 2L * (a[6] * a[15] + a[7] * a[14] + a[8] * a[13] + a[9] * a[12] + a[10] * a[11]);
        long c22 = 2L * (a[7] * a[15] + a[8] * a[14] + a[9] * a[13] + a[10] * a[12]) + a[11] * a[11];
        long c23 = 2L * (a[8] * a[15] + a[9] * a[14] + a[10] * a[13] + a[11] * a[12]);
        long c24 = 2L * (a[9] * a[15] + a[10] * a[14] + a[11] * a[13]) + a[12] * a[12];
        long c25 = 2L * (a[10] * a[15] + a[11] * a[14] + a[12] * a[13]);
        long c26 = 2L * (a[11] * a[15] + a[12] * a[14]) + a[13] * a[13];
        long c27 = 2L * (a[12] * a[15] + a[13] * a[14]);
        long c28 = 2L * (a[13] * a[15]) + a[14] * a[14];
        long c29 = 2L * (a[14] * a[15]);
        long c30 = a[15] * a[15];
        this.carryReduce(r, c0, c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21, c22, c23, c24, c25, c26, c27, c28, c29, c30);
    }
}

