/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.CryptoUtils;
import com.tencent.kona.crypto.provider.GCM;
import com.tencent.kona.crypto.provider.GFMultiplier;
import com.tencent.kona.crypto.provider.GFMultipliers;
import com.tencent.kona.sun.security.action.GetPropertyAction;
import java.nio.ByteBuffer;
import java.security.ProviderException;

final class GHASH
implements Cloneable,
GCM {
    private static final String PRE_TABLE_SIZE = GetPropertyAction.privilegedGetProperty("com.tencent.kona.crypto.gcm.preTableSize", "32K");
    private static final int SM4_BLOCK_SIZE = 16;
    private static final int MAX_LEN = 1024;
    private long[] subkeyHtbl;
    private final long[] state;
    private long stateSave0;
    private long stateSave1;
    private final GFMultiplier multiplier;

    private static long getLong(byte[] buffer, int offset) {
        long result = 0L;
        int end = offset + 8;
        for (int i = offset; i < end; ++i) {
            result = (result << 8) + (long)(buffer[i] & 0xFF);
        }
        return result;
    }

    private static void putLong(byte[] buffer, int offset, long value) {
        int end = offset + 8;
        for (int i = end - 1; i >= offset; --i) {
            buffer[i] = (byte)value;
            value >>= 8;
        }
    }

    GHASH(byte[] subkeyH) throws ProviderException {
        if (subkeyH == null || subkeyH.length != 16) {
            throw new ProviderException("Internal error");
        }
        this.state = new long[2];
        this.subkeyHtbl = new long[18];
        this.subkeyHtbl[0] = GHASH.getLong(subkeyH, 0);
        this.subkeyHtbl[1] = GHASH.getLong(subkeyH, 8);
        this.multiplier = this.multiplier(subkeyH);
    }

    private GHASH(GHASH g) {
        this.state = (long[])g.state.clone();
        this.subkeyHtbl = (long[])g.subkeyHtbl.clone();
        byte[] subkeyH = new byte[16];
        CryptoUtils.longToBytes8(this.subkeyHtbl[0], subkeyH, 0);
        CryptoUtils.longToBytes8(this.subkeyHtbl[1], subkeyH, 8);
        this.multiplier = this.multiplier(subkeyH);
    }

    private GFMultiplier multiplier(byte[] subkeyH) {
        if ("32K".equalsIgnoreCase(PRE_TABLE_SIZE)) {
            return GFMultipliers.gfmWith32KPreTable(subkeyH);
        }
        return GFMultipliers.gfmWithoutPreTable(subkeyH);
    }

    public GHASH clone() {
        return new GHASH(this);
    }

    void reset() {
        this.state[0] = 0L;
        this.state[1] = 0L;
    }

    void save() {
        this.stateSave0 = this.state[0];
        this.stateSave1 = this.state[1];
    }

    void restore() {
        this.state[0] = this.stateSave0;
        this.state[1] = this.stateSave1;
    }

    private void processBlock(byte[] data, int ofs, long[] st) {
        st[0] = st[0] ^ GHASH.getLong(data, ofs);
        st[1] = st[1] ^ GHASH.getLong(data, ofs + 8);
        this.multiplier.multiply(st);
    }

    int update(byte[] in) {
        return this.update(in, 0, in.length);
    }

    int update(byte[] in, int inOfs, int inLen) {
        if (inLen == 0) {
            return 0;
        }
        int len = inLen - inLen % 16;
        GHASH.ghashRangeCheck(in, inOfs, len, this.state, this.subkeyHtbl);
        this.processBlocks(in, inOfs, len / 16, this.state);
        return len;
    }

    int update(ByteBuffer ct, int inLen) {
        int to_process;
        if ((inLen -= inLen % 16) == 0) {
            return 0;
        }
        if (ct.isDirect()) {
            int processed = inLen;
            this.processBlocksDirect(ct, inLen);
            return processed;
        }
        if (!ct.isReadOnly()) {
            int processed = this.update(ct.array(), ct.arrayOffset() + ct.position(), inLen);
            ct.position(ct.position() + processed);
            return processed;
        }
        byte[] in = new byte[Math.min(1024, inLen)];
        for (to_process = inLen; to_process > 1024; to_process -= 1024) {
            ct.get(in, 0, 1024);
            this.update(in, 0, 1024);
        }
        ct.get(in, 0, to_process);
        this.update(in, 0, to_process);
        return inLen;
    }

    int doFinal(ByteBuffer src, int inLen) {
        int processed = 0;
        if (inLen >= 16) {
            processed = this.update(src, inLen);
        }
        if (inLen == processed) {
            return processed;
        }
        byte[] block = new byte[16];
        src.get(block, 0, inLen - processed);
        this.update(block, 0, 16);
        return inLen;
    }

    int doFinal(byte[] in, int inOfs, int inLen) {
        int remainder = inLen % 16;
        inOfs += this.update(in, inOfs, inLen - remainder);
        if (remainder > 0) {
            byte[] block = new byte[16];
            System.arraycopy(in, inOfs, block, 0, remainder);
            this.update(block, 0, 16);
        }
        return inLen;
    }

    private static void ghashRangeCheck(byte[] in, int inOfs, int inLen, long[] st, long[] subH) {
        if (inLen < 0) {
            throw new RuntimeException("invalid input length: " + inLen);
        }
        if (inOfs < 0) {
            throw new RuntimeException("invalid offset: " + inOfs);
        }
        if (inLen > in.length - inOfs) {
            throw new RuntimeException("input length out of bound: " + inLen + " > " + (in.length - inOfs));
        }
        if (inLen % 16 != 0) {
            throw new RuntimeException("input length/block size mismatch: " + inLen);
        }
        if (st.length != 2) {
            throw new RuntimeException("internal state has invalid length: " + st.length);
        }
        if (subH.length != 18) {
            throw new RuntimeException("internal subkeyHtbl has invalid length: " + subH.length);
        }
    }

    private void processBlocks(byte[] data, int inOfs, int blocks, long[] st) {
        int offset = inOfs;
        while (blocks > 0) {
            this.processBlock(data, offset, st);
            --blocks;
            offset += 16;
        }
    }

    private void processBlocksDirect(ByteBuffer ct, int inLen) {
        byte[] data = new byte[Math.min(1024, inLen)];
        while (inLen > 1024) {
            ct.get(data, 0, 1024);
            this.processBlocks(data, 0, 64, this.state);
            inLen -= 1024;
        }
        if (inLen >= 16) {
            int len = inLen - inLen % 16;
            ct.get(data, 0, len);
            this.processBlocks(data, 0, len / 16, this.state);
        }
    }

    byte[] digest() {
        byte[] result = new byte[16];
        GHASH.putLong(result, 0, this.state[0]);
        GHASH.putLong(result, 8, this.state[1]);
        this.reset();
        return result;
    }

    @Override
    public int update(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) {
        return this.update(in, inOfs, inLen);
    }

    @Override
    public int update(byte[] in, int inOfs, int inLen, ByteBuffer dst) {
        return this.update(in, inOfs, inLen);
    }

    @Override
    public int update(ByteBuffer src, ByteBuffer dst) {
        return this.update(src, src.remaining());
    }

    @Override
    public int doFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) {
        return this.doFinal(in, inOfs, inLen);
    }

    @Override
    public int doFinal(ByteBuffer src, ByteBuffer dst) {
        return this.doFinal(src, src.remaining());
    }
}

