/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.crypto.provider;

import com.tencent.kona.crypto.provider.SM3Engine;
import java.security.DigestException;
import java.security.MessageDigest;

public final class SM3MessageDigest
extends MessageDigest
implements Cloneable {
    private SM3Engine engine = new SM3Engine();

    public SM3MessageDigest() {
        super("SM3");
    }

    @Override
    protected int engineGetDigestLength() {
        return 32;
    }

    @Override
    protected void engineUpdate(byte input) {
        this.engine.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int length) {
        this.engine.update(input, offset, length);
    }

    @Override
    protected byte[] engineDigest() {
        byte[] digest = new byte[32];
        this.engine.doFinal(digest);
        return digest;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int length) throws DigestException {
        if (length != 32) {
            throw new DigestException("THe length must be 32-bytes");
        }
        this.engine.doFinal(buf, offset);
        return 32;
    }

    @Override
    protected void engineReset() {
        this.engine.reset();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SM3MessageDigest clone = (SM3MessageDigest)super.clone();
        clone.engine = this.engine.clone();
        return clone;
    }
}

