/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.kona.jdk.internal.misc;

import com.tencent.kona.crypto.CryptoUtils;
import java.io.Console;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.EncodedKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class SharedSecretsUtil {
    private static final boolean USE_SHARED_SECRETS = CryptoUtils.privilegedGetBoolProperty("com.tencent.misc.useSharedSecrets", CryptoUtils.isJdk8() ? "true" : "false");
    private static final Method langNewStringNoRepl;
    private static final Method initialSystemIn;
    private static final Object langAccess;
    private static final Method console;
    private static final Method charset;
    private static final Object ioAccess;
    private static final Method cryptoSpecClearSecretKeySpec;
    private static final Object cryptoSpecAccess;
    private static final Method netInetAddressGetOriginalHostName;
    private static final Object netInetAddressAccess;
    private static final Method secSignatureInitVerifyWithPubKey;
    private static final Method secSignatureInitVerifyWithCert;
    private static final Method secSignatureInitSign;
    private static final Object secSignatureAccess;
    private static final Method secSpecClearEncodedKeySpec;
    private static final Object secSpecAccess;

    private static boolean useSharedSecrets() {
        return USE_SHARED_SECRETS && !CryptoUtils.isAndroid();
    }

    public static String langNewStringNoRepl(byte[] bytes, Charset cs) throws CharacterCodingException {
        if (langNewStringNoRepl == null) {
            return new String(bytes, cs);
        }
        try {
            return (String)langNewStringNoRepl.invoke(langAccess, bytes, cs);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("getOriginalHostName failed", e);
        }
    }

    public static InputStream initialSystemIn() {
        if (initialSystemIn == null) {
            return System.in;
        }
        try {
            return (InputStream)initialSystemIn.invoke(langAccess, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("initialSystemIn failed", e);
        }
    }

    public static Console console() {
        if (console == null) {
            return null;
        }
        try {
            return (Console)console.invoke(ioAccess, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("console failed", e);
        }
    }

    public static Charset charset() {
        if (charset == null) {
            return null;
        }
        try {
            return (Charset)charset.invoke(ioAccess, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("charset failed", e);
        }
    }

    public static void cryptoSpecClearSecretKeySpec(SecretKeySpec keySpec) {
        if (cryptoSpecClearSecretKeySpec == null) {
            return;
        }
        try {
            cryptoSpecClearSecretKeySpec.invoke(cryptoSpecAccess, keySpec);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("specAccessClearEncodedKeySpec failed", e);
        }
    }

    public static String netInetAddressGetOriginalHostName(InetAddress inetAddress) {
        if (netInetAddressGetOriginalHostName == null) {
            return inetAddress.getHostName();
        }
        try {
            return (String)netInetAddressGetOriginalHostName.invoke(netInetAddressAccess, inetAddress);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("getOriginalHostName failed", e);
        }
    }

    public static void secSignatureInitVerify(Signature signature, PublicKey publicKey, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secSignatureInitVerifyWithPubKey == null) {
            if (params != null) {
                signature.setParameter(params);
            }
            signature.initVerify(publicKey);
        } else {
            try {
                secSignatureInitVerifyWithPubKey.invoke(secSignatureAccess, signature, publicKey, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("signatureAccessInitVerify failed", e);
            }
        }
    }

    public static void secSignatureInitVerify(Signature signature, Certificate certificate, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secSignatureInitVerifyWithCert == null) {
            if (params != null) {
                signature.setParameter(params);
            }
            signature.initVerify(certificate);
        } else {
            try {
                secSignatureInitVerifyWithCert.invoke(secSignatureAccess, signature, certificate, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("signatureAccessInitVerify failed", e);
            }
        }
    }

    public static void secSignatureInitSign(Signature signature, PrivateKey privateKey, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (secSignatureInitSign == null) {
            if (params != null) {
                signature.setParameter(params);
            }
            signature.initSign(privateKey, random);
        } else {
            try {
                secSignatureInitSign.invoke(secSignatureAccess, signature, privateKey, params, random);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("signatureAccessInitSign failed", e);
            }
        }
    }

    public static void secSpecClearEncodedKeySpec(EncodedKeySpec keySpec) {
        if (secSpecClearEncodedKeySpec == null) {
            return;
        }
        try {
            secSpecClearEncodedKeySpec.invoke(secSpecAccess, keySpec);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("specAccessClearEncodedKeySpec failed", e);
        }
    }

    private static Object getAccessObject(Class<?> sharedSecretsClass, String sharedSecretedMethodName) {
        try {
            Method sharedSecretedMethod = sharedSecretsClass.getDeclaredMethod(sharedSecretedMethodName, new Class[0]);
            sharedSecretedMethod.setAccessible(true);
            return sharedSecretedMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new InternalError("Cannot get access object", e);
        }
    }

    static {
        Class<?> sharedSecretsClass = null;
        Class<?> javaLangAccessClass = null;
        Class<?> javaIOAccessClass = null;
        Class<?> javaxCryptoSpecAccessClass = null;
        Class<?> inetAddressAccessClass = null;
        Class<?> secSignatureAccessClass = null;
        Class<?> secSpecAccessClass = null;
        if (SharedSecretsUtil.useSharedSecrets()) {
            try {
                if (CryptoUtils.isJdk8()) {
                    sharedSecretsClass = Class.forName("sun.misc.SharedSecrets");
                    javaLangAccessClass = Class.forName("sun.misc.JavaLangAccess");
                    javaIOAccessClass = Class.forName("sun.misc.JavaIOAccess");
                    inetAddressAccessClass = Class.forName("sun.misc.JavaNetAccess");
                    secSignatureAccessClass = Class.forName("sun.misc.JavaSecuritySignatureAccess");
                } else if (CryptoUtils.isJdk11()) {
                    sharedSecretsClass = Class.forName("jdk.internal.misc.SharedSecrets");
                    javaLangAccessClass = Class.forName("jdk.internal.misc.JavaLangAccess");
                    javaIOAccessClass = Class.forName("jdk.internal.misc.JavaIOAccess");
                    inetAddressAccessClass = Class.forName("jdk.internal.misc.JavaNetInetAddressAccess");
                    secSignatureAccessClass = Class.forName("jdk.internal.misc.JavaSecuritySignatureAccess");
                } else if (CryptoUtils.isJdk17()) {
                    sharedSecretsClass = Class.forName("jdk.internal.access.SharedSecrets");
                    javaLangAccessClass = Class.forName("jdk.internal.access.JavaLangAccess");
                    javaIOAccessClass = Class.forName("jdk.internal.access.JavaIOAccess");
                    javaxCryptoSpecAccessClass = Class.forName("jdk.internal.access.JavaxCryptoSpecAccess");
                    inetAddressAccessClass = Class.forName("jdk.internal.access.JavaNetInetAddressAccess");
                    secSignatureAccessClass = Class.forName("jdk.internal.access.JavaSecuritySignatureAccess");
                    secSpecAccessClass = Class.forName("jdk.internal.access.JavaSecuritySpecAccess");
                }
            }
            catch (ClassNotFoundException e) {
                throw new InternalError("Cannot get SharedSecrets class", e);
            }
        }
        if (sharedSecretsClass != null) {
            try {
                langNewStringNoRepl = CryptoUtils.isJdk8() ? null : javaLangAccessClass.getMethod("newStringNoRepl", byte[].class, Charset.class);
                initialSystemIn = CryptoUtils.isJdk8() ? null : javaLangAccessClass.getMethod("initialSystemIn", new Class[0]);
                console = javaIOAccessClass.getMethod("console", new Class[0]);
                charset = javaIOAccessClass.getMethod("charset", new Class[0]);
                cryptoSpecClearSecretKeySpec = javaxCryptoSpecAccessClass != null ? javaxCryptoSpecAccessClass.getMethod("clearSecretKeySpec", SecretKeySpec.class) : null;
                netInetAddressGetOriginalHostName = inetAddressAccessClass.getMethod("getOriginalHostName", InetAddress.class);
                secSignatureInitVerifyWithPubKey = secSignatureAccessClass.getMethod("initVerify", Signature.class, PublicKey.class, AlgorithmParameterSpec.class);
                secSignatureInitVerifyWithCert = secSignatureAccessClass.getMethod("initVerify", Signature.class, Certificate.class, AlgorithmParameterSpec.class);
                secSignatureInitSign = secSignatureAccessClass.getMethod("initSign", Signature.class, PrivateKey.class, AlgorithmParameterSpec.class, SecureRandom.class);
                secSpecClearEncodedKeySpec = secSpecAccessClass == null ? null : secSpecAccessClass.getMethod("clearEncodedKeySpec", EncodedKeySpec.class);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError("Cannot get method", e);
            }
            langAccess = SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaLangAccess");
            ioAccess = SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaIOAccess");
            cryptoSpecAccess = CryptoUtils.isJdk17() ? SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaxCryptoSpecAccess") : null;
            netInetAddressAccess = CryptoUtils.isJdk8() ? SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaNetAccess") : SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaNetInetAddressAccess");
            secSignatureAccess = SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaSecuritySignatureAccess");
            secSpecAccess = CryptoUtils.isJdk17() ? SharedSecretsUtil.getAccessObject(sharedSecretsClass, "getJavaSecuritySpecAccess") : null;
        } else {
            langNewStringNoRepl = null;
            initialSystemIn = null;
            langAccess = null;
            console = null;
            charset = null;
            ioAccess = null;
            cryptoSpecClearSecretKeySpec = null;
            cryptoSpecAccess = null;
            netInetAddressGetOriginalHostName = null;
            netInetAddressAccess = null;
            secSignatureInitVerifyWithPubKey = null;
            secSignatureInitVerifyWithCert = null;
            secSignatureInitSign = null;
            secSignatureAccess = null;
            secSpecClearEncodedKeySpec = null;
            secSpecAccess = null;
        }
    }
}

